/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Account takeover actions type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountTakeoverActionsType implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountTakeoverActionsType.Builder, AccountTakeoverActionsType> {
    private static final SdkField<AccountTakeoverActionType> LOW_ACTION_FIELD = SdkField
            .<AccountTakeoverActionType> builder(MarshallingType.SDK_POJO).memberName("LowAction")
            .getter(getter(AccountTakeoverActionsType::lowAction)).setter(setter(Builder::lowAction))
            .constructor(AccountTakeoverActionType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowAction").build()).build();

    private static final SdkField<AccountTakeoverActionType> MEDIUM_ACTION_FIELD = SdkField
            .<AccountTakeoverActionType> builder(MarshallingType.SDK_POJO).memberName("MediumAction")
            .getter(getter(AccountTakeoverActionsType::mediumAction)).setter(setter(Builder::mediumAction))
            .constructor(AccountTakeoverActionType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediumAction").build()).build();

    private static final SdkField<AccountTakeoverActionType> HIGH_ACTION_FIELD = SdkField
            .<AccountTakeoverActionType> builder(MarshallingType.SDK_POJO).memberName("HighAction")
            .getter(getter(AccountTakeoverActionsType::highAction)).setter(setter(Builder::highAction))
            .constructor(AccountTakeoverActionType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HighAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOW_ACTION_FIELD,
            MEDIUM_ACTION_FIELD, HIGH_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LowAction", LOW_ACTION_FIELD);
                    put("MediumAction", MEDIUM_ACTION_FIELD);
                    put("HighAction", HIGH_ACTION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final AccountTakeoverActionType lowAction;

    private final AccountTakeoverActionType mediumAction;

    private final AccountTakeoverActionType highAction;

    private AccountTakeoverActionsType(BuilderImpl builder) {
        this.lowAction = builder.lowAction;
        this.mediumAction = builder.mediumAction;
        this.highAction = builder.highAction;
    }

    /**
     * <p>
     * Action to take for a low risk.
     * </p>
     * 
     * @return Action to take for a low risk.
     */
    public final AccountTakeoverActionType lowAction() {
        return lowAction;
    }

    /**
     * <p>
     * Action to take for a medium risk.
     * </p>
     * 
     * @return Action to take for a medium risk.
     */
    public final AccountTakeoverActionType mediumAction() {
        return mediumAction;
    }

    /**
     * <p>
     * Action to take for a high risk.
     * </p>
     * 
     * @return Action to take for a high risk.
     */
    public final AccountTakeoverActionType highAction() {
        return highAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lowAction());
        hashCode = 31 * hashCode + Objects.hashCode(mediumAction());
        hashCode = 31 * hashCode + Objects.hashCode(highAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountTakeoverActionsType)) {
            return false;
        }
        AccountTakeoverActionsType other = (AccountTakeoverActionsType) obj;
        return Objects.equals(lowAction(), other.lowAction()) && Objects.equals(mediumAction(), other.mediumAction())
                && Objects.equals(highAction(), other.highAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountTakeoverActionsType").add("LowAction", lowAction()).add("MediumAction", mediumAction())
                .add("HighAction", highAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LowAction":
            return Optional.ofNullable(clazz.cast(lowAction()));
        case "MediumAction":
            return Optional.ofNullable(clazz.cast(mediumAction()));
        case "HighAction":
            return Optional.ofNullable(clazz.cast(highAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccountTakeoverActionsType, T> g) {
        return obj -> g.apply((AccountTakeoverActionsType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountTakeoverActionsType> {
        /**
         * <p>
         * Action to take for a low risk.
         * </p>
         * 
         * @param lowAction
         *        Action to take for a low risk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowAction(AccountTakeoverActionType lowAction);

        /**
         * <p>
         * Action to take for a low risk.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountTakeoverActionType.Builder}
         * avoiding the need to create one manually via {@link AccountTakeoverActionType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountTakeoverActionType.Builder#build()} is called immediately
         * and its result is passed to {@link #lowAction(AccountTakeoverActionType)}.
         * 
         * @param lowAction
         *        a consumer that will call methods on {@link AccountTakeoverActionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lowAction(AccountTakeoverActionType)
         */
        default Builder lowAction(Consumer<AccountTakeoverActionType.Builder> lowAction) {
            return lowAction(AccountTakeoverActionType.builder().applyMutation(lowAction).build());
        }

        /**
         * <p>
         * Action to take for a medium risk.
         * </p>
         * 
         * @param mediumAction
         *        Action to take for a medium risk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediumAction(AccountTakeoverActionType mediumAction);

        /**
         * <p>
         * Action to take for a medium risk.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountTakeoverActionType.Builder}
         * avoiding the need to create one manually via {@link AccountTakeoverActionType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountTakeoverActionType.Builder#build()} is called immediately
         * and its result is passed to {@link #mediumAction(AccountTakeoverActionType)}.
         * 
         * @param mediumAction
         *        a consumer that will call methods on {@link AccountTakeoverActionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediumAction(AccountTakeoverActionType)
         */
        default Builder mediumAction(Consumer<AccountTakeoverActionType.Builder> mediumAction) {
            return mediumAction(AccountTakeoverActionType.builder().applyMutation(mediumAction).build());
        }

        /**
         * <p>
         * Action to take for a high risk.
         * </p>
         * 
         * @param highAction
         *        Action to take for a high risk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highAction(AccountTakeoverActionType highAction);

        /**
         * <p>
         * Action to take for a high risk.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountTakeoverActionType.Builder}
         * avoiding the need to create one manually via {@link AccountTakeoverActionType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountTakeoverActionType.Builder#build()} is called immediately
         * and its result is passed to {@link #highAction(AccountTakeoverActionType)}.
         * 
         * @param highAction
         *        a consumer that will call methods on {@link AccountTakeoverActionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #highAction(AccountTakeoverActionType)
         */
        default Builder highAction(Consumer<AccountTakeoverActionType.Builder> highAction) {
            return highAction(AccountTakeoverActionType.builder().applyMutation(highAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AccountTakeoverActionType lowAction;

        private AccountTakeoverActionType mediumAction;

        private AccountTakeoverActionType highAction;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountTakeoverActionsType model) {
            lowAction(model.lowAction);
            mediumAction(model.mediumAction);
            highAction(model.highAction);
        }

        public final AccountTakeoverActionType.Builder getLowAction() {
            return lowAction != null ? lowAction.toBuilder() : null;
        }

        public final void setLowAction(AccountTakeoverActionType.BuilderImpl lowAction) {
            this.lowAction = lowAction != null ? lowAction.build() : null;
        }

        @Override
        public final Builder lowAction(AccountTakeoverActionType lowAction) {
            this.lowAction = lowAction;
            return this;
        }

        public final AccountTakeoverActionType.Builder getMediumAction() {
            return mediumAction != null ? mediumAction.toBuilder() : null;
        }

        public final void setMediumAction(AccountTakeoverActionType.BuilderImpl mediumAction) {
            this.mediumAction = mediumAction != null ? mediumAction.build() : null;
        }

        @Override
        public final Builder mediumAction(AccountTakeoverActionType mediumAction) {
            this.mediumAction = mediumAction;
            return this;
        }

        public final AccountTakeoverActionType.Builder getHighAction() {
            return highAction != null ? highAction.toBuilder() : null;
        }

        public final void setHighAction(AccountTakeoverActionType.BuilderImpl highAction) {
            this.highAction = highAction != null ? highAction.build() : null;
        }

        @Override
        public final Builder highAction(AccountTakeoverActionType highAction) {
            this.highAction = highAction;
            return this;
        }

        @Override
        public AccountTakeoverActionsType build() {
            return new AccountTakeoverActionsType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
