/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to delete a user as an administrator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminDeleteUserRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<AdminDeleteUserRequest.Builder, AdminDeleteUserRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(AdminDeleteUserRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(AdminDeleteUserRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            USERNAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("UserPoolId", USER_POOL_ID_FIELD);
                    put("Username", USERNAME_FIELD);
                }
            });

    private final String userPoolId;

    private final String username;

    private AdminDeleteUserRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.username = builder.username;
    }

    /**
     * <p>
     * The user pool ID for the user pool where you want to delete the user.
     * </p>
     * 
     * @return The user pool ID for the user pool where you want to delete the user.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The username of the user that you want to query or modify. The value of this parameter is typically your user's
     * username, but it can be any of their alias attributes. If <code>username</code> isn't an alias attribute in your
     * user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party
     * IdP.
     * </p>
     * 
     * @return The username of the user that you want to query or modify. The value of this parameter is typically your
     *         user's username, but it can be any of their alias attributes. If <code>username</code> isn't an alias
     *         attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a
     *         user from a third-party IdP.
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminDeleteUserRequest)) {
            return false;
        }
        AdminDeleteUserRequest other = (AdminDeleteUserRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdminDeleteUserRequest").add("UserPoolId", userPoolId())
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AdminDeleteUserRequest, T> g) {
        return obj -> g.apply((AdminDeleteUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AdminDeleteUserRequest> {
        /**
         * <p>
         * The user pool ID for the user pool where you want to delete the user.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool where you want to delete the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The username of the user that you want to query or modify. The value of this parameter is typically your
         * user's username, but it can be any of their alias attributes. If <code>username</code> isn't an alias
         * attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a
         * user from a third-party IdP.
         * </p>
         * 
         * @param username
         *        The username of the user that you want to query or modify. The value of this parameter is typically
         *        your user's username, but it can be any of their alias attributes. If <code>username</code> isn't an
         *        alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the
         *        username of a user from a third-party IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminDeleteUserRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            username(model.username);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminDeleteUserRequest build() {
            return new AdminDeleteUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
