/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResourceServerResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<DescribeResourceServerResponse.Builder, DescribeResourceServerResponse> {
    private static final SdkField<ResourceServerType> RESOURCE_SERVER_FIELD = SdkField
            .<ResourceServerType> builder(MarshallingType.SDK_POJO).memberName("ResourceServer")
            .getter(getter(DescribeResourceServerResponse::resourceServer)).setter(setter(Builder::resourceServer))
            .constructor(ResourceServerType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceServer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SERVER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ResourceServer", RESOURCE_SERVER_FIELD);
                }
            });

    private final ResourceServerType resourceServer;

    private DescribeResourceServerResponse(BuilderImpl builder) {
        super(builder);
        this.resourceServer = builder.resourceServer;
    }

    /**
     * <p>
     * The resource server.
     * </p>
     * 
     * @return The resource server.
     */
    public final ResourceServerType resourceServer() {
        return resourceServer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceServer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceServerResponse)) {
            return false;
        }
        DescribeResourceServerResponse other = (DescribeResourceServerResponse) obj;
        return Objects.equals(resourceServer(), other.resourceServer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeResourceServerResponse").add("ResourceServer", resourceServer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceServer":
            return Optional.ofNullable(clazz.cast(resourceServer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceServerResponse, T> g) {
        return obj -> g.apply((DescribeResourceServerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeResourceServerResponse> {
        /**
         * <p>
         * The resource server.
         * </p>
         * 
         * @param resourceServer
         *        The resource server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceServer(ResourceServerType resourceServer);

        /**
         * <p>
         * The resource server.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceServerType.Builder} avoiding the
         * need to create one manually via {@link ResourceServerType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceServerType.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceServer(ResourceServerType)}.
         * 
         * @param resourceServer
         *        a consumer that will call methods on {@link ResourceServerType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceServer(ResourceServerType)
         */
        default Builder resourceServer(Consumer<ResourceServerType.Builder> resourceServer) {
            return resourceServer(ResourceServerType.builder().applyMutation(resourceServer).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private ResourceServerType resourceServer;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceServerResponse model) {
            super(model);
            resourceServer(model.resourceServer);
        }

        public final ResourceServerType.Builder getResourceServer() {
            return resourceServer != null ? resourceServer.toBuilder() : null;
        }

        public final void setResourceServer(ResourceServerType.BuilderImpl resourceServer) {
            this.resourceServer = resourceServer != null ? resourceServer.build() : null;
        }

        @Override
        public final Builder resourceServer(ResourceServerType resourceServer) {
            this.resourceServer = resourceServer;
            return this;
        }

        @Override
        public DescribeResourceServerResponse build() {
            return new DescribeResourceServerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
