/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The device-remembering configuration for a user pool. A <a
 * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html">
 * DescribeUserPool</a> request returns a null value for this object when the user pool isn't configured to remember
 * devices. When device remembering is active, you can remember a user's device with a <a
 * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html"
 * >ConfirmDevice</a> API request. Additionally. when the property <code>DeviceOnlyRememberedOnUserPrompt</code> is
 * <code>true</code>, you must follow <code>ConfirmDevice</code> with an <a
 * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html"
 * >UpdateDeviceStatus</a> API request that sets the user's device to <code>remembered</code> or
 * <code>not_remembered</code>.
 * </p>
 * <p>
 * To sign in with a remembered device, include <code>DEVICE_KEY</code> in the authentication parameters in your user's
 * <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">
 * InitiateAuth</a> request. If your app doesn't include a <code>DEVICE_KEY</code> parameter, the <a href=
 * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html#API_InitiateAuth_ResponseSyntax"
 * >response</a> from Amazon Cognito includes newly-generated <code>DEVICE_KEY</code> and <code>DEVICE_GROUP_KEY</code>
 * values under <code>NewDeviceMetadata</code>. Store these values to use in future device-authentication requests.
 * </p>
 * <note>
 * <p>
 * When you provide a value for any property of <code>DeviceConfiguration</code>, you activate the device remembering
 * for the user pool.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceConfigurationType.Builder, DeviceConfigurationType> {
    private static final SdkField<Boolean> CHALLENGE_REQUIRED_ON_NEW_DEVICE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ChallengeRequiredOnNewDevice")
            .getter(getter(DeviceConfigurationType::challengeRequiredOnNewDevice))
            .setter(setter(Builder::challengeRequiredOnNewDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeRequiredOnNewDevice")
                    .build()).build();

    private static final SdkField<Boolean> DEVICE_ONLY_REMEMBERED_ON_USER_PROMPT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeviceOnlyRememberedOnUserPrompt")
            .getter(getter(DeviceConfigurationType::deviceOnlyRememberedOnUserPrompt))
            .setter(setter(Builder::deviceOnlyRememberedOnUserPrompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceOnlyRememberedOnUserPrompt")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CHALLENGE_REQUIRED_ON_NEW_DEVICE_FIELD, DEVICE_ONLY_REMEMBERED_ON_USER_PROMPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ChallengeRequiredOnNewDevice", CHALLENGE_REQUIRED_ON_NEW_DEVICE_FIELD);
                    put("DeviceOnlyRememberedOnUserPrompt", DEVICE_ONLY_REMEMBERED_ON_USER_PROMPT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean challengeRequiredOnNewDevice;

    private final Boolean deviceOnlyRememberedOnUserPrompt;

    private DeviceConfigurationType(BuilderImpl builder) {
        this.challengeRequiredOnNewDevice = builder.challengeRequiredOnNewDevice;
        this.deviceOnlyRememberedOnUserPrompt = builder.deviceOnlyRememberedOnUserPrompt;
    }

    /**
     * <p>
     * When true, a remembered device can sign in with device authentication instead of SMS and time-based one-time
     * password (TOTP) factors for multi-factor authentication (MFA).
     * </p>
     * <note>
     * <p>
     * Whether or not <code>ChallengeRequiredOnNewDevice</code> is true, users who sign in with devices that have not
     * been confirmed or remembered must still provide a second factor in a user pool that requires MFA.
     * </p>
     * </note>
     * 
     * @return When true, a remembered device can sign in with device authentication instead of SMS and time-based
     *         one-time password (TOTP) factors for multi-factor authentication (MFA).</p> <note>
     *         <p>
     *         Whether or not <code>ChallengeRequiredOnNewDevice</code> is true, users who sign in with devices that
     *         have not been confirmed or remembered must still provide a second factor in a user pool that requires
     *         MFA.
     *         </p>
     */
    public final Boolean challengeRequiredOnNewDevice() {
        return challengeRequiredOnNewDevice;
    }

    /**
     * <p>
     * When true, Amazon Cognito doesn't automatically remember a user's device when your app sends a <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html">
     * ConfirmDevice</a> API request. In your app, create a prompt for your user to choose whether they want to remember
     * their device. Return the user's choice in an <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html">
     * UpdateDeviceStatus</a> API request.
     * </p>
     * <p>
     * When <code>DeviceOnlyRememberedOnUserPrompt</code> is <code>false</code>, Amazon Cognito immediately remembers
     * devices that you register in a <code>ConfirmDevice</code> API request.
     * </p>
     * 
     * @return When true, Amazon Cognito doesn't automatically remember a user's device when your app sends a <a
     *         href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html"
     *         > ConfirmDevice</a> API request. In your app, create a prompt for your user to choose whether they want
     *         to remember their device. Return the user's choice in an <a href=
     *         "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html"
     *         > UpdateDeviceStatus</a> API request.</p>
     *         <p>
     *         When <code>DeviceOnlyRememberedOnUserPrompt</code> is <code>false</code>, Amazon Cognito immediately
     *         remembers devices that you register in a <code>ConfirmDevice</code> API request.
     */
    public final Boolean deviceOnlyRememberedOnUserPrompt() {
        return deviceOnlyRememberedOnUserPrompt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(challengeRequiredOnNewDevice());
        hashCode = 31 * hashCode + Objects.hashCode(deviceOnlyRememberedOnUserPrompt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceConfigurationType)) {
            return false;
        }
        DeviceConfigurationType other = (DeviceConfigurationType) obj;
        return Objects.equals(challengeRequiredOnNewDevice(), other.challengeRequiredOnNewDevice())
                && Objects.equals(deviceOnlyRememberedOnUserPrompt(), other.deviceOnlyRememberedOnUserPrompt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceConfigurationType").add("ChallengeRequiredOnNewDevice", challengeRequiredOnNewDevice())
                .add("DeviceOnlyRememberedOnUserPrompt", deviceOnlyRememberedOnUserPrompt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChallengeRequiredOnNewDevice":
            return Optional.ofNullable(clazz.cast(challengeRequiredOnNewDevice()));
        case "DeviceOnlyRememberedOnUserPrompt":
            return Optional.ofNullable(clazz.cast(deviceOnlyRememberedOnUserPrompt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeviceConfigurationType, T> g) {
        return obj -> g.apply((DeviceConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceConfigurationType> {
        /**
         * <p>
         * When true, a remembered device can sign in with device authentication instead of SMS and time-based one-time
         * password (TOTP) factors for multi-factor authentication (MFA).
         * </p>
         * <note>
         * <p>
         * Whether or not <code>ChallengeRequiredOnNewDevice</code> is true, users who sign in with devices that have
         * not been confirmed or remembered must still provide a second factor in a user pool that requires MFA.
         * </p>
         * </note>
         * 
         * @param challengeRequiredOnNewDevice
         *        When true, a remembered device can sign in with device authentication instead of SMS and time-based
         *        one-time password (TOTP) factors for multi-factor authentication (MFA).</p> <note>
         *        <p>
         *        Whether or not <code>ChallengeRequiredOnNewDevice</code> is true, users who sign in with devices that
         *        have not been confirmed or remembered must still provide a second factor in a user pool that requires
         *        MFA.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challengeRequiredOnNewDevice(Boolean challengeRequiredOnNewDevice);

        /**
         * <p>
         * When true, Amazon Cognito doesn't automatically remember a user's device when your app sends a <a
         * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html">
         * ConfirmDevice</a> API request. In your app, create a prompt for your user to choose whether they want to
         * remember their device. Return the user's choice in an <a href=
         * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html">
         * UpdateDeviceStatus</a> API request.
         * </p>
         * <p>
         * When <code>DeviceOnlyRememberedOnUserPrompt</code> is <code>false</code>, Amazon Cognito immediately
         * remembers devices that you register in a <code>ConfirmDevice</code> API request.
         * </p>
         * 
         * @param deviceOnlyRememberedOnUserPrompt
         *        When true, Amazon Cognito doesn't automatically remember a user's device when your app sends a <a
         *        href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html">
         *        ConfirmDevice</a> API request. In your app, create a prompt for your user to choose whether they want
         *        to remember their device. Return the user's choice in an <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html"
         *        > UpdateDeviceStatus</a> API request.</p>
         *        <p>
         *        When <code>DeviceOnlyRememberedOnUserPrompt</code> is <code>false</code>, Amazon Cognito immediately
         *        remembers devices that you register in a <code>ConfirmDevice</code> API request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceOnlyRememberedOnUserPrompt(Boolean deviceOnlyRememberedOnUserPrompt);
    }

    static final class BuilderImpl implements Builder {
        private Boolean challengeRequiredOnNewDevice;

        private Boolean deviceOnlyRememberedOnUserPrompt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceConfigurationType model) {
            challengeRequiredOnNewDevice(model.challengeRequiredOnNewDevice);
            deviceOnlyRememberedOnUserPrompt(model.deviceOnlyRememberedOnUserPrompt);
        }

        public final Boolean getChallengeRequiredOnNewDevice() {
            return challengeRequiredOnNewDevice;
        }

        public final void setChallengeRequiredOnNewDevice(Boolean challengeRequiredOnNewDevice) {
            this.challengeRequiredOnNewDevice = challengeRequiredOnNewDevice;
        }

        @Override
        public final Builder challengeRequiredOnNewDevice(Boolean challengeRequiredOnNewDevice) {
            this.challengeRequiredOnNewDevice = challengeRequiredOnNewDevice;
            return this;
        }

        public final Boolean getDeviceOnlyRememberedOnUserPrompt() {
            return deviceOnlyRememberedOnUserPrompt;
        }

        public final void setDeviceOnlyRememberedOnUserPrompt(Boolean deviceOnlyRememberedOnUserPrompt) {
            this.deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt;
        }

        @Override
        public final Builder deviceOnlyRememberedOnUserPrompt(Boolean deviceOnlyRememberedOnUserPrompt) {
            this.deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt;
            return this;
        }

        @Override
        public DeviceConfigurationType build() {
            return new DeviceConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
