/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The new device metadata type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NewDeviceMetadataType implements SdkPojo, Serializable,
        ToCopyableBuilder<NewDeviceMetadataType.Builder, NewDeviceMetadataType> {
    private static final SdkField<String> DEVICE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceKey").getter(getter(NewDeviceMetadataType::deviceKey)).setter(setter(Builder::deviceKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceKey").build()).build();

    private static final SdkField<String> DEVICE_GROUP_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceGroupKey").getter(getter(NewDeviceMetadataType::deviceGroupKey))
            .setter(setter(Builder::deviceGroupKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceGroupKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_KEY_FIELD,
            DEVICE_GROUP_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DeviceKey", DEVICE_KEY_FIELD);
                    put("DeviceGroupKey", DEVICE_GROUP_KEY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String deviceKey;

    private final String deviceGroupKey;

    private NewDeviceMetadataType(BuilderImpl builder) {
        this.deviceKey = builder.deviceKey;
        this.deviceGroupKey = builder.deviceGroupKey;
    }

    /**
     * <p>
     * The device key.
     * </p>
     * 
     * @return The device key.
     */
    public final String deviceKey() {
        return deviceKey;
    }

    /**
     * <p>
     * The device group key.
     * </p>
     * 
     * @return The device group key.
     */
    public final String deviceGroupKey() {
        return deviceGroupKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceKey());
        hashCode = 31 * hashCode + Objects.hashCode(deviceGroupKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewDeviceMetadataType)) {
            return false;
        }
        NewDeviceMetadataType other = (NewDeviceMetadataType) obj;
        return Objects.equals(deviceKey(), other.deviceKey()) && Objects.equals(deviceGroupKey(), other.deviceGroupKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NewDeviceMetadataType").add("DeviceKey", deviceKey()).add("DeviceGroupKey", deviceGroupKey())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceKey":
            return Optional.ofNullable(clazz.cast(deviceKey()));
        case "DeviceGroupKey":
            return Optional.ofNullable(clazz.cast(deviceGroupKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NewDeviceMetadataType, T> g) {
        return obj -> g.apply((NewDeviceMetadataType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NewDeviceMetadataType> {
        /**
         * <p>
         * The device key.
         * </p>
         * 
         * @param deviceKey
         *        The device key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceKey(String deviceKey);

        /**
         * <p>
         * The device group key.
         * </p>
         * 
         * @param deviceGroupKey
         *        The device group key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceGroupKey(String deviceGroupKey);
    }

    static final class BuilderImpl implements Builder {
        private String deviceKey;

        private String deviceGroupKey;

        private BuilderImpl() {
        }

        private BuilderImpl(NewDeviceMetadataType model) {
            deviceKey(model.deviceKey);
            deviceGroupKey(model.deviceGroupKey);
        }

        public final String getDeviceKey() {
            return deviceKey;
        }

        public final void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        @Override
        public final Builder deviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
            return this;
        }

        public final String getDeviceGroupKey() {
            return deviceGroupKey;
        }

        public final void setDeviceGroupKey(String deviceGroupKey) {
            this.deviceGroupKey = deviceGroupKey;
        }

        @Override
        public final Builder deviceGroupKey(String deviceGroupKey) {
            this.deviceGroupKey = deviceGroupKey;
            return this;
        }

        @Override
        public NewDeviceMetadataType build() {
            return new NewDeviceMetadataType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
