/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of a pre token generation Lambda trigger.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PreTokenGenerationVersionConfigType implements SdkPojo, Serializable,
        ToCopyableBuilder<PreTokenGenerationVersionConfigType.Builder, PreTokenGenerationVersionConfigType> {
    private static final SdkField<String> LAMBDA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LambdaVersion").getter(getter(PreTokenGenerationVersionConfigType::lambdaVersionAsString))
            .setter(setter(Builder::lambdaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaVersion").build()).build();

    private static final SdkField<String> LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LambdaArn").getter(getter(PreTokenGenerationVersionConfigType::lambdaArn))
            .setter(setter(Builder::lambdaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_VERSION_FIELD,
            LAMBDA_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LambdaVersion", LAMBDA_VERSION_FIELD);
                    put("LambdaArn", LAMBDA_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String lambdaVersion;

    private final String lambdaArn;

    private PreTokenGenerationVersionConfigType(BuilderImpl builder) {
        this.lambdaVersion = builder.lambdaVersion;
        this.lambdaArn = builder.lambdaArn;
    }

    /**
     * <p>
     * The user pool trigger version of the request that Amazon Cognito sends to your Lambda function. Higher-numbered
     * versions add fields that support new features.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lambdaVersion}
     * will return {@link PreTokenGenerationLambdaVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #lambdaVersionAsString}.
     * </p>
     * 
     * @return The user pool trigger version of the request that Amazon Cognito sends to your Lambda function.
     *         Higher-numbered versions add fields that support new features.
     * @see PreTokenGenerationLambdaVersionType
     */
    public final PreTokenGenerationLambdaVersionType lambdaVersion() {
        return PreTokenGenerationLambdaVersionType.fromValue(lambdaVersion);
    }

    /**
     * <p>
     * The user pool trigger version of the request that Amazon Cognito sends to your Lambda function. Higher-numbered
     * versions add fields that support new features.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lambdaVersion}
     * will return {@link PreTokenGenerationLambdaVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #lambdaVersionAsString}.
     * </p>
     * 
     * @return The user pool trigger version of the request that Amazon Cognito sends to your Lambda function.
     *         Higher-numbered versions add fields that support new features.
     * @see PreTokenGenerationLambdaVersionType
     */
    public final String lambdaVersionAsString() {
        return lambdaVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the function that you want to assign to your Lambda trigger.
     * </p>
     * <p>
     * This parameter and the <code>PreTokenGeneration</code> property of <code>LambdaConfig</code> have the same value.
     * For new instances of pre token generation triggers, set <code>LambdaArn</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the function that you want to assign to your Lambda trigger.</p>
     *         <p>
     *         This parameter and the <code>PreTokenGeneration</code> property of <code>LambdaConfig</code> have the
     *         same value. For new instances of pre token generation triggers, set <code>LambdaArn</code>.
     */
    public final String lambdaArn() {
        return lambdaArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreTokenGenerationVersionConfigType)) {
            return false;
        }
        PreTokenGenerationVersionConfigType other = (PreTokenGenerationVersionConfigType) obj;
        return Objects.equals(lambdaVersionAsString(), other.lambdaVersionAsString())
                && Objects.equals(lambdaArn(), other.lambdaArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PreTokenGenerationVersionConfigType").add("LambdaVersion", lambdaVersionAsString())
                .add("LambdaArn", lambdaArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LambdaVersion":
            return Optional.ofNullable(clazz.cast(lambdaVersionAsString()));
        case "LambdaArn":
            return Optional.ofNullable(clazz.cast(lambdaArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PreTokenGenerationVersionConfigType, T> g) {
        return obj -> g.apply((PreTokenGenerationVersionConfigType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PreTokenGenerationVersionConfigType> {
        /**
         * <p>
         * The user pool trigger version of the request that Amazon Cognito sends to your Lambda function.
         * Higher-numbered versions add fields that support new features.
         * </p>
         * 
         * @param lambdaVersion
         *        The user pool trigger version of the request that Amazon Cognito sends to your Lambda function.
         *        Higher-numbered versions add fields that support new features.
         * @see PreTokenGenerationLambdaVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreTokenGenerationLambdaVersionType
         */
        Builder lambdaVersion(String lambdaVersion);

        /**
         * <p>
         * The user pool trigger version of the request that Amazon Cognito sends to your Lambda function.
         * Higher-numbered versions add fields that support new features.
         * </p>
         * 
         * @param lambdaVersion
         *        The user pool trigger version of the request that Amazon Cognito sends to your Lambda function.
         *        Higher-numbered versions add fields that support new features.
         * @see PreTokenGenerationLambdaVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreTokenGenerationLambdaVersionType
         */
        Builder lambdaVersion(PreTokenGenerationLambdaVersionType lambdaVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the function that you want to assign to your Lambda trigger.
         * </p>
         * <p>
         * This parameter and the <code>PreTokenGeneration</code> property of <code>LambdaConfig</code> have the same
         * value. For new instances of pre token generation triggers, set <code>LambdaArn</code>.
         * </p>
         * 
         * @param lambdaArn
         *        The Amazon Resource Name (ARN) of the function that you want to assign to your Lambda trigger.</p>
         *        <p>
         *        This parameter and the <code>PreTokenGeneration</code> property of <code>LambdaConfig</code> have the
         *        same value. For new instances of pre token generation triggers, set <code>LambdaArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaArn(String lambdaArn);
    }

    static final class BuilderImpl implements Builder {
        private String lambdaVersion;

        private String lambdaArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PreTokenGenerationVersionConfigType model) {
            lambdaVersion(model.lambdaVersion);
            lambdaArn(model.lambdaArn);
        }

        public final String getLambdaVersion() {
            return lambdaVersion;
        }

        public final void setLambdaVersion(String lambdaVersion) {
            this.lambdaVersion = lambdaVersion;
        }

        @Override
        public final Builder lambdaVersion(String lambdaVersion) {
            this.lambdaVersion = lambdaVersion;
            return this;
        }

        @Override
        public final Builder lambdaVersion(PreTokenGenerationLambdaVersionType lambdaVersion) {
            this.lambdaVersion(lambdaVersion == null ? null : lambdaVersion.toString());
            return this;
        }

        public final String getLambdaArn() {
            return lambdaArn;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        @Override
        public PreTokenGenerationVersionConfigType build() {
            return new PreTokenGenerationVersionConfigType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
