/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures user pool SMS messages for multi-factor authentication (MFA). Sets the message template and the SMS
 * message sending configuration for Amazon SNS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SmsMfaConfigType implements SdkPojo, Serializable,
        ToCopyableBuilder<SmsMfaConfigType.Builder, SmsMfaConfigType> {
    private static final SdkField<String> SMS_AUTHENTICATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SmsAuthenticationMessage").getter(getter(SmsMfaConfigType::smsAuthenticationMessage))
            .setter(setter(Builder::smsAuthenticationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsAuthenticationMessage").build())
            .build();

    private static final SdkField<SmsConfigurationType> SMS_CONFIGURATION_FIELD = SdkField
            .<SmsConfigurationType> builder(MarshallingType.SDK_POJO).memberName("SmsConfiguration")
            .getter(getter(SmsMfaConfigType::smsConfiguration)).setter(setter(Builder::smsConfiguration))
            .constructor(SmsConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SMS_AUTHENTICATION_MESSAGE_FIELD, SMS_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SmsAuthenticationMessage", SMS_AUTHENTICATION_MESSAGE_FIELD);
                    put("SmsConfiguration", SMS_CONFIGURATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String smsAuthenticationMessage;

    private final SmsConfigurationType smsConfiguration;

    private SmsMfaConfigType(BuilderImpl builder) {
        this.smsAuthenticationMessage = builder.smsAuthenticationMessage;
        this.smsConfiguration = builder.smsConfiguration;
    }

    /**
     * <p>
     * The SMS message that your user pool sends to users with an MFA code. The message must contain the
     * <code>{####}</code> placeholder. In the message, Amazon Cognito replaces this placeholder with the code. If you
     * don't provide this parameter, Amazon Cognito sends messages in the default format.
     * </p>
     * 
     * @return The SMS message that your user pool sends to users with an MFA code. The message must contain the
     *         <code>{####}</code> placeholder. In the message, Amazon Cognito replaces this placeholder with the code.
     *         If you don't provide this parameter, Amazon Cognito sends messages in the default format.
     */
    public final String smsAuthenticationMessage() {
        return smsAuthenticationMessage;
    }

    /**
     * <p>
     * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from
     * your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in the Amazon
     * Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role
     * that you provide for your Amazon Web Services account.
     * </p>
     * 
     * @return The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS
     *         message from your Amazon Web Services account through Amazon Simple Notification Service. To request
     *         Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity
     *         and Access Management (IAM) role that you provide for your Amazon Web Services account.
     */
    public final SmsConfigurationType smsConfiguration() {
        return smsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(smsAuthenticationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(smsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmsMfaConfigType)) {
            return false;
        }
        SmsMfaConfigType other = (SmsMfaConfigType) obj;
        return Objects.equals(smsAuthenticationMessage(), other.smsAuthenticationMessage())
                && Objects.equals(smsConfiguration(), other.smsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SmsMfaConfigType").add("SmsAuthenticationMessage", smsAuthenticationMessage())
                .add("SmsConfiguration", smsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SmsAuthenticationMessage":
            return Optional.ofNullable(clazz.cast(smsAuthenticationMessage()));
        case "SmsConfiguration":
            return Optional.ofNullable(clazz.cast(smsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SmsMfaConfigType, T> g) {
        return obj -> g.apply((SmsMfaConfigType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SmsMfaConfigType> {
        /**
         * <p>
         * The SMS message that your user pool sends to users with an MFA code. The message must contain the
         * <code>{####}</code> placeholder. In the message, Amazon Cognito replaces this placeholder with the code. If
         * you don't provide this parameter, Amazon Cognito sends messages in the default format.
         * </p>
         * 
         * @param smsAuthenticationMessage
         *        The SMS message that your user pool sends to users with an MFA code. The message must contain the
         *        <code>{####}</code> placeholder. In the message, Amazon Cognito replaces this placeholder with the
         *        code. If you don't provide this parameter, Amazon Cognito sends messages in the default format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsAuthenticationMessage(String smsAuthenticationMessage);

        /**
         * <p>
         * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message
         * from your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in
         * the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access
         * Management (IAM) role that you provide for your Amazon Web Services account.
         * </p>
         * 
         * @param smsConfiguration
         *        The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS
         *        message from your Amazon Web Services account through Amazon Simple Notification Service. To request
         *        Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an
         *        Identity and Access Management (IAM) role that you provide for your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsConfiguration(SmsConfigurationType smsConfiguration);

        /**
         * <p>
         * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message
         * from your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in
         * the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access
         * Management (IAM) role that you provide for your Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the {@link SmsConfigurationType.Builder} avoiding
         * the need to create one manually via {@link SmsConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SmsConfigurationType.Builder#build()} is called immediately and
         * its result is passed to {@link #smsConfiguration(SmsConfigurationType)}.
         * 
         * @param smsConfiguration
         *        a consumer that will call methods on {@link SmsConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsConfiguration(SmsConfigurationType)
         */
        default Builder smsConfiguration(Consumer<SmsConfigurationType.Builder> smsConfiguration) {
            return smsConfiguration(SmsConfigurationType.builder().applyMutation(smsConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String smsAuthenticationMessage;

        private SmsConfigurationType smsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SmsMfaConfigType model) {
            smsAuthenticationMessage(model.smsAuthenticationMessage);
            smsConfiguration(model.smsConfiguration);
        }

        public final String getSmsAuthenticationMessage() {
            return smsAuthenticationMessage;
        }

        public final void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
        }

        @Override
        public final Builder smsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
            return this;
        }

        public final SmsConfigurationType.Builder getSmsConfiguration() {
            return smsConfiguration != null ? smsConfiguration.toBuilder() : null;
        }

        public final void setSmsConfiguration(SmsConfigurationType.BuilderImpl smsConfiguration) {
            this.smsConfiguration = smsConfiguration != null ? smsConfiguration.build() : null;
        }

        @Override
        public final Builder smsConfiguration(SmsConfigurationType smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        @Override
        public SmsMfaConfigType build() {
            return new SmsMfaConfigType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
