/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminLinkProviderForUserRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<AdminLinkProviderForUserRequest.Builder, AdminLinkProviderForUserRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(AdminLinkProviderForUserRequest::userPoolId))
            .setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<ProviderUserIdentifierType> DESTINATION_USER_FIELD = SdkField
            .<ProviderUserIdentifierType> builder(MarshallingType.SDK_POJO).memberName("DestinationUser")
            .getter(getter(AdminLinkProviderForUserRequest::destinationUser)).setter(setter(Builder::destinationUser))
            .constructor(ProviderUserIdentifierType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationUser").build()).build();

    private static final SdkField<ProviderUserIdentifierType> SOURCE_USER_FIELD = SdkField
            .<ProviderUserIdentifierType> builder(MarshallingType.SDK_POJO).memberName("SourceUser")
            .getter(getter(AdminLinkProviderForUserRequest::sourceUser)).setter(setter(Builder::sourceUser))
            .constructor(ProviderUserIdentifierType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUser").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            DESTINATION_USER_FIELD, SOURCE_USER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("UserPoolId", USER_POOL_ID_FIELD);
                    put("DestinationUser", DESTINATION_USER_FIELD);
                    put("SourceUser", SOURCE_USER_FIELD);
                }
            });

    private final String userPoolId;

    private final ProviderUserIdentifierType destinationUser;

    private final ProviderUserIdentifierType sourceUser;

    private AdminLinkProviderForUserRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.destinationUser = builder.destinationUser;
        this.sourceUser = builder.sourceUser;
    }

    /**
     * <p>
     * The user pool ID for the user pool.
     * </p>
     * 
     * @return The user pool ID for the user pool.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The existing user in the user pool that you want to assign to the external IdP user account. This user can be a
     * local (Username + Password) Amazon Cognito user pools user or a federated user (for example, a SAML or Facebook
     * user). If the user doesn't exist, Amazon Cognito generates an exception. Amazon Cognito returns this user when
     * the new user (with the linked IdP attribute) signs in.
     * </p>
     * <p>
     * For a native username + password user, the <code>ProviderAttributeValue</code> for the
     * <code>DestinationUser</code> should be the username in the user pool. For a federated user, it should be the
     * provider-specific <code>user_id</code>.
     * </p>
     * <p>
     * The <code>ProviderAttributeName</code> of the <code>DestinationUser</code> is ignored.
     * </p>
     * <p>
     * The <code>ProviderName</code> should be set to <code>Cognito</code> for users in Cognito user pools.
     * </p>
     * <important>
     * <p>
     * All attributes in the DestinationUser profile must be mutable. If you have assigned the user any immutable custom
     * attributes, the operation won't succeed.
     * </p>
     * </important>
     * 
     * @return The existing user in the user pool that you want to assign to the external IdP user account. This user
     *         can be a local (Username + Password) Amazon Cognito user pools user or a federated user (for example, a
     *         SAML or Facebook user). If the user doesn't exist, Amazon Cognito generates an exception. Amazon Cognito
     *         returns this user when the new user (with the linked IdP attribute) signs in.</p>
     *         <p>
     *         For a native username + password user, the <code>ProviderAttributeValue</code> for the
     *         <code>DestinationUser</code> should be the username in the user pool. For a federated user, it should be
     *         the provider-specific <code>user_id</code>.
     *         </p>
     *         <p>
     *         The <code>ProviderAttributeName</code> of the <code>DestinationUser</code> is ignored.
     *         </p>
     *         <p>
     *         The <code>ProviderName</code> should be set to <code>Cognito</code> for users in Cognito user pools.
     *         </p>
     *         <important>
     *         <p>
     *         All attributes in the DestinationUser profile must be mutable. If you have assigned the user any
     *         immutable custom attributes, the operation won't succeed.
     *         </p>
     */
    public final ProviderUserIdentifierType destinationUser() {
        return destinationUser;
    }

    /**
     * <p>
     * An external IdP account for a user who doesn't exist yet in the user pool. This user must be a federated user
     * (for example, a SAML or Facebook user), not another native user.
     * </p>
     * <p>
     * If the <code>SourceUser</code> is using a federated social IdP, such as Facebook, Google, or Login with Amazon,
     * you must set the <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. For social IdPs, the
     * <code>ProviderName</code> will be <code>Facebook</code>, <code>Google</code>, or <code>LoginWithAmazon</code>,
     * and Amazon Cognito will automatically parse the Facebook, Google, and Login with Amazon tokens for
     * <code>id</code>, <code>sub</code>, and <code>user_id</code>, respectively. The
     * <code>ProviderAttributeValue</code> for the user must be the same value as the <code>id</code>, <code>sub</code>,
     * or <code>user_id</code> value found in the social IdP token.
     * </p>
     * <p>
     * For OIDC, the <code>ProviderAttributeName</code> can be any mapped value from a claim in the ID token, or that
     * your app retrieves from the <code>userInfo</code> endpoint. For SAML, the <code>ProviderAttributeName</code> can
     * be any mapped value from a claim in the SAML assertion.
     * </p>
     * <p>
     * The following additional considerations apply to <code>SourceUser</code> for OIDC and SAML providers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must map the claim to a user pool attribute in your IdP configuration, and set the user pool attribute name
     * as the value of <code>ProviderAttributeName</code> in your <code>AdminLinkProviderForUser</code> request. For
     * example, <code>email</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you set <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>, Amazon Cognito will
     * automatically parse the default unique identifier found in the subject from the IdP token.
     * </p>
     * </li>
     * </ul>
     * 
     * @return An external IdP account for a user who doesn't exist yet in the user pool. This user must be a federated
     *         user (for example, a SAML or Facebook user), not another native user.</p>
     *         <p>
     *         If the <code>SourceUser</code> is using a federated social IdP, such as Facebook, Google, or Login with
     *         Amazon, you must set the <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. For social
     *         IdPs, the <code>ProviderName</code> will be <code>Facebook</code>, <code>Google</code>, or
     *         <code>LoginWithAmazon</code>, and Amazon Cognito will automatically parse the Facebook, Google, and Login
     *         with Amazon tokens for <code>id</code>, <code>sub</code>, and <code>user_id</code>, respectively. The
     *         <code>ProviderAttributeValue</code> for the user must be the same value as the <code>id</code>,
     *         <code>sub</code>, or <code>user_id</code> value found in the social IdP token.
     *         </p>
     *         <p>
     *         For OIDC, the <code>ProviderAttributeName</code> can be any mapped value from a claim in the ID token, or
     *         that your app retrieves from the <code>userInfo</code> endpoint. For SAML, the
     *         <code>ProviderAttributeName</code> can be any mapped value from a claim in the SAML assertion.
     *         </p>
     *         <p>
     *         The following additional considerations apply to <code>SourceUser</code> for OIDC and SAML providers.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You must map the claim to a user pool attribute in your IdP configuration, and set the user pool
     *         attribute name as the value of <code>ProviderAttributeName</code> in your
     *         <code>AdminLinkProviderForUser</code> request. For example, <code>email</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When you set <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>, Amazon Cognito will
     *         automatically parse the default unique identifier found in the subject from the IdP token.
     *         </p>
     *         </li>
     */
    public final ProviderUserIdentifierType sourceUser() {
        return sourceUser;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationUser());
        hashCode = 31 * hashCode + Objects.hashCode(sourceUser());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminLinkProviderForUserRequest)) {
            return false;
        }
        AdminLinkProviderForUserRequest other = (AdminLinkProviderForUserRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(destinationUser(), other.destinationUser())
                && Objects.equals(sourceUser(), other.sourceUser());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdminLinkProviderForUserRequest").add("UserPoolId", userPoolId())
                .add("DestinationUser", destinationUser()).add("SourceUser", sourceUser()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "DestinationUser":
            return Optional.ofNullable(clazz.cast(destinationUser()));
        case "SourceUser":
            return Optional.ofNullable(clazz.cast(sourceUser()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AdminLinkProviderForUserRequest, T> g) {
        return obj -> g.apply((AdminLinkProviderForUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AdminLinkProviderForUserRequest> {
        /**
         * <p>
         * The user pool ID for the user pool.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The existing user in the user pool that you want to assign to the external IdP user account. This user can be
         * a local (Username + Password) Amazon Cognito user pools user or a federated user (for example, a SAML or
         * Facebook user). If the user doesn't exist, Amazon Cognito generates an exception. Amazon Cognito returns this
         * user when the new user (with the linked IdP attribute) signs in.
         * </p>
         * <p>
         * For a native username + password user, the <code>ProviderAttributeValue</code> for the
         * <code>DestinationUser</code> should be the username in the user pool. For a federated user, it should be the
         * provider-specific <code>user_id</code>.
         * </p>
         * <p>
         * The <code>ProviderAttributeName</code> of the <code>DestinationUser</code> is ignored.
         * </p>
         * <p>
         * The <code>ProviderName</code> should be set to <code>Cognito</code> for users in Cognito user pools.
         * </p>
         * <important>
         * <p>
         * All attributes in the DestinationUser profile must be mutable. If you have assigned the user any immutable
         * custom attributes, the operation won't succeed.
         * </p>
         * </important>
         * 
         * @param destinationUser
         *        The existing user in the user pool that you want to assign to the external IdP user account. This user
         *        can be a local (Username + Password) Amazon Cognito user pools user or a federated user (for example,
         *        a SAML or Facebook user). If the user doesn't exist, Amazon Cognito generates an exception. Amazon
         *        Cognito returns this user when the new user (with the linked IdP attribute) signs in.</p>
         *        <p>
         *        For a native username + password user, the <code>ProviderAttributeValue</code> for the
         *        <code>DestinationUser</code> should be the username in the user pool. For a federated user, it should
         *        be the provider-specific <code>user_id</code>.
         *        </p>
         *        <p>
         *        The <code>ProviderAttributeName</code> of the <code>DestinationUser</code> is ignored.
         *        </p>
         *        <p>
         *        The <code>ProviderName</code> should be set to <code>Cognito</code> for users in Cognito user pools.
         *        </p>
         *        <important>
         *        <p>
         *        All attributes in the DestinationUser profile must be mutable. If you have assigned the user any
         *        immutable custom attributes, the operation won't succeed.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationUser(ProviderUserIdentifierType destinationUser);

        /**
         * <p>
         * The existing user in the user pool that you want to assign to the external IdP user account. This user can be
         * a local (Username + Password) Amazon Cognito user pools user or a federated user (for example, a SAML or
         * Facebook user). If the user doesn't exist, Amazon Cognito generates an exception. Amazon Cognito returns this
         * user when the new user (with the linked IdP attribute) signs in.
         * </p>
         * <p>
         * For a native username + password user, the <code>ProviderAttributeValue</code> for the
         * <code>DestinationUser</code> should be the username in the user pool. For a federated user, it should be the
         * provider-specific <code>user_id</code>.
         * </p>
         * <p>
         * The <code>ProviderAttributeName</code> of the <code>DestinationUser</code> is ignored.
         * </p>
         * <p>
         * The <code>ProviderName</code> should be set to <code>Cognito</code> for users in Cognito user pools.
         * </p>
         * <important>
         * <p>
         * All attributes in the DestinationUser profile must be mutable. If you have assigned the user any immutable
         * custom attributes, the operation won't succeed.
         * </p>
         * </important> This is a convenience method that creates an instance of the
         * {@link ProviderUserIdentifierType.Builder} avoiding the need to create one manually via
         * {@link ProviderUserIdentifierType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProviderUserIdentifierType.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationUser(ProviderUserIdentifierType)}.
         * 
         * @param destinationUser
         *        a consumer that will call methods on {@link ProviderUserIdentifierType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationUser(ProviderUserIdentifierType)
         */
        default Builder destinationUser(Consumer<ProviderUserIdentifierType.Builder> destinationUser) {
            return destinationUser(ProviderUserIdentifierType.builder().applyMutation(destinationUser).build());
        }

        /**
         * <p>
         * An external IdP account for a user who doesn't exist yet in the user pool. This user must be a federated user
         * (for example, a SAML or Facebook user), not another native user.
         * </p>
         * <p>
         * If the <code>SourceUser</code> is using a federated social IdP, such as Facebook, Google, or Login with
         * Amazon, you must set the <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. For social IdPs,
         * the <code>ProviderName</code> will be <code>Facebook</code>, <code>Google</code>, or
         * <code>LoginWithAmazon</code>, and Amazon Cognito will automatically parse the Facebook, Google, and Login
         * with Amazon tokens for <code>id</code>, <code>sub</code>, and <code>user_id</code>, respectively. The
         * <code>ProviderAttributeValue</code> for the user must be the same value as the <code>id</code>,
         * <code>sub</code>, or <code>user_id</code> value found in the social IdP token.
         * </p>
         * <p>
         * For OIDC, the <code>ProviderAttributeName</code> can be any mapped value from a claim in the ID token, or
         * that your app retrieves from the <code>userInfo</code> endpoint. For SAML, the
         * <code>ProviderAttributeName</code> can be any mapped value from a claim in the SAML assertion.
         * </p>
         * <p>
         * The following additional considerations apply to <code>SourceUser</code> for OIDC and SAML providers.
         * </p>
         * <ul>
         * <li>
         * <p>
         * You must map the claim to a user pool attribute in your IdP configuration, and set the user pool attribute
         * name as the value of <code>ProviderAttributeName</code> in your <code>AdminLinkProviderForUser</code>
         * request. For example, <code>email</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you set <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>, Amazon Cognito will
         * automatically parse the default unique identifier found in the subject from the IdP token.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceUser
         *        An external IdP account for a user who doesn't exist yet in the user pool. This user must be a
         *        federated user (for example, a SAML or Facebook user), not another native user.</p>
         *        <p>
         *        If the <code>SourceUser</code> is using a federated social IdP, such as Facebook, Google, or Login
         *        with Amazon, you must set the <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. For
         *        social IdPs, the <code>ProviderName</code> will be <code>Facebook</code>, <code>Google</code>, or
         *        <code>LoginWithAmazon</code>, and Amazon Cognito will automatically parse the Facebook, Google, and
         *        Login with Amazon tokens for <code>id</code>, <code>sub</code>, and <code>user_id</code>,
         *        respectively. The <code>ProviderAttributeValue</code> for the user must be the same value as the
         *        <code>id</code>, <code>sub</code>, or <code>user_id</code> value found in the social IdP token.
         *        </p>
         *        <p>
         *        For OIDC, the <code>ProviderAttributeName</code> can be any mapped value from a claim in the ID token,
         *        or that your app retrieves from the <code>userInfo</code> endpoint. For SAML, the
         *        <code>ProviderAttributeName</code> can be any mapped value from a claim in the SAML assertion.
         *        </p>
         *        <p>
         *        The following additional considerations apply to <code>SourceUser</code> for OIDC and SAML providers.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You must map the claim to a user pool attribute in your IdP configuration, and set the user pool
         *        attribute name as the value of <code>ProviderAttributeName</code> in your
         *        <code>AdminLinkProviderForUser</code> request. For example, <code>email</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When you set <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>, Amazon Cognito will
         *        automatically parse the default unique identifier found in the subject from the IdP token.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUser(ProviderUserIdentifierType sourceUser);

        /**
         * <p>
         * An external IdP account for a user who doesn't exist yet in the user pool. This user must be a federated user
         * (for example, a SAML or Facebook user), not another native user.
         * </p>
         * <p>
         * If the <code>SourceUser</code> is using a federated social IdP, such as Facebook, Google, or Login with
         * Amazon, you must set the <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. For social IdPs,
         * the <code>ProviderName</code> will be <code>Facebook</code>, <code>Google</code>, or
         * <code>LoginWithAmazon</code>, and Amazon Cognito will automatically parse the Facebook, Google, and Login
         * with Amazon tokens for <code>id</code>, <code>sub</code>, and <code>user_id</code>, respectively. The
         * <code>ProviderAttributeValue</code> for the user must be the same value as the <code>id</code>,
         * <code>sub</code>, or <code>user_id</code> value found in the social IdP token.
         * </p>
         * <p>
         * For OIDC, the <code>ProviderAttributeName</code> can be any mapped value from a claim in the ID token, or
         * that your app retrieves from the <code>userInfo</code> endpoint. For SAML, the
         * <code>ProviderAttributeName</code> can be any mapped value from a claim in the SAML assertion.
         * </p>
         * <p>
         * The following additional considerations apply to <code>SourceUser</code> for OIDC and SAML providers.
         * </p>
         * <ul>
         * <li>
         * <p>
         * You must map the claim to a user pool attribute in your IdP configuration, and set the user pool attribute
         * name as the value of <code>ProviderAttributeName</code> in your <code>AdminLinkProviderForUser</code>
         * request. For example, <code>email</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you set <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>, Amazon Cognito will
         * automatically parse the default unique identifier found in the subject from the IdP token.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link ProviderUserIdentifierType.Builder}
         * avoiding the need to create one manually via {@link ProviderUserIdentifierType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProviderUserIdentifierType.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceUser(ProviderUserIdentifierType)}.
         * 
         * @param sourceUser
         *        a consumer that will call methods on {@link ProviderUserIdentifierType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceUser(ProviderUserIdentifierType)
         */
        default Builder sourceUser(Consumer<ProviderUserIdentifierType.Builder> sourceUser) {
            return sourceUser(ProviderUserIdentifierType.builder().applyMutation(sourceUser).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private ProviderUserIdentifierType destinationUser;

        private ProviderUserIdentifierType sourceUser;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminLinkProviderForUserRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            destinationUser(model.destinationUser);
            sourceUser(model.sourceUser);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final ProviderUserIdentifierType.Builder getDestinationUser() {
            return destinationUser != null ? destinationUser.toBuilder() : null;
        }

        public final void setDestinationUser(ProviderUserIdentifierType.BuilderImpl destinationUser) {
            this.destinationUser = destinationUser != null ? destinationUser.build() : null;
        }

        @Override
        public final Builder destinationUser(ProviderUserIdentifierType destinationUser) {
            this.destinationUser = destinationUser;
            return this;
        }

        public final ProviderUserIdentifierType.Builder getSourceUser() {
            return sourceUser != null ? sourceUser.toBuilder() : null;
        }

        public final void setSourceUser(ProviderUserIdentifierType.BuilderImpl sourceUser) {
            this.sourceUser = sourceUser != null ? sourceUser.build() : null;
        }

        @Override
        public final Builder sourceUser(ProviderUserIdentifierType sourceUser) {
            this.sourceUser = sourceUser;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminLinkProviderForUserRequest build() {
            return new AdminLinkProviderForUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
