/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The password policy settings for a user pool, including complexity, history, and length requirements.
 * </p>
 * <p>
 * This data type is a request and response parameter of <a
 * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html"
 * >CreateUserPool</a> and <a
 * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPool.html"
 * >UpdateUserPool</a>, and a response parameter of <a
 * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html"
 * >DescribeUserPool</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PasswordPolicyType implements SdkPojo, Serializable,
        ToCopyableBuilder<PasswordPolicyType.Builder, PasswordPolicyType> {
    private static final SdkField<Integer> MINIMUM_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumLength").getter(getter(PasswordPolicyType::minimumLength)).setter(setter(Builder::minimumLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumLength").build()).build();

    private static final SdkField<Boolean> REQUIRE_UPPERCASE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireUppercase").getter(getter(PasswordPolicyType::requireUppercase))
            .setter(setter(Builder::requireUppercase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireUppercase").build()).build();

    private static final SdkField<Boolean> REQUIRE_LOWERCASE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireLowercase").getter(getter(PasswordPolicyType::requireLowercase))
            .setter(setter(Builder::requireLowercase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireLowercase").build()).build();

    private static final SdkField<Boolean> REQUIRE_NUMBERS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireNumbers").getter(getter(PasswordPolicyType::requireNumbers))
            .setter(setter(Builder::requireNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireNumbers").build()).build();

    private static final SdkField<Boolean> REQUIRE_SYMBOLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireSymbols").getter(getter(PasswordPolicyType::requireSymbols))
            .setter(setter(Builder::requireSymbols))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireSymbols").build()).build();

    private static final SdkField<Integer> PASSWORD_HISTORY_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PasswordHistorySize").getter(getter(PasswordPolicyType::passwordHistorySize))
            .setter(setter(Builder::passwordHistorySize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordHistorySize").build())
            .build();

    private static final SdkField<Integer> TEMPORARY_PASSWORD_VALIDITY_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TemporaryPasswordValidityDays")
            .getter(getter(PasswordPolicyType::temporaryPasswordValidityDays))
            .setter(setter(Builder::temporaryPasswordValidityDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemporaryPasswordValidityDays")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_LENGTH_FIELD,
            REQUIRE_UPPERCASE_FIELD, REQUIRE_LOWERCASE_FIELD, REQUIRE_NUMBERS_FIELD, REQUIRE_SYMBOLS_FIELD,
            PASSWORD_HISTORY_SIZE_FIELD, TEMPORARY_PASSWORD_VALIDITY_DAYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MinimumLength", MINIMUM_LENGTH_FIELD);
                    put("RequireUppercase", REQUIRE_UPPERCASE_FIELD);
                    put("RequireLowercase", REQUIRE_LOWERCASE_FIELD);
                    put("RequireNumbers", REQUIRE_NUMBERS_FIELD);
                    put("RequireSymbols", REQUIRE_SYMBOLS_FIELD);
                    put("PasswordHistorySize", PASSWORD_HISTORY_SIZE_FIELD);
                    put("TemporaryPasswordValidityDays", TEMPORARY_PASSWORD_VALIDITY_DAYS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer minimumLength;

    private final Boolean requireUppercase;

    private final Boolean requireLowercase;

    private final Boolean requireNumbers;

    private final Boolean requireSymbols;

    private final Integer passwordHistorySize;

    private final Integer temporaryPasswordValidityDays;

    private PasswordPolicyType(BuilderImpl builder) {
        this.minimumLength = builder.minimumLength;
        this.requireUppercase = builder.requireUppercase;
        this.requireLowercase = builder.requireLowercase;
        this.requireNumbers = builder.requireNumbers;
        this.requireSymbols = builder.requireSymbols;
        this.passwordHistorySize = builder.passwordHistorySize;
        this.temporaryPasswordValidityDays = builder.temporaryPasswordValidityDays;
    }

    /**
     * <p>
     * The minimum length of the password in the policy that you have set. This value can't be less than 6.
     * </p>
     * 
     * @return The minimum length of the password in the policy that you have set. This value can't be less than 6.
     */
    public final Integer minimumLength() {
        return minimumLength;
    }

    /**
     * <p>
     * The requirement in a password policy that users must include at least one uppercase letter in their password.
     * </p>
     * 
     * @return The requirement in a password policy that users must include at least one uppercase letter in their
     *         password.
     */
    public final Boolean requireUppercase() {
        return requireUppercase;
    }

    /**
     * <p>
     * The requirement in a password policy that users must include at least one lowercase letter in their password.
     * </p>
     * 
     * @return The requirement in a password policy that users must include at least one lowercase letter in their
     *         password.
     */
    public final Boolean requireLowercase() {
        return requireLowercase;
    }

    /**
     * <p>
     * The requirement in a password policy that users must include at least one number in their password.
     * </p>
     * 
     * @return The requirement in a password policy that users must include at least one number in their password.
     */
    public final Boolean requireNumbers() {
        return requireNumbers;
    }

    /**
     * <p>
     * The requirement in a password policy that users must include at least one symbol in their password.
     * </p>
     * 
     * @return The requirement in a password policy that users must include at least one symbol in their password.
     */
    public final Boolean requireSymbols() {
        return requireSymbols;
    }

    /**
     * <p>
     * The number of previous passwords that you want Amazon Cognito to restrict each user from reusing. Users can't set
     * a password that matches any of <code>n</code> previous passwords, where <code>n</code> is the value of
     * <code>PasswordHistorySize</code>.
     * </p>
     * <p>
     * Password history isn't enforced and isn't displayed in <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html"
     * >DescribeUserPool</a> responses when you set this value to <code>0</code> or don't provide it. To activate this
     * setting, <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html">
     * advanced security features</a> must be active in your user pool.
     * </p>
     * 
     * @return The number of previous passwords that you want Amazon Cognito to restrict each user from reusing. Users
     *         can't set a password that matches any of <code>n</code> previous passwords, where <code>n</code> is the
     *         value of <code>PasswordHistorySize</code>.</p>
     *         <p>
     *         Password history isn't enforced and isn't displayed in <a href=
     *         "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html"
     *         >DescribeUserPool</a> responses when you set this value to <code>0</code> or don't provide it. To
     *         activate this setting, <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
     *         > advanced security features</a> must be active in your user pool.
     */
    public final Integer passwordHistorySize() {
        return passwordHistorySize;
    }

    /**
     * <p>
     * The number of days a temporary password is valid in the password policy. If the user doesn't sign in during this
     * time, an administrator must reset their password. Defaults to <code>7</code>. If you submit a value of
     * <code>0</code>, Amazon Cognito treats it as a null value and sets <code>TemporaryPasswordValidityDays</code> to
     * its default value.
     * </p>
     * <note>
     * <p>
     * When you set <code>TemporaryPasswordValidityDays</code> for a user pool, you can no longer set a value for the
     * legacy <code>UnusedAccountValidityDays</code> parameter in that user pool.
     * </p>
     * </note>
     * 
     * @return The number of days a temporary password is valid in the password policy. If the user doesn't sign in
     *         during this time, an administrator must reset their password. Defaults to <code>7</code>. If you submit a
     *         value of <code>0</code>, Amazon Cognito treats it as a null value and sets
     *         <code>TemporaryPasswordValidityDays</code> to its default value.</p> <note>
     *         <p>
     *         When you set <code>TemporaryPasswordValidityDays</code> for a user pool, you can no longer set a value
     *         for the legacy <code>UnusedAccountValidityDays</code> parameter in that user pool.
     *         </p>
     */
    public final Integer temporaryPasswordValidityDays() {
        return temporaryPasswordValidityDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minimumLength());
        hashCode = 31 * hashCode + Objects.hashCode(requireUppercase());
        hashCode = 31 * hashCode + Objects.hashCode(requireLowercase());
        hashCode = 31 * hashCode + Objects.hashCode(requireNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(requireSymbols());
        hashCode = 31 * hashCode + Objects.hashCode(passwordHistorySize());
        hashCode = 31 * hashCode + Objects.hashCode(temporaryPasswordValidityDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PasswordPolicyType)) {
            return false;
        }
        PasswordPolicyType other = (PasswordPolicyType) obj;
        return Objects.equals(minimumLength(), other.minimumLength())
                && Objects.equals(requireUppercase(), other.requireUppercase())
                && Objects.equals(requireLowercase(), other.requireLowercase())
                && Objects.equals(requireNumbers(), other.requireNumbers())
                && Objects.equals(requireSymbols(), other.requireSymbols())
                && Objects.equals(passwordHistorySize(), other.passwordHistorySize())
                && Objects.equals(temporaryPasswordValidityDays(), other.temporaryPasswordValidityDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PasswordPolicyType").add("MinimumLength", minimumLength())
                .add("RequireUppercase", requireUppercase()).add("RequireLowercase", requireLowercase())
                .add("RequireNumbers", requireNumbers()).add("RequireSymbols", requireSymbols())
                .add("PasswordHistorySize", passwordHistorySize())
                .add("TemporaryPasswordValidityDays", temporaryPasswordValidityDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinimumLength":
            return Optional.ofNullable(clazz.cast(minimumLength()));
        case "RequireUppercase":
            return Optional.ofNullable(clazz.cast(requireUppercase()));
        case "RequireLowercase":
            return Optional.ofNullable(clazz.cast(requireLowercase()));
        case "RequireNumbers":
            return Optional.ofNullable(clazz.cast(requireNumbers()));
        case "RequireSymbols":
            return Optional.ofNullable(clazz.cast(requireSymbols()));
        case "PasswordHistorySize":
            return Optional.ofNullable(clazz.cast(passwordHistorySize()));
        case "TemporaryPasswordValidityDays":
            return Optional.ofNullable(clazz.cast(temporaryPasswordValidityDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PasswordPolicyType, T> g) {
        return obj -> g.apply((PasswordPolicyType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PasswordPolicyType> {
        /**
         * <p>
         * The minimum length of the password in the policy that you have set. This value can't be less than 6.
         * </p>
         * 
         * @param minimumLength
         *        The minimum length of the password in the policy that you have set. This value can't be less than 6.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumLength(Integer minimumLength);

        /**
         * <p>
         * The requirement in a password policy that users must include at least one uppercase letter in their password.
         * </p>
         * 
         * @param requireUppercase
         *        The requirement in a password policy that users must include at least one uppercase letter in their
         *        password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireUppercase(Boolean requireUppercase);

        /**
         * <p>
         * The requirement in a password policy that users must include at least one lowercase letter in their password.
         * </p>
         * 
         * @param requireLowercase
         *        The requirement in a password policy that users must include at least one lowercase letter in their
         *        password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireLowercase(Boolean requireLowercase);

        /**
         * <p>
         * The requirement in a password policy that users must include at least one number in their password.
         * </p>
         * 
         * @param requireNumbers
         *        The requirement in a password policy that users must include at least one number in their password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireNumbers(Boolean requireNumbers);

        /**
         * <p>
         * The requirement in a password policy that users must include at least one symbol in their password.
         * </p>
         * 
         * @param requireSymbols
         *        The requirement in a password policy that users must include at least one symbol in their password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireSymbols(Boolean requireSymbols);

        /**
         * <p>
         * The number of previous passwords that you want Amazon Cognito to restrict each user from reusing. Users can't
         * set a password that matches any of <code>n</code> previous passwords, where <code>n</code> is the value of
         * <code>PasswordHistorySize</code>.
         * </p>
         * <p>
         * Password history isn't enforced and isn't displayed in <a href=
         * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html"
         * >DescribeUserPool</a> responses when you set this value to <code>0</code> or don't provide it. To activate
         * this setting, <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
         * > advanced security features</a> must be active in your user pool.
         * </p>
         * 
         * @param passwordHistorySize
         *        The number of previous passwords that you want Amazon Cognito to restrict each user from reusing.
         *        Users can't set a password that matches any of <code>n</code> previous passwords, where <code>n</code>
         *        is the value of <code>PasswordHistorySize</code>.</p>
         *        <p>
         *        Password history isn't enforced and isn't displayed in <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html"
         *        >DescribeUserPool</a> responses when you set this value to <code>0</code> or don't provide it. To
         *        activate this setting, <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
         *        > advanced security features</a> must be active in your user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordHistorySize(Integer passwordHistorySize);

        /**
         * <p>
         * The number of days a temporary password is valid in the password policy. If the user doesn't sign in during
         * this time, an administrator must reset their password. Defaults to <code>7</code>. If you submit a value of
         * <code>0</code>, Amazon Cognito treats it as a null value and sets <code>TemporaryPasswordValidityDays</code>
         * to its default value.
         * </p>
         * <note>
         * <p>
         * When you set <code>TemporaryPasswordValidityDays</code> for a user pool, you can no longer set a value for
         * the legacy <code>UnusedAccountValidityDays</code> parameter in that user pool.
         * </p>
         * </note>
         * 
         * @param temporaryPasswordValidityDays
         *        The number of days a temporary password is valid in the password policy. If the user doesn't sign in
         *        during this time, an administrator must reset their password. Defaults to <code>7</code>. If you
         *        submit a value of <code>0</code>, Amazon Cognito treats it as a null value and sets
         *        <code>TemporaryPasswordValidityDays</code> to its default value.</p> <note>
         *        <p>
         *        When you set <code>TemporaryPasswordValidityDays</code> for a user pool, you can no longer set a value
         *        for the legacy <code>UnusedAccountValidityDays</code> parameter in that user pool.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder temporaryPasswordValidityDays(Integer temporaryPasswordValidityDays);
    }

    static final class BuilderImpl implements Builder {
        private Integer minimumLength;

        private Boolean requireUppercase;

        private Boolean requireLowercase;

        private Boolean requireNumbers;

        private Boolean requireSymbols;

        private Integer passwordHistorySize;

        private Integer temporaryPasswordValidityDays;

        private BuilderImpl() {
        }

        private BuilderImpl(PasswordPolicyType model) {
            minimumLength(model.minimumLength);
            requireUppercase(model.requireUppercase);
            requireLowercase(model.requireLowercase);
            requireNumbers(model.requireNumbers);
            requireSymbols(model.requireSymbols);
            passwordHistorySize(model.passwordHistorySize);
            temporaryPasswordValidityDays(model.temporaryPasswordValidityDays);
        }

        public final Integer getMinimumLength() {
            return minimumLength;
        }

        public final void setMinimumLength(Integer minimumLength) {
            this.minimumLength = minimumLength;
        }

        @Override
        public final Builder minimumLength(Integer minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        public final Boolean getRequireUppercase() {
            return requireUppercase;
        }

        public final void setRequireUppercase(Boolean requireUppercase) {
            this.requireUppercase = requireUppercase;
        }

        @Override
        public final Builder requireUppercase(Boolean requireUppercase) {
            this.requireUppercase = requireUppercase;
            return this;
        }

        public final Boolean getRequireLowercase() {
            return requireLowercase;
        }

        public final void setRequireLowercase(Boolean requireLowercase) {
            this.requireLowercase = requireLowercase;
        }

        @Override
        public final Builder requireLowercase(Boolean requireLowercase) {
            this.requireLowercase = requireLowercase;
            return this;
        }

        public final Boolean getRequireNumbers() {
            return requireNumbers;
        }

        public final void setRequireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
        }

        @Override
        public final Builder requireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
            return this;
        }

        public final Boolean getRequireSymbols() {
            return requireSymbols;
        }

        public final void setRequireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
        }

        @Override
        public final Builder requireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
            return this;
        }

        public final Integer getPasswordHistorySize() {
            return passwordHistorySize;
        }

        public final void setPasswordHistorySize(Integer passwordHistorySize) {
            this.passwordHistorySize = passwordHistorySize;
        }

        @Override
        public final Builder passwordHistorySize(Integer passwordHistorySize) {
            this.passwordHistorySize = passwordHistorySize;
            return this;
        }

        public final Integer getTemporaryPasswordValidityDays() {
            return temporaryPasswordValidityDays;
        }

        public final void setTemporaryPasswordValidityDays(Integer temporaryPasswordValidityDays) {
            this.temporaryPasswordValidityDays = temporaryPasswordValidityDays;
        }

        @Override
        public final Builder temporaryPasswordValidityDays(Integer temporaryPasswordValidityDays) {
            this.temporaryPasswordValidityDays = temporaryPasswordValidityDays;
            return this;
        }

        @Override
        public PasswordPolicyType build() {
            return new PasswordPolicyType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
