/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of user pool policies. Contains the policy that sets password-complexity requirements.
 * </p>
 * <p>
 * This data type is a request and response parameter of <a
 * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html"
 * >CreateUserPool</a> and <a
 * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPool.html"
 * >UpdateUserPool</a>, and a response parameter of <a
 * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html"
 * >DescribeUserPool</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserPoolPolicyType implements SdkPojo, Serializable,
        ToCopyableBuilder<UserPoolPolicyType.Builder, UserPoolPolicyType> {
    private static final SdkField<PasswordPolicyType> PASSWORD_POLICY_FIELD = SdkField
            .<PasswordPolicyType> builder(MarshallingType.SDK_POJO).memberName("PasswordPolicy")
            .getter(getter(UserPoolPolicyType::passwordPolicy)).setter(setter(Builder::passwordPolicy))
            .constructor(PasswordPolicyType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordPolicy").build()).build();

    private static final SdkField<SignInPolicyType> SIGN_IN_POLICY_FIELD = SdkField
            .<SignInPolicyType> builder(MarshallingType.SDK_POJO).memberName("SignInPolicy")
            .getter(getter(UserPoolPolicyType::signInPolicy)).setter(setter(Builder::signInPolicy))
            .constructor(SignInPolicyType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignInPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PASSWORD_POLICY_FIELD,
            SIGN_IN_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("PasswordPolicy", PASSWORD_POLICY_FIELD);
                    put("SignInPolicy", SIGN_IN_POLICY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final PasswordPolicyType passwordPolicy;

    private final SignInPolicyType signInPolicy;

    private UserPoolPolicyType(BuilderImpl builder) {
        this.passwordPolicy = builder.passwordPolicy;
        this.signInPolicy = builder.signInPolicy;
    }

    /**
     * <p>
     * The password policy settings for a user pool, including complexity, history, and length requirements.
     * </p>
     * 
     * @return The password policy settings for a user pool, including complexity, history, and length requirements.
     */
    public final PasswordPolicyType passwordPolicy() {
        return passwordPolicy;
    }

    /**
     * <p>
     * The policy for allowed types of authentication in a user pool.
     * </p>
     * 
     * @return The policy for allowed types of authentication in a user pool.
     */
    public final SignInPolicyType signInPolicy() {
        return signInPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(passwordPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(signInPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolPolicyType)) {
            return false;
        }
        UserPoolPolicyType other = (UserPoolPolicyType) obj;
        return Objects.equals(passwordPolicy(), other.passwordPolicy()) && Objects.equals(signInPolicy(), other.signInPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserPoolPolicyType").add("PasswordPolicy", passwordPolicy()).add("SignInPolicy", signInPolicy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PasswordPolicy":
            return Optional.ofNullable(clazz.cast(passwordPolicy()));
        case "SignInPolicy":
            return Optional.ofNullable(clazz.cast(signInPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UserPoolPolicyType, T> g) {
        return obj -> g.apply((UserPoolPolicyType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserPoolPolicyType> {
        /**
         * <p>
         * The password policy settings for a user pool, including complexity, history, and length requirements.
         * </p>
         * 
         * @param passwordPolicy
         *        The password policy settings for a user pool, including complexity, history, and length requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordPolicy(PasswordPolicyType passwordPolicy);

        /**
         * <p>
         * The password policy settings for a user pool, including complexity, history, and length requirements.
         * </p>
         * This is a convenience method that creates an instance of the {@link PasswordPolicyType.Builder} avoiding the
         * need to create one manually via {@link PasswordPolicyType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PasswordPolicyType.Builder#build()} is called immediately and its
         * result is passed to {@link #passwordPolicy(PasswordPolicyType)}.
         * 
         * @param passwordPolicy
         *        a consumer that will call methods on {@link PasswordPolicyType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #passwordPolicy(PasswordPolicyType)
         */
        default Builder passwordPolicy(Consumer<PasswordPolicyType.Builder> passwordPolicy) {
            return passwordPolicy(PasswordPolicyType.builder().applyMutation(passwordPolicy).build());
        }

        /**
         * <p>
         * The policy for allowed types of authentication in a user pool.
         * </p>
         * 
         * @param signInPolicy
         *        The policy for allowed types of authentication in a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signInPolicy(SignInPolicyType signInPolicy);

        /**
         * <p>
         * The policy for allowed types of authentication in a user pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link SignInPolicyType.Builder} avoiding the
         * need to create one manually via {@link SignInPolicyType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SignInPolicyType.Builder#build()} is called immediately and its
         * result is passed to {@link #signInPolicy(SignInPolicyType)}.
         * 
         * @param signInPolicy
         *        a consumer that will call methods on {@link SignInPolicyType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signInPolicy(SignInPolicyType)
         */
        default Builder signInPolicy(Consumer<SignInPolicyType.Builder> signInPolicy) {
            return signInPolicy(SignInPolicyType.builder().applyMutation(signInPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PasswordPolicyType passwordPolicy;

        private SignInPolicyType signInPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolPolicyType model) {
            passwordPolicy(model.passwordPolicy);
            signInPolicy(model.signInPolicy);
        }

        public final PasswordPolicyType.Builder getPasswordPolicy() {
            return passwordPolicy != null ? passwordPolicy.toBuilder() : null;
        }

        public final void setPasswordPolicy(PasswordPolicyType.BuilderImpl passwordPolicy) {
            this.passwordPolicy = passwordPolicy != null ? passwordPolicy.build() : null;
        }

        @Override
        public final Builder passwordPolicy(PasswordPolicyType passwordPolicy) {
            this.passwordPolicy = passwordPolicy;
            return this;
        }

        public final SignInPolicyType.Builder getSignInPolicy() {
            return signInPolicy != null ? signInPolicy.toBuilder() : null;
        }

        public final void setSignInPolicy(SignInPolicyType.BuilderImpl signInPolicy) {
            this.signInPolicy = signInPolicy != null ? signInPolicy.build() : null;
        }

        @Override
        public final Builder signInPolicy(SignInPolicyType signInPolicy) {
            this.signInPolicy = signInPolicy;
            return this;
        }

        @Override
        public UserPoolPolicyType build() {
            return new UserPoolPolicyType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
