/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminGetDeviceRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AdminGetDeviceRequest> {
    private static final SdkField<String> DEVICE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceKey").getter(AdminGetDeviceRequest.getter(AdminGetDeviceRequest::deviceKey)).setter(AdminGetDeviceRequest.setter(Builder::deviceKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceKey").build()}).build();
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(AdminGetDeviceRequest.getter(AdminGetDeviceRequest::userPoolId)).setter(AdminGetDeviceRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(AdminGetDeviceRequest.getter(AdminGetDeviceRequest::username)).setter(AdminGetDeviceRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_KEY_FIELD, USER_POOL_ID_FIELD, USERNAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DeviceKey", DEVICE_KEY_FIELD);
            this.put("UserPoolId", USER_POOL_ID_FIELD);
            this.put("Username", USERNAME_FIELD);
        }
    });
    private final String deviceKey;
    private final String userPoolId;
    private final String username;

    private AdminGetDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.deviceKey = builder.deviceKey;
        this.userPoolId = builder.userPoolId;
        this.username = builder.username;
    }

    public final String deviceKey() {
        return this.deviceKey;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String username() {
        return this.username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminGetDeviceRequest)) {
            return false;
        }
        AdminGetDeviceRequest other = (AdminGetDeviceRequest)((Object)obj);
        return Objects.equals(this.deviceKey(), other.deviceKey()) && Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.username(), other.username());
    }

    public final String toString() {
        return ToString.builder((String)"AdminGetDeviceRequest").add("DeviceKey", (Object)this.deviceKey()).add("UserPoolId", (Object)this.userPoolId()).add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceKey": {
                return Optional.ofNullable(clazz.cast(this.deviceKey()));
            }
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AdminGetDeviceRequest, T> g) {
        return obj -> g.apply((AdminGetDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String deviceKey;
        private String userPoolId;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminGetDeviceRequest model) {
            super(model);
            this.deviceKey(model.deviceKey);
            this.userPoolId(model.userPoolId);
            this.username(model.username);
        }

        public final String getDeviceKey() {
            return this.deviceKey;
        }

        public final void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        @Override
        public final Builder deviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
            return this;
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminGetDeviceRequest build() {
            return new AdminGetDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AdminGetDeviceRequest> {
        public Builder deviceKey(String var1);

        public Builder userPoolId(String var1);

        public Builder username(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

