/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateSoftwareTokenResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, AssociateSoftwareTokenResponse> {
    private static final SdkField<String> SECRET_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretCode").getter(AssociateSoftwareTokenResponse.getter(AssociateSoftwareTokenResponse::secretCode)).setter(AssociateSoftwareTokenResponse.setter(Builder::secretCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretCode").build()}).build();
    private static final SdkField<String> SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Session").getter(AssociateSoftwareTokenResponse.getter(AssociateSoftwareTokenResponse::session)).setter(AssociateSoftwareTokenResponse.setter(Builder::session)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_CODE_FIELD, SESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SecretCode", SECRET_CODE_FIELD);
            this.put("Session", SESSION_FIELD);
        }
    });
    private final String secretCode;
    private final String session;

    private AssociateSoftwareTokenResponse(BuilderImpl builder) {
        super(builder);
        this.secretCode = builder.secretCode;
        this.session = builder.session;
    }

    public final String secretCode() {
        return this.secretCode;
    }

    public final String session() {
        return this.session;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.secretCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.session());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSoftwareTokenResponse)) {
            return false;
        }
        AssociateSoftwareTokenResponse other = (AssociateSoftwareTokenResponse)((Object)obj);
        return Objects.equals(this.secretCode(), other.secretCode()) && Objects.equals(this.session(), other.session());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateSoftwareTokenResponse").add("SecretCode", (Object)(this.secretCode() == null ? null : "*** Sensitive Data Redacted ***")).add("Session", (Object)(this.session() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretCode": {
                return Optional.ofNullable(clazz.cast(this.secretCode()));
            }
            case "Session": {
                return Optional.ofNullable(clazz.cast(this.session()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociateSoftwareTokenResponse, T> g) {
        return obj -> g.apply((AssociateSoftwareTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private String secretCode;
        private String session;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSoftwareTokenResponse model) {
            super(model);
            this.secretCode(model.secretCode);
            this.session(model.session);
        }

        public final String getSecretCode() {
            return this.secretCode;
        }

        public final void setSecretCode(String secretCode) {
            this.secretCode = secretCode;
        }

        @Override
        public final Builder secretCode(String secretCode) {
            this.secretCode = secretCode;
            return this;
        }

        public final String getSession() {
            return this.session;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        @Override
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        @Override
        public AssociateSoftwareTokenResponse build() {
            return new AssociateSoftwareTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateSoftwareTokenResponse> {
        public Builder secretCode(String var1);

        public Builder session(String var1);
    }
}

