/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangePasswordRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, ChangePasswordRequest> {
    private static final SdkField<String> PREVIOUS_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousPassword").getter(ChangePasswordRequest.getter(ChangePasswordRequest::previousPassword)).setter(ChangePasswordRequest.setter(Builder::previousPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousPassword").build()}).build();
    private static final SdkField<String> PROPOSED_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProposedPassword").getter(ChangePasswordRequest.getter(ChangePasswordRequest::proposedPassword)).setter(ChangePasswordRequest.setter(Builder::proposedPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposedPassword").build()}).build();
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessToken").getter(ChangePasswordRequest.getter(ChangePasswordRequest::accessToken)).setter(ChangePasswordRequest.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREVIOUS_PASSWORD_FIELD, PROPOSED_PASSWORD_FIELD, ACCESS_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PreviousPassword", PREVIOUS_PASSWORD_FIELD);
            this.put("ProposedPassword", PROPOSED_PASSWORD_FIELD);
            this.put("AccessToken", ACCESS_TOKEN_FIELD);
        }
    });
    private final String previousPassword;
    private final String proposedPassword;
    private final String accessToken;

    private ChangePasswordRequest(BuilderImpl builder) {
        super(builder);
        this.previousPassword = builder.previousPassword;
        this.proposedPassword = builder.proposedPassword;
        this.accessToken = builder.accessToken;
    }

    public final String previousPassword() {
        return this.previousPassword;
    }

    public final String proposedPassword() {
        return this.proposedPassword;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.previousPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.proposedPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangePasswordRequest)) {
            return false;
        }
        ChangePasswordRequest other = (ChangePasswordRequest)((Object)obj);
        return Objects.equals(this.previousPassword(), other.previousPassword()) && Objects.equals(this.proposedPassword(), other.proposedPassword()) && Objects.equals(this.accessToken(), other.accessToken());
    }

    public final String toString() {
        return ToString.builder((String)"ChangePasswordRequest").add("PreviousPassword", (Object)(this.previousPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("ProposedPassword", (Object)(this.proposedPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PreviousPassword": {
                return Optional.ofNullable(clazz.cast(this.previousPassword()));
            }
            case "ProposedPassword": {
                return Optional.ofNullable(clazz.cast(this.proposedPassword()));
            }
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ChangePasswordRequest, T> g) {
        return obj -> g.apply((ChangePasswordRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String previousPassword;
        private String proposedPassword;
        private String accessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangePasswordRequest model) {
            super(model);
            this.previousPassword(model.previousPassword);
            this.proposedPassword(model.proposedPassword);
            this.accessToken(model.accessToken);
        }

        public final String getPreviousPassword() {
            return this.previousPassword;
        }

        public final void setPreviousPassword(String previousPassword) {
            this.previousPassword = previousPassword;
        }

        @Override
        public final Builder previousPassword(String previousPassword) {
            this.previousPassword = previousPassword;
            return this;
        }

        public final String getProposedPassword() {
            return this.proposedPassword;
        }

        public final void setProposedPassword(String proposedPassword) {
            this.proposedPassword = proposedPassword;
        }

        @Override
        public final Builder proposedPassword(String proposedPassword) {
            this.proposedPassword = proposedPassword;
            return this;
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChangePasswordRequest build() {
            return new ChangePasswordRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ChangePasswordRequest> {
        public Builder previousPassword(String var1);

        public Builder proposedPassword(String var1);

        public Builder accessToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

