/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderClient;
import software.amazon.awssdk.services.cognitoidentityprovider.internal.UserAgentUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientDescription;

public class ListUserPoolClientsIterable
implements SdkIterable<ListUserPoolClientsResponse> {
    private final CognitoIdentityProviderClient client;
    private final ListUserPoolClientsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUserPoolClientsIterable(CognitoIdentityProviderClient client, ListUserPoolClientsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUserPoolClientsResponseFetcher();
    }

    public Iterator<ListUserPoolClientsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UserPoolClientDescription> userPoolClients() {
        Function<ListUserPoolClientsResponse, Iterator> getIterator = response -> {
            if (response != null && response.userPoolClients() != null) {
                return response.userPoolClients().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUserPoolClientsResponseFetcher
    implements SyncPageFetcher<ListUserPoolClientsResponse> {
        private ListUserPoolClientsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserPoolClientsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUserPoolClientsResponse nextPage(ListUserPoolClientsResponse previousPage) {
            if (previousPage == null) {
                return ListUserPoolClientsIterable.this.client.listUserPoolClients(ListUserPoolClientsIterable.this.firstRequest);
            }
            return ListUserPoolClientsIterable.this.client.listUserPoolClients((ListUserPoolClientsRequest)((Object)ListUserPoolClientsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

