/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information that your application adds to authentication requests. Applies an endpoint ID to the analytics data that
 * your user pool sends to Amazon Pinpoint.
 * </p>
 * <p>
 * An endpoint ID uniquely identifies a mobile device, email address or phone number that can receive messages from
 * Amazon Pinpoint analytics. For more information about Amazon Web Services Regions that can contain Amazon Pinpoint
 * resources for use with Amazon Cognito user pools, see <a
 * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-pinpoint-integration.html">Using
 * Amazon Pinpoint analytics with Amazon Cognito user pools</a>.
 * </p>
 * <p>
 * This data type is a request parameter of authentication operations like <a
 * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html"
 * >InitiateAuth</a>, <a
 * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html"
 * >AdminInitiateAuth</a>, <a
 * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RespondToAuthChallenge.html"
 * >RespondToAuthChallenge</a>, and <a href=
 * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminRespondToAuthChallenge.html"
 * >AdminRespondToAuthChallenge</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsMetadataType implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyticsMetadataType.Builder, AnalyticsMetadataType> {
    private static final SdkField<String> ANALYTICS_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalyticsEndpointId").getter(getter(AnalyticsMetadataType::analyticsEndpointId))
            .setter(setter(Builder::analyticsEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsEndpointId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYTICS_ENDPOINT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AnalyticsEndpointId", ANALYTICS_ENDPOINT_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String analyticsEndpointId;

    private AnalyticsMetadataType(BuilderImpl builder) {
        this.analyticsEndpointId = builder.analyticsEndpointId;
    }

    /**
     * <p>
     * The endpoint ID. Information that you want to pass to Amazon Pinpoint about where to send notifications.
     * </p>
     * 
     * @return The endpoint ID. Information that you want to pass to Amazon Pinpoint about where to send notifications.
     */
    public final String analyticsEndpointId() {
        return analyticsEndpointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(analyticsEndpointId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsMetadataType)) {
            return false;
        }
        AnalyticsMetadataType other = (AnalyticsMetadataType) obj;
        return Objects.equals(analyticsEndpointId(), other.analyticsEndpointId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyticsMetadataType").add("AnalyticsEndpointId", analyticsEndpointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalyticsEndpointId":
            return Optional.ofNullable(clazz.cast(analyticsEndpointId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsMetadataType, T> g) {
        return obj -> g.apply((AnalyticsMetadataType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyticsMetadataType> {
        /**
         * <p>
         * The endpoint ID. Information that you want to pass to Amazon Pinpoint about where to send notifications.
         * </p>
         * 
         * @param analyticsEndpointId
         *        The endpoint ID. Information that you want to pass to Amazon Pinpoint about where to send
         *        notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyticsEndpointId(String analyticsEndpointId);
    }

    static final class BuilderImpl implements Builder {
        private String analyticsEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsMetadataType model) {
            analyticsEndpointId(model.analyticsEndpointId);
        }

        public final String getAnalyticsEndpointId() {
            return analyticsEndpointId;
        }

        public final void setAnalyticsEndpointId(String analyticsEndpointId) {
            this.analyticsEndpointId = analyticsEndpointId;
        }

        @Override
        public final Builder analyticsEndpointId(String analyticsEndpointId) {
            this.analyticsEndpointId = analyticsEndpointId;
            return this;
        }

        @Override
        public AnalyticsMetadataType build() {
            return new AnalyticsMetadataType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
