/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUserAuthFactorsResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<GetUserAuthFactorsResponse.Builder, GetUserAuthFactorsResponse> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(GetUserAuthFactorsResponse::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> PREFERRED_MFA_SETTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredMfaSetting").getter(getter(GetUserAuthFactorsResponse::preferredMfaSetting))
            .setter(setter(Builder::preferredMfaSetting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMfaSetting").build())
            .build();

    private static final SdkField<List<String>> USER_MFA_SETTING_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserMFASettingList")
            .getter(getter(GetUserAuthFactorsResponse::userMFASettingList))
            .setter(setter(Builder::userMFASettingList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMFASettingList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CONFIGURED_USER_AUTH_FACTORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConfiguredUserAuthFactors")
            .getter(getter(GetUserAuthFactorsResponse::configuredUserAuthFactorsAsStrings))
            .setter(setter(Builder::configuredUserAuthFactorsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfiguredUserAuthFactors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD,
            PREFERRED_MFA_SETTING_FIELD, USER_MFA_SETTING_LIST_FIELD, CONFIGURED_USER_AUTH_FACTORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Username", USERNAME_FIELD);
                    put("PreferredMfaSetting", PREFERRED_MFA_SETTING_FIELD);
                    put("UserMFASettingList", USER_MFA_SETTING_LIST_FIELD);
                    put("ConfiguredUserAuthFactors", CONFIGURED_USER_AUTH_FACTORS_FIELD);
                }
            });

    private final String username;

    private final String preferredMfaSetting;

    private final List<String> userMFASettingList;

    private final List<String> configuredUserAuthFactors;

    private GetUserAuthFactorsResponse(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.preferredMfaSetting = builder.preferredMfaSetting;
        this.userMFASettingList = builder.userMFASettingList;
        this.configuredUserAuthFactors = builder.configuredUserAuthFactors;
    }

    /**
     * <p>
     * The username of the currently sign-in user.
     * </p>
     * 
     * @return The username of the currently sign-in user.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The user's preferred MFA setting.
     * </p>
     * 
     * @return The user's preferred MFA setting.
     */
    public final String preferredMfaSetting() {
        return preferredMfaSetting;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserMFASettingList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserMFASettingList() {
        return userMFASettingList != null && !(userMFASettingList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code>,
     * <code>EMAIL_OTP</code>, and <code>SOFTWARE_TOKEN_MFA</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserMFASettingList} method.
     * </p>
     * 
     * @return The MFA options that are activated for the user. The possible values in this list are
     *         <code>SMS_MFA</code>, <code>EMAIL_OTP</code>, and <code>SOFTWARE_TOKEN_MFA</code>.
     */
    public final List<String> userMFASettingList() {
        return userMFASettingList;
    }

    /**
     * <p>
     * The authentication types that are available to the user with <code>USER_AUTH</code> sign-in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfiguredUserAuthFactors} method.
     * </p>
     * 
     * @return The authentication types that are available to the user with <code>USER_AUTH</code> sign-in.
     */
    public final List<AuthFactorType> configuredUserAuthFactors() {
        return ConfiguredUserAuthFactorsListTypeCopier.copyStringToEnum(configuredUserAuthFactors);
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfiguredUserAuthFactors property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConfiguredUserAuthFactors() {
        return configuredUserAuthFactors != null && !(configuredUserAuthFactors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The authentication types that are available to the user with <code>USER_AUTH</code> sign-in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfiguredUserAuthFactors} method.
     * </p>
     * 
     * @return The authentication types that are available to the user with <code>USER_AUTH</code> sign-in.
     */
    public final List<String> configuredUserAuthFactorsAsStrings() {
        return configuredUserAuthFactors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMfaSetting());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserMFASettingList() ? userMFASettingList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConfiguredUserAuthFactors() ? configuredUserAuthFactorsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserAuthFactorsResponse)) {
            return false;
        }
        GetUserAuthFactorsResponse other = (GetUserAuthFactorsResponse) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(preferredMfaSetting(), other.preferredMfaSetting())
                && hasUserMFASettingList() == other.hasUserMFASettingList()
                && Objects.equals(userMFASettingList(), other.userMFASettingList())
                && hasConfiguredUserAuthFactors() == other.hasConfiguredUserAuthFactors()
                && Objects.equals(configuredUserAuthFactorsAsStrings(), other.configuredUserAuthFactorsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUserAuthFactorsResponse")
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PreferredMfaSetting", preferredMfaSetting())
                .add("UserMFASettingList", hasUserMFASettingList() ? userMFASettingList() : null)
                .add("ConfiguredUserAuthFactors", hasConfiguredUserAuthFactors() ? configuredUserAuthFactorsAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "PreferredMfaSetting":
            return Optional.ofNullable(clazz.cast(preferredMfaSetting()));
        case "UserMFASettingList":
            return Optional.ofNullable(clazz.cast(userMFASettingList()));
        case "ConfiguredUserAuthFactors":
            return Optional.ofNullable(clazz.cast(configuredUserAuthFactorsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetUserAuthFactorsResponse, T> g) {
        return obj -> g.apply((GetUserAuthFactorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetUserAuthFactorsResponse> {
        /**
         * <p>
         * The username of the currently sign-in user.
         * </p>
         * 
         * @param username
         *        The username of the currently sign-in user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The user's preferred MFA setting.
         * </p>
         * 
         * @param preferredMfaSetting
         *        The user's preferred MFA setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMfaSetting(String preferredMfaSetting);

        /**
         * <p>
         * The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code>,
         * <code>EMAIL_OTP</code>, and <code>SOFTWARE_TOKEN_MFA</code>.
         * </p>
         * 
         * @param userMFASettingList
         *        The MFA options that are activated for the user. The possible values in this list are
         *        <code>SMS_MFA</code>, <code>EMAIL_OTP</code>, and <code>SOFTWARE_TOKEN_MFA</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMFASettingList(Collection<String> userMFASettingList);

        /**
         * <p>
         * The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code>,
         * <code>EMAIL_OTP</code>, and <code>SOFTWARE_TOKEN_MFA</code>.
         * </p>
         * 
         * @param userMFASettingList
         *        The MFA options that are activated for the user. The possible values in this list are
         *        <code>SMS_MFA</code>, <code>EMAIL_OTP</code>, and <code>SOFTWARE_TOKEN_MFA</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMFASettingList(String... userMFASettingList);

        /**
         * <p>
         * The authentication types that are available to the user with <code>USER_AUTH</code> sign-in.
         * </p>
         * 
         * @param configuredUserAuthFactors
         *        The authentication types that are available to the user with <code>USER_AUTH</code> sign-in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredUserAuthFactorsWithStrings(Collection<String> configuredUserAuthFactors);

        /**
         * <p>
         * The authentication types that are available to the user with <code>USER_AUTH</code> sign-in.
         * </p>
         * 
         * @param configuredUserAuthFactors
         *        The authentication types that are available to the user with <code>USER_AUTH</code> sign-in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredUserAuthFactorsWithStrings(String... configuredUserAuthFactors);

        /**
         * <p>
         * The authentication types that are available to the user with <code>USER_AUTH</code> sign-in.
         * </p>
         * 
         * @param configuredUserAuthFactors
         *        The authentication types that are available to the user with <code>USER_AUTH</code> sign-in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredUserAuthFactors(Collection<AuthFactorType> configuredUserAuthFactors);

        /**
         * <p>
         * The authentication types that are available to the user with <code>USER_AUTH</code> sign-in.
         * </p>
         * 
         * @param configuredUserAuthFactors
         *        The authentication types that are available to the user with <code>USER_AUTH</code> sign-in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredUserAuthFactors(AuthFactorType... configuredUserAuthFactors);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private String username;

        private String preferredMfaSetting;

        private List<String> userMFASettingList = DefaultSdkAutoConstructList.getInstance();

        private List<String> configuredUserAuthFactors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserAuthFactorsResponse model) {
            super(model);
            username(model.username);
            preferredMfaSetting(model.preferredMfaSetting);
            userMFASettingList(model.userMFASettingList);
            configuredUserAuthFactorsWithStrings(model.configuredUserAuthFactors);
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getPreferredMfaSetting() {
            return preferredMfaSetting;
        }

        public final void setPreferredMfaSetting(String preferredMfaSetting) {
            this.preferredMfaSetting = preferredMfaSetting;
        }

        @Override
        public final Builder preferredMfaSetting(String preferredMfaSetting) {
            this.preferredMfaSetting = preferredMfaSetting;
            return this;
        }

        public final Collection<String> getUserMFASettingList() {
            if (userMFASettingList instanceof SdkAutoConstructList) {
                return null;
            }
            return userMFASettingList;
        }

        public final void setUserMFASettingList(Collection<String> userMFASettingList) {
            this.userMFASettingList = UserMFASettingListTypeCopier.copy(userMFASettingList);
        }

        @Override
        public final Builder userMFASettingList(Collection<String> userMFASettingList) {
            this.userMFASettingList = UserMFASettingListTypeCopier.copy(userMFASettingList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userMFASettingList(String... userMFASettingList) {
            userMFASettingList(Arrays.asList(userMFASettingList));
            return this;
        }

        public final Collection<String> getConfiguredUserAuthFactors() {
            if (configuredUserAuthFactors instanceof SdkAutoConstructList) {
                return null;
            }
            return configuredUserAuthFactors;
        }

        public final void setConfiguredUserAuthFactors(Collection<String> configuredUserAuthFactors) {
            this.configuredUserAuthFactors = ConfiguredUserAuthFactorsListTypeCopier.copy(configuredUserAuthFactors);
        }

        @Override
        public final Builder configuredUserAuthFactorsWithStrings(Collection<String> configuredUserAuthFactors) {
            this.configuredUserAuthFactors = ConfiguredUserAuthFactorsListTypeCopier.copy(configuredUserAuthFactors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredUserAuthFactorsWithStrings(String... configuredUserAuthFactors) {
            configuredUserAuthFactorsWithStrings(Arrays.asList(configuredUserAuthFactors));
            return this;
        }

        @Override
        public final Builder configuredUserAuthFactors(Collection<AuthFactorType> configuredUserAuthFactors) {
            this.configuredUserAuthFactors = ConfiguredUserAuthFactorsListTypeCopier.copyEnumToString(configuredUserAuthFactors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredUserAuthFactors(AuthFactorType... configuredUserAuthFactors) {
            configuredUserAuthFactors(Arrays.asList(configuredUserAuthFactors));
            return this;
        }

        @Override
        public GetUserAuthFactorsResponse build() {
            return new GetUserAuthFactorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
