/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWebAuthnCredentialsResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<ListWebAuthnCredentialsResponse.Builder, ListWebAuthnCredentialsResponse> {
    private static final SdkField<List<WebAuthnCredentialDescription>> CREDENTIALS_FIELD = SdkField
            .<List<WebAuthnCredentialDescription>> builder(MarshallingType.LIST)
            .memberName("Credentials")
            .getter(getter(ListWebAuthnCredentialsResponse::credentials))
            .setter(setter(Builder::credentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WebAuthnCredentialDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(WebAuthnCredentialDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWebAuthnCredentialsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Credentials", CREDENTIALS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<WebAuthnCredentialDescription> credentials;

    private final String nextToken;

    private ListWebAuthnCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Credentials property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCredentials() {
        return credentials != null && !(credentials instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of registered passkeys for a user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCredentials} method.
     * </p>
     * 
     * @return A list of registered passkeys for a user.
     */
    public final List<WebAuthnCredentialDescription> credentials() {
        return credentials;
    }

    /**
     * <p>
     * An identifier that you can use in a later request to return the next set of items in the list.
     * </p>
     * 
     * @return An identifier that you can use in a later request to return the next set of items in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCredentials() ? credentials() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebAuthnCredentialsResponse)) {
            return false;
        }
        ListWebAuthnCredentialsResponse other = (ListWebAuthnCredentialsResponse) obj;
        return hasCredentials() == other.hasCredentials() && Objects.equals(credentials(), other.credentials())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWebAuthnCredentialsResponse").add("Credentials", hasCredentials() ? credentials() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListWebAuthnCredentialsResponse, T> g) {
        return obj -> g.apply((ListWebAuthnCredentialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWebAuthnCredentialsResponse> {
        /**
         * <p>
         * A list of registered passkeys for a user.
         * </p>
         * 
         * @param credentials
         *        A list of registered passkeys for a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Collection<WebAuthnCredentialDescription> credentials);

        /**
         * <p>
         * A list of registered passkeys for a user.
         * </p>
         * 
         * @param credentials
         *        A list of registered passkeys for a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(WebAuthnCredentialDescription... credentials);

        /**
         * <p>
         * A list of registered passkeys for a user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnCredentialDescription.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnCredentialDescription#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnCredentialDescription.Builder#build()}
         * is called immediately and its result is passed to {@link #credentials(List<WebAuthnCredentialDescription>)}.
         * 
         * @param credentials
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnCredentialDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(java.util.Collection<WebAuthnCredentialDescription>)
         */
        Builder credentials(Consumer<WebAuthnCredentialDescription.Builder>... credentials);

        /**
         * <p>
         * An identifier that you can use in a later request to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that you can use in a later request to return the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private List<WebAuthnCredentialDescription> credentials = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebAuthnCredentialsResponse model) {
            super(model);
            credentials(model.credentials);
            nextToken(model.nextToken);
        }

        public final List<WebAuthnCredentialDescription.Builder> getCredentials() {
            List<WebAuthnCredentialDescription.Builder> result = WebAuthnCredentialDescriptionListTypeCopier
                    .copyToBuilder(this.credentials);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentials(Collection<WebAuthnCredentialDescription.BuilderImpl> credentials) {
            this.credentials = WebAuthnCredentialDescriptionListTypeCopier.copyFromBuilder(credentials);
        }

        @Override
        public final Builder credentials(Collection<WebAuthnCredentialDescription> credentials) {
            this.credentials = WebAuthnCredentialDescriptionListTypeCopier.copy(credentials);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(WebAuthnCredentialDescription... credentials) {
            credentials(Arrays.asList(credentials));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(Consumer<WebAuthnCredentialDescription.Builder>... credentials) {
            credentials(Stream.of(credentials).map(c -> WebAuthnCredentialDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWebAuthnCredentialsResponse build() {
            return new ListWebAuthnCredentialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
