/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetLogDeliveryConfigurationRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<SetLogDeliveryConfigurationRequest.Builder, SetLogDeliveryConfigurationRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(SetLogDeliveryConfigurationRequest::userPoolId))
            .setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<List<LogConfigurationType>> LOG_CONFIGURATIONS_FIELD = SdkField
            .<List<LogConfigurationType>> builder(MarshallingType.LIST)
            .memberName("LogConfigurations")
            .getter(getter(SetLogDeliveryConfigurationRequest::logConfigurations))
            .setter(setter(Builder::logConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogConfigurationType> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogConfigurationType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            LOG_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("UserPoolId", USER_POOL_ID_FIELD);
                    put("LogConfigurations", LOG_CONFIGURATIONS_FIELD);
                }
            });

    private final String userPoolId;

    private final List<LogConfigurationType> logConfigurations;

    private SetLogDeliveryConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.logConfigurations = builder.logConfigurations;
    }

    /**
     * <p>
     * The ID of the user pool where you want to configure logging.
     * </p>
     * 
     * @return The ID of the user pool where you want to configure logging.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogConfigurations() {
        return logConfigurations != null && !(logConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of the logging configurations for a user pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogConfigurations} method.
     * </p>
     * 
     * @return A collection of the logging configurations for a user pool.
     */
    public final List<LogConfigurationType> logConfigurations() {
        return logConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogConfigurations() ? logConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLogDeliveryConfigurationRequest)) {
            return false;
        }
        SetLogDeliveryConfigurationRequest other = (SetLogDeliveryConfigurationRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && hasLogConfigurations() == other.hasLogConfigurations()
                && Objects.equals(logConfigurations(), other.logConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetLogDeliveryConfigurationRequest").add("UserPoolId", userPoolId())
                .add("LogConfigurations", hasLogConfigurations() ? logConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "LogConfigurations":
            return Optional.ofNullable(clazz.cast(logConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SetLogDeliveryConfigurationRequest, T> g) {
        return obj -> g.apply((SetLogDeliveryConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetLogDeliveryConfigurationRequest> {
        /**
         * <p>
         * The ID of the user pool where you want to configure logging.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the user pool where you want to configure logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * A collection of the logging configurations for a user pool.
         * </p>
         * 
         * @param logConfigurations
         *        A collection of the logging configurations for a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfigurations(Collection<LogConfigurationType> logConfigurations);

        /**
         * <p>
         * A collection of the logging configurations for a user pool.
         * </p>
         * 
         * @param logConfigurations
         *        A collection of the logging configurations for a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfigurations(LogConfigurationType... logConfigurations);

        /**
         * <p>
         * A collection of the logging configurations for a user pool.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.LogConfigurationType.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.LogConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.LogConfigurationType.Builder#build()} is
         * called immediately and its result is passed to {@link #logConfigurations(List<LogConfigurationType>)}.
         * 
         * @param logConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.LogConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfigurations(java.util.Collection<LogConfigurationType>)
         */
        Builder logConfigurations(Consumer<LogConfigurationType.Builder>... logConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private List<LogConfigurationType> logConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SetLogDeliveryConfigurationRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            logConfigurations(model.logConfigurations);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final List<LogConfigurationType.Builder> getLogConfigurations() {
            List<LogConfigurationType.Builder> result = LogConfigurationListTypeCopier.copyToBuilder(this.logConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogConfigurations(Collection<LogConfigurationType.BuilderImpl> logConfigurations) {
            this.logConfigurations = LogConfigurationListTypeCopier.copyFromBuilder(logConfigurations);
        }

        @Override
        public final Builder logConfigurations(Collection<LogConfigurationType> logConfigurations) {
            this.logConfigurations = LogConfigurationListTypeCopier.copy(logConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logConfigurations(LogConfigurationType... logConfigurations) {
            logConfigurations(Arrays.asList(logConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logConfigurations(Consumer<LogConfigurationType.Builder>... logConfigurations) {
            logConfigurations(Stream.of(logConfigurations).map(c -> LogConfigurationType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetLogDeliveryConfigurationRequest build() {
            return new SetLogDeliveryConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
