/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartWebAuthnRegistrationResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<StartWebAuthnRegistrationResponse.Builder, StartWebAuthnRegistrationResponse> {
    private static final SdkField<Document> CREDENTIAL_CREATION_OPTIONS_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT).memberName("CredentialCreationOptions")
            .getter(getter(StartWebAuthnRegistrationResponse::credentialCreationOptions))
            .setter(setter(Builder::credentialCreationOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialCreationOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CREDENTIAL_CREATION_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CredentialCreationOptions", CREDENTIAL_CREATION_OPTIONS_FIELD);
                }
            });

    private final Document credentialCreationOptions;

    private StartWebAuthnRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.credentialCreationOptions = builder.credentialCreationOptions;
    }

    /**
     * <p>
     * The information that a user can provide in their request to register with their passkey provider.
     * </p>
     * 
     * @return The information that a user can provide in their request to register with their passkey provider.
     */
    public final Document credentialCreationOptions() {
        return credentialCreationOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(credentialCreationOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWebAuthnRegistrationResponse)) {
            return false;
        }
        StartWebAuthnRegistrationResponse other = (StartWebAuthnRegistrationResponse) obj;
        return Objects.equals(credentialCreationOptions(), other.credentialCreationOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartWebAuthnRegistrationResponse")
                .add("CredentialCreationOptions", credentialCreationOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CredentialCreationOptions":
            return Optional.ofNullable(clazz.cast(credentialCreationOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartWebAuthnRegistrationResponse, T> g) {
        return obj -> g.apply((StartWebAuthnRegistrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartWebAuthnRegistrationResponse> {
        /**
         * <p>
         * The information that a user can provide in their request to register with their passkey provider.
         * </p>
         * 
         * @param credentialCreationOptions
         *        The information that a user can provide in their request to register with their passkey provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialCreationOptions(Document credentialCreationOptions);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private Document credentialCreationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(StartWebAuthnRegistrationResponse model) {
            super(model);
            credentialCreationOptions(model.credentialCreationOptions);
        }

        public final Document getCredentialCreationOptions() {
            return credentialCreationOptions;
        }

        public final void setCredentialCreationOptions(Document credentialCreationOptions) {
            this.credentialCreationOptions = credentialCreationOptions;
        }

        @Override
        public final Builder credentialCreationOptions(Document credentialCreationOptions) {
            this.credentialCreationOptions = credentialCreationOptions;
            return this;
        }

        @Override
        public StartWebAuthnRegistrationResponse build() {
            return new StartWebAuthnRegistrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
