/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to verify user attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyUserAttributeRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<VerifyUserAttributeRequest.Builder, VerifyUserAttributeRequest> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessToken").getter(getter(VerifyUserAttributeRequest::accessToken))
            .setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(VerifyUserAttributeRequest::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(VerifyUserAttributeRequest::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            ATTRIBUTE_NAME_FIELD, CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AccessToken", ACCESS_TOKEN_FIELD);
                    put("AttributeName", ATTRIBUTE_NAME_FIELD);
                    put("Code", CODE_FIELD);
                }
            });

    private final String accessToken;

    private final String attributeName;

    private final String code;

    private VerifyUserAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.attributeName = builder.attributeName;
        this.code = builder.code;
    }

    /**
     * <p>
     * A valid access token that Amazon Cognito issued to the user whose user attributes you want to verify.
     * </p>
     * 
     * @return A valid access token that Amazon Cognito issued to the user whose user attributes you want to verify.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The attribute name in the request to verify user attributes.
     * </p>
     * 
     * @return The attribute name in the request to verify user attributes.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The verification code in the request to verify user attributes.
     * </p>
     * 
     * @return The verification code in the request to verify user attributes.
     */
    public final String code() {
        return code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyUserAttributeRequest)) {
            return false;
        }
        VerifyUserAttributeRequest other = (VerifyUserAttributeRequest) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(code(), other.code());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyUserAttributeRequest")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AttributeName", attributeName()).add("Code", code()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VerifyUserAttributeRequest, T> g) {
        return obj -> g.apply((VerifyUserAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, VerifyUserAttributeRequest> {
        /**
         * <p>
         * A valid access token that Amazon Cognito issued to the user whose user attributes you want to verify.
         * </p>
         * 
         * @param accessToken
         *        A valid access token that Amazon Cognito issued to the user whose user attributes you want to verify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The attribute name in the request to verify user attributes.
         * </p>
         * 
         * @param attributeName
         *        The attribute name in the request to verify user attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The verification code in the request to verify user attributes.
         * </p>
         * 
         * @param code
         *        The verification code in the request to verify user attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String accessToken;

        private String attributeName;

        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyUserAttributeRequest model) {
            super(model);
            accessToken(model.accessToken);
            attributeName(model.attributeName);
            code(model.code);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyUserAttributeRequest build() {
            return new VerifyUserAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
