/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignUpRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, SignUpRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SignUpRequest.getter(SignUpRequest::clientId)).setter(SignUpRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> SECRET_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SignUpRequest.getter(SignUpRequest::secretHash)).setter(SignUpRequest.setter(Builder::secretHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretHash").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SignUpRequest.getter(SignUpRequest::username)).setter(SignUpRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SignUpRequest.getter(SignUpRequest::password)).setter(SignUpRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<List<AttributeType>> USER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SignUpRequest.getter(SignUpRequest::userAttributes)).setter(SignUpRequest.setter(Builder::userAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AttributeType>> VALIDATION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SignUpRequest.getter(SignUpRequest::validationData)).setter(SignUpRequest.setter(Builder::validationData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AnalyticsMetadataType> ANALYTICS_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SignUpRequest.getter(SignUpRequest::analyticsMetadata)).setter(SignUpRequest.setter(Builder::analyticsMetadata)).constructor(AnalyticsMetadataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsMetadata").build()}).build();
    private static final SdkField<UserContextDataType> USER_CONTEXT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SignUpRequest.getter(SignUpRequest::userContextData)).setter(SignUpRequest.setter(Builder::userContextData)).constructor(UserContextDataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContextData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, SECRET_HASH_FIELD, USERNAME_FIELD, PASSWORD_FIELD, USER_ATTRIBUTES_FIELD, VALIDATION_DATA_FIELD, ANALYTICS_METADATA_FIELD, USER_CONTEXT_DATA_FIELD));
    private final String clientId;
    private final String secretHash;
    private final String username;
    private final String password;
    private final List<AttributeType> userAttributes;
    private final List<AttributeType> validationData;
    private final AnalyticsMetadataType analyticsMetadata;
    private final UserContextDataType userContextData;

    private SignUpRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.secretHash = builder.secretHash;
        this.username = builder.username;
        this.password = builder.password;
        this.userAttributes = builder.userAttributes;
        this.validationData = builder.validationData;
        this.analyticsMetadata = builder.analyticsMetadata;
        this.userContextData = builder.userContextData;
    }

    public String clientId() {
        return this.clientId;
    }

    public String secretHash() {
        return this.secretHash;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public List<AttributeType> userAttributes() {
        return this.userAttributes;
    }

    public List<AttributeType> validationData() {
        return this.validationData;
    }

    public AnalyticsMetadataType analyticsMetadata() {
        return this.analyticsMetadata;
    }

    public UserContextDataType userContextData() {
        return this.userContextData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationData());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyticsMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.userContextData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignUpRequest)) {
            return false;
        }
        SignUpRequest other = (SignUpRequest)((Object)obj);
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.secretHash(), other.secretHash()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.userAttributes(), other.userAttributes()) && Objects.equals(this.validationData(), other.validationData()) && Objects.equals(this.analyticsMetadata(), other.analyticsMetadata()) && Objects.equals(this.userContextData(), other.userContextData());
    }

    public String toString() {
        return ToString.builder((String)"SignUpRequest").add("ClientId", (Object)this.clientId()).add("SecretHash", (Object)this.secretHash()).add("Username", (Object)this.username()).add("Password", (Object)this.password()).add("UserAttributes", this.userAttributes()).add("ValidationData", this.validationData()).add("AnalyticsMetadata", (Object)this.analyticsMetadata()).add("UserContextData", (Object)this.userContextData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "SecretHash": {
                return Optional.ofNullable(clazz.cast(this.secretHash()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "UserAttributes": {
                return Optional.ofNullable(clazz.cast(this.userAttributes()));
            }
            case "ValidationData": {
                return Optional.ofNullable(clazz.cast(this.validationData()));
            }
            case "AnalyticsMetadata": {
                return Optional.ofNullable(clazz.cast(this.analyticsMetadata()));
            }
            case "UserContextData": {
                return Optional.ofNullable(clazz.cast(this.userContextData()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignUpRequest, T> g) {
        return obj -> g.apply((SignUpRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String clientId;
        private String secretHash;
        private String username;
        private String password;
        private List<AttributeType> userAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<AttributeType> validationData = DefaultSdkAutoConstructList.getInstance();
        private AnalyticsMetadataType analyticsMetadata;
        private UserContextDataType userContextData;

        private BuilderImpl() {
        }

        private BuilderImpl(SignUpRequest model) {
            super(model);
            this.clientId(model.clientId);
            this.secretHash(model.secretHash);
            this.username(model.username);
            this.password(model.password);
            this.userAttributes(model.userAttributes);
            this.validationData(model.validationData);
            this.analyticsMetadata(model.analyticsMetadata);
            this.userContextData(model.userContextData);
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getSecretHash() {
            return this.secretHash;
        }

        @Override
        public final Builder secretHash(String secretHash) {
            this.secretHash = secretHash;
            return this;
        }

        public final void setSecretHash(String secretHash) {
            this.secretHash = secretHash;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final Collection<AttributeType.Builder> getUserAttributes() {
            return this.userAttributes != null ? (Collection)this.userAttributes.stream().map(AttributeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userAttributes(Collection<AttributeType> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copy(userAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(AttributeType ... userAttributes) {
            this.userAttributes(Arrays.asList(userAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Consumer<AttributeType.Builder> ... userAttributes) {
            this.userAttributes(Stream.of(userAttributes).map(c -> (AttributeType)((AttributeType.Builder)AttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributes(Collection<AttributeType.BuilderImpl> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copyFromBuilder(userAttributes);
        }

        public final Collection<AttributeType.Builder> getValidationData() {
            return this.validationData != null ? (Collection)this.validationData.stream().map(AttributeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationData(Collection<AttributeType> validationData) {
            this.validationData = AttributeListTypeCopier.copy(validationData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationData(AttributeType ... validationData) {
            this.validationData(Arrays.asList(validationData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationData(Consumer<AttributeType.Builder> ... validationData) {
            this.validationData(Stream.of(validationData).map(c -> (AttributeType)((AttributeType.Builder)AttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidationData(Collection<AttributeType.BuilderImpl> validationData) {
            this.validationData = AttributeListTypeCopier.copyFromBuilder(validationData);
        }

        public final AnalyticsMetadataType.Builder getAnalyticsMetadata() {
            return this.analyticsMetadata != null ? this.analyticsMetadata.toBuilder() : null;
        }

        @Override
        public final Builder analyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
            this.analyticsMetadata = analyticsMetadata;
            return this;
        }

        public final void setAnalyticsMetadata(AnalyticsMetadataType.BuilderImpl analyticsMetadata) {
            this.analyticsMetadata = analyticsMetadata != null ? analyticsMetadata.build() : null;
        }

        public final UserContextDataType.Builder getUserContextData() {
            return this.userContextData != null ? this.userContextData.toBuilder() : null;
        }

        @Override
        public final Builder userContextData(UserContextDataType userContextData) {
            this.userContextData = userContextData;
            return this;
        }

        public final void setUserContextData(UserContextDataType.BuilderImpl userContextData) {
            this.userContextData = userContextData != null ? userContextData.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SignUpRequest build() {
            return new SignUpRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SignUpRequest> {
        public Builder clientId(String var1);

        public Builder secretHash(String var1);

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder userAttributes(Collection<AttributeType> var1);

        public Builder userAttributes(AttributeType ... var1);

        public Builder userAttributes(Consumer<AttributeType.Builder> ... var1);

        public Builder validationData(Collection<AttributeType> var1);

        public Builder validationData(AttributeType ... var1);

        public Builder validationData(Consumer<AttributeType.Builder> ... var1);

        public Builder analyticsMetadata(AnalyticsMetadataType var1);

        default public Builder analyticsMetadata(Consumer<AnalyticsMetadataType.Builder> analyticsMetadata) {
            return this.analyticsMetadata((AnalyticsMetadataType)((AnalyticsMetadataType.Builder)AnalyticsMetadataType.builder().applyMutation(analyticsMetadata)).build());
        }

        public Builder userContextData(UserContextDataType var1);

        default public Builder userContextData(Consumer<UserContextDataType.Builder> userContextData) {
            return this.userContextData((UserContextDataType)((UserContextDataType.Builder)UserContextDataType.builder().applyMutation(userContextData)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

