/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for mitigation actions and notification for different levels of risk detected for a potential account
 * takeover.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountTakeoverRiskConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountTakeoverRiskConfigurationType.Builder, AccountTakeoverRiskConfigurationType> {
    private static final SdkField<NotifyConfigurationType> NOTIFY_CONFIGURATION_FIELD = SdkField
            .<NotifyConfigurationType> builder(MarshallingType.SDK_POJO)
            .getter(getter(AccountTakeoverRiskConfigurationType::notifyConfiguration))
            .setter(setter(Builder::notifyConfiguration)).constructor(NotifyConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotifyConfiguration").build())
            .build();

    private static final SdkField<AccountTakeoverActionsType> ACTIONS_FIELD = SdkField
            .<AccountTakeoverActionsType> builder(MarshallingType.SDK_POJO)
            .getter(getter(AccountTakeoverRiskConfigurationType::actions)).setter(setter(Builder::actions))
            .constructor(AccountTakeoverActionsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFY_CONFIGURATION_FIELD,
            ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final NotifyConfigurationType notifyConfiguration;

    private final AccountTakeoverActionsType actions;

    private AccountTakeoverRiskConfigurationType(BuilderImpl builder) {
        this.notifyConfiguration = builder.notifyConfiguration;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The notify configuration used to construct email notifications.
     * </p>
     * 
     * @return The notify configuration used to construct email notifications.
     */
    public NotifyConfigurationType notifyConfiguration() {
        return notifyConfiguration;
    }

    /**
     * <p>
     * Account takeover risk configuration actions
     * </p>
     * 
     * @return Account takeover risk configuration actions
     */
    public AccountTakeoverActionsType actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notifyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountTakeoverRiskConfigurationType)) {
            return false;
        }
        AccountTakeoverRiskConfigurationType other = (AccountTakeoverRiskConfigurationType) obj;
        return Objects.equals(notifyConfiguration(), other.notifyConfiguration()) && Objects.equals(actions(), other.actions());
    }

    @Override
    public String toString() {
        return ToString.builder("AccountTakeoverRiskConfigurationType").add("NotifyConfiguration", notifyConfiguration())
                .add("Actions", actions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotifyConfiguration":
            return Optional.ofNullable(clazz.cast(notifyConfiguration()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountTakeoverRiskConfigurationType, T> g) {
        return obj -> g.apply((AccountTakeoverRiskConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountTakeoverRiskConfigurationType> {
        /**
         * <p>
         * The notify configuration used to construct email notifications.
         * </p>
         * 
         * @param notifyConfiguration
         *        The notify configuration used to construct email notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifyConfiguration(NotifyConfigurationType notifyConfiguration);

        /**
         * <p>
         * The notify configuration used to construct email notifications.
         * </p>
         * This is a convenience that creates an instance of the {@link NotifyConfigurationType.Builder} avoiding the
         * need to create one manually via {@link NotifyConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotifyConfigurationType.Builder#build()} is called immediately
         * and its result is passed to {@link #notifyConfiguration(NotifyConfigurationType)}.
         * 
         * @param notifyConfiguration
         *        a consumer that will call methods on {@link NotifyConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notifyConfiguration(NotifyConfigurationType)
         */
        default Builder notifyConfiguration(Consumer<NotifyConfigurationType.Builder> notifyConfiguration) {
            return notifyConfiguration(NotifyConfigurationType.builder().applyMutation(notifyConfiguration).build());
        }

        /**
         * <p>
         * Account takeover risk configuration actions
         * </p>
         * 
         * @param actions
         *        Account takeover risk configuration actions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(AccountTakeoverActionsType actions);

        /**
         * <p>
         * Account takeover risk configuration actions
         * </p>
         * This is a convenience that creates an instance of the {@link AccountTakeoverActionsType.Builder} avoiding the
         * need to create one manually via {@link AccountTakeoverActionsType#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccountTakeoverActionsType.Builder#build()} is called immediately
         * and its result is passed to {@link #actions(AccountTakeoverActionsType)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link AccountTakeoverActionsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(AccountTakeoverActionsType)
         */
        default Builder actions(Consumer<AccountTakeoverActionsType.Builder> actions) {
            return actions(AccountTakeoverActionsType.builder().applyMutation(actions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NotifyConfigurationType notifyConfiguration;

        private AccountTakeoverActionsType actions;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountTakeoverRiskConfigurationType model) {
            notifyConfiguration(model.notifyConfiguration);
            actions(model.actions);
        }

        public final NotifyConfigurationType.Builder getNotifyConfiguration() {
            return notifyConfiguration != null ? notifyConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder notifyConfiguration(NotifyConfigurationType notifyConfiguration) {
            this.notifyConfiguration = notifyConfiguration;
            return this;
        }

        public final void setNotifyConfiguration(NotifyConfigurationType.BuilderImpl notifyConfiguration) {
            this.notifyConfiguration = notifyConfiguration != null ? notifyConfiguration.build() : null;
        }

        public final AccountTakeoverActionsType.Builder getActions() {
            return actions != null ? actions.toBuilder() : null;
        }

        @Override
        public final Builder actions(AccountTakeoverActionsType actions) {
            this.actions = actions;
            return this;
        }

        public final void setActions(AccountTakeoverActionsType.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        @Override
        public AccountTakeoverRiskConfigurationType build() {
            return new AccountTakeoverRiskConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
