/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to update the device status, as an administrator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminUpdateDeviceStatusRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<AdminUpdateDeviceStatusRequest.Builder, AdminUpdateDeviceStatusRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminUpdateDeviceStatusRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminUpdateDeviceStatusRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> DEVICE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminUpdateDeviceStatusRequest::deviceKey)).setter(setter(Builder::deviceKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceKey").build()).build();

    private static final SdkField<String> DEVICE_REMEMBERED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminUpdateDeviceStatusRequest::deviceRememberedStatusAsString))
            .setter(setter(Builder::deviceRememberedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceRememberedStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            USERNAME_FIELD, DEVICE_KEY_FIELD, DEVICE_REMEMBERED_STATUS_FIELD));

    private final String userPoolId;

    private final String username;

    private final String deviceKey;

    private final String deviceRememberedStatus;

    private AdminUpdateDeviceStatusRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.username = builder.username;
        this.deviceKey = builder.deviceKey;
        this.deviceRememberedStatus = builder.deviceRememberedStatus;
    }

    /**
     * <p>
     * The user pool ID.
     * </p>
     * 
     * @return The user pool ID.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The user name.
     * </p>
     * 
     * @return The user name.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The device key.
     * </p>
     * 
     * @return The device key.
     */
    public String deviceKey() {
        return deviceKey;
    }

    /**
     * <p>
     * The status indicating whether a device has been remembered or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceRememberedStatus} will return {@link DeviceRememberedStatusType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceRememberedStatusAsString}.
     * </p>
     * 
     * @return The status indicating whether a device has been remembered or not.
     * @see DeviceRememberedStatusType
     */
    public DeviceRememberedStatusType deviceRememberedStatus() {
        return DeviceRememberedStatusType.fromValue(deviceRememberedStatus);
    }

    /**
     * <p>
     * The status indicating whether a device has been remembered or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceRememberedStatus} will return {@link DeviceRememberedStatusType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceRememberedStatusAsString}.
     * </p>
     * 
     * @return The status indicating whether a device has been remembered or not.
     * @see DeviceRememberedStatusType
     */
    public String deviceRememberedStatusAsString() {
        return deviceRememberedStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(deviceKey());
        hashCode = 31 * hashCode + Objects.hashCode(deviceRememberedStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminUpdateDeviceStatusRequest)) {
            return false;
        }
        AdminUpdateDeviceStatusRequest other = (AdminUpdateDeviceStatusRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(username(), other.username())
                && Objects.equals(deviceKey(), other.deviceKey())
                && Objects.equals(deviceRememberedStatusAsString(), other.deviceRememberedStatusAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("AdminUpdateDeviceStatusRequest").add("UserPoolId", userPoolId()).add("Username", username())
                .add("DeviceKey", deviceKey()).add("DeviceRememberedStatus", deviceRememberedStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "DeviceKey":
            return Optional.ofNullable(clazz.cast(deviceKey()));
        case "DeviceRememberedStatus":
            return Optional.ofNullable(clazz.cast(deviceRememberedStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminUpdateDeviceStatusRequest, T> g) {
        return obj -> g.apply((AdminUpdateDeviceStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AdminUpdateDeviceStatusRequest> {
        /**
         * <p>
         * The user pool ID.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The user name.
         * </p>
         * 
         * @param username
         *        The user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The device key.
         * </p>
         * 
         * @param deviceKey
         *        The device key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceKey(String deviceKey);

        /**
         * <p>
         * The status indicating whether a device has been remembered or not.
         * </p>
         * 
         * @param deviceRememberedStatus
         *        The status indicating whether a device has been remembered or not.
         * @see DeviceRememberedStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceRememberedStatusType
         */
        Builder deviceRememberedStatus(String deviceRememberedStatus);

        /**
         * <p>
         * The status indicating whether a device has been remembered or not.
         * </p>
         * 
         * @param deviceRememberedStatus
         *        The status indicating whether a device has been remembered or not.
         * @see DeviceRememberedStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceRememberedStatusType
         */
        Builder deviceRememberedStatus(DeviceRememberedStatusType deviceRememberedStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String username;

        private String deviceKey;

        private String deviceRememberedStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminUpdateDeviceStatusRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            username(model.username);
            deviceKey(model.deviceKey);
            deviceRememberedStatus(model.deviceRememberedStatus);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getDeviceKey() {
            return deviceKey;
        }

        @Override
        public final Builder deviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
            return this;
        }

        public final void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        public final String getDeviceRememberedStatusAsString() {
            return deviceRememberedStatus;
        }

        @Override
        public final Builder deviceRememberedStatus(String deviceRememberedStatus) {
            this.deviceRememberedStatus = deviceRememberedStatus;
            return this;
        }

        @Override
        public final Builder deviceRememberedStatus(DeviceRememberedStatusType deviceRememberedStatus) {
            this.deviceRememberedStatus(deviceRememberedStatus.toString());
            return this;
        }

        public final void setDeviceRememberedStatus(String deviceRememberedStatus) {
            this.deviceRememberedStatus = deviceRememberedStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminUpdateDeviceStatusRequest build() {
            return new AdminUpdateDeviceStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
