/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The compromised credentials risk configuration type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompromisedCredentialsRiskConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<CompromisedCredentialsRiskConfigurationType.Builder, CompromisedCredentialsRiskConfigurationType> {
    private static final SdkField<List<String>> EVENT_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CompromisedCredentialsRiskConfigurationType::eventFilterAsStrings))
            .setter(setter(Builder::eventFilterWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CompromisedCredentialsActionsType> ACTIONS_FIELD = SdkField
            .<CompromisedCredentialsActionsType> builder(MarshallingType.SDK_POJO)
            .getter(getter(CompromisedCredentialsRiskConfigurationType::actions)).setter(setter(Builder::actions))
            .constructor(CompromisedCredentialsActionsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FILTER_FIELD,
            ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> eventFilter;

    private final CompromisedCredentialsActionsType actions;

    private CompromisedCredentialsRiskConfigurationType(BuilderImpl builder) {
        this.eventFilter = builder.eventFilter;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * Perform the action for these events. The default is to perform all events if no event filter is specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Perform the action for these events. The default is to perform all events if no event filter is
     *         specified.
     */
    public List<EventFilterType> eventFilter() {
        return TypeConverter.convert(eventFilter, EventFilterType::fromValue);
    }

    /**
     * <p>
     * Perform the action for these events. The default is to perform all events if no event filter is specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Perform the action for these events. The default is to perform all events if no event filter is
     *         specified.
     */
    public List<String> eventFilterAsStrings() {
        return eventFilter;
    }

    /**
     * <p>
     * The compromised credentials risk configuration actions.
     * </p>
     * 
     * @return The compromised credentials risk configuration actions.
     */
    public CompromisedCredentialsActionsType actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventFilterAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompromisedCredentialsRiskConfigurationType)) {
            return false;
        }
        CompromisedCredentialsRiskConfigurationType other = (CompromisedCredentialsRiskConfigurationType) obj;
        return Objects.equals(eventFilterAsStrings(), other.eventFilterAsStrings()) && Objects.equals(actions(), other.actions());
    }

    @Override
    public String toString() {
        return ToString.builder("CompromisedCredentialsRiskConfigurationType").add("EventFilter", eventFilterAsStrings())
                .add("Actions", actions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventFilter":
            return Optional.ofNullable(clazz.cast(eventFilterAsStrings()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompromisedCredentialsRiskConfigurationType, T> g) {
        return obj -> g.apply((CompromisedCredentialsRiskConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompromisedCredentialsRiskConfigurationType> {
        /**
         * <p>
         * Perform the action for these events. The default is to perform all events if no event filter is specified.
         * </p>
         * 
         * @param eventFilter
         *        Perform the action for these events. The default is to perform all events if no event filter is
         *        specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilterWithStrings(Collection<String> eventFilter);

        /**
         * <p>
         * Perform the action for these events. The default is to perform all events if no event filter is specified.
         * </p>
         * 
         * @param eventFilter
         *        Perform the action for these events. The default is to perform all events if no event filter is
         *        specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilterWithStrings(String... eventFilter);

        /**
         * <p>
         * Perform the action for these events. The default is to perform all events if no event filter is specified.
         * </p>
         * 
         * @param eventFilter
         *        Perform the action for these events. The default is to perform all events if no event filter is
         *        specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilter(Collection<EventFilterType> eventFilter);

        /**
         * <p>
         * Perform the action for these events. The default is to perform all events if no event filter is specified.
         * </p>
         * 
         * @param eventFilter
         *        Perform the action for these events. The default is to perform all events if no event filter is
         *        specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilter(EventFilterType... eventFilter);

        /**
         * <p>
         * The compromised credentials risk configuration actions.
         * </p>
         * 
         * @param actions
         *        The compromised credentials risk configuration actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(CompromisedCredentialsActionsType actions);

        /**
         * <p>
         * The compromised credentials risk configuration actions.
         * </p>
         * This is a convenience that creates an instance of the {@link CompromisedCredentialsActionsType.Builder}
         * avoiding the need to create one manually via {@link CompromisedCredentialsActionsType#builder()}.
         *
         * When the {@link Consumer} completes, {@link CompromisedCredentialsActionsType.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(CompromisedCredentialsActionsType)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link CompromisedCredentialsActionsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(CompromisedCredentialsActionsType)
         */
        default Builder actions(Consumer<CompromisedCredentialsActionsType.Builder> actions) {
            return actions(CompromisedCredentialsActionsType.builder().applyMutation(actions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> eventFilter = DefaultSdkAutoConstructList.getInstance();

        private CompromisedCredentialsActionsType actions;

        private BuilderImpl() {
        }

        private BuilderImpl(CompromisedCredentialsRiskConfigurationType model) {
            eventFilterWithStrings(model.eventFilter);
            actions(model.actions);
        }

        public final Collection<String> getEventFilterAsStrings() {
            return eventFilter;
        }

        @Override
        public final Builder eventFilterWithStrings(Collection<String> eventFilter) {
            this.eventFilter = EventFiltersTypeCopier.copy(eventFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventFilterWithStrings(String... eventFilter) {
            eventFilterWithStrings(Arrays.asList(eventFilter));
            return this;
        }

        @Override
        public final Builder eventFilter(Collection<EventFilterType> eventFilter) {
            this.eventFilter = EventFiltersTypeCopier.copyEnumToString(eventFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventFilter(EventFilterType... eventFilter) {
            eventFilter(Arrays.asList(eventFilter));
            return this;
        }

        public final void setEventFilterWithStrings(Collection<String> eventFilter) {
            this.eventFilter = EventFiltersTypeCopier.copy(eventFilter);
        }

        public final CompromisedCredentialsActionsType.Builder getActions() {
            return actions != null ? actions.toBuilder() : null;
        }

        @Override
        public final Builder actions(CompromisedCredentialsActionsType actions) {
            this.actions = actions;
            return this;
        }

        public final void setActions(CompromisedCredentialsActionsType.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        @Override
        public CompromisedCredentialsRiskConfigurationType build() {
            return new CompromisedCredentialsRiskConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
