/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response to list user pools.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUserPoolsResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<ListUserPoolsResponse.Builder, ListUserPoolsResponse> {
    private static final SdkField<List<UserPoolDescriptionType>> USER_POOLS_FIELD = SdkField
            .<List<UserPoolDescriptionType>> builder(MarshallingType.LIST)
            .getter(getter(ListUserPoolsResponse::userPools))
            .setter(setter(Builder::userPools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserPoolDescriptionType> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserPoolDescriptionType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListUserPoolsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOLS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<UserPoolDescriptionType> userPools;

    private final String nextToken;

    private ListUserPoolsResponse(BuilderImpl builder) {
        super(builder);
        this.userPools = builder.userPools;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The user pools from the response to list users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The user pools from the response to list users.
     */
    public List<UserPoolDescriptionType> userPools() {
        return userPools;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPools());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserPoolsResponse)) {
            return false;
        }
        ListUserPoolsResponse other = (ListUserPoolsResponse) obj;
        return Objects.equals(userPools(), other.userPools()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListUserPoolsResponse").add("UserPools", userPools()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPools":
            return Optional.ofNullable(clazz.cast(userPools()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUserPoolsResponse, T> g) {
        return obj -> g.apply((ListUserPoolsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListUserPoolsResponse> {
        /**
         * <p>
         * The user pools from the response to list users.
         * </p>
         * 
         * @param userPools
         *        The user pools from the response to list users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPools(Collection<UserPoolDescriptionType> userPools);

        /**
         * <p>
         * The user pools from the response to list users.
         * </p>
         * 
         * @param userPools
         *        The user pools from the response to list users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPools(UserPoolDescriptionType... userPools);

        /**
         * <p>
         * The user pools from the response to list users.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserPoolDescriptionType>.Builder} avoiding
         * the need to create one manually via {@link List<UserPoolDescriptionType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserPoolDescriptionType>.Builder#build()} is called
         * immediately and its result is passed to {@link #userPools(List<UserPoolDescriptionType>)}.
         * 
         * @param userPools
         *        a consumer that will call methods on {@link List<UserPoolDescriptionType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPools(List<UserPoolDescriptionType>)
         */
        Builder userPools(Consumer<UserPoolDescriptionType.Builder>... userPools);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private List<UserPoolDescriptionType> userPools = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserPoolsResponse model) {
            super(model);
            userPools(model.userPools);
            nextToken(model.nextToken);
        }

        public final Collection<UserPoolDescriptionType.Builder> getUserPools() {
            return userPools != null ? userPools.stream().map(UserPoolDescriptionType::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder userPools(Collection<UserPoolDescriptionType> userPools) {
            this.userPools = UserPoolListTypeCopier.copy(userPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userPools(UserPoolDescriptionType... userPools) {
            userPools(Arrays.asList(userPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userPools(Consumer<UserPoolDescriptionType.Builder>... userPools) {
            userPools(Stream.of(userPools).map(c -> UserPoolDescriptionType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserPools(Collection<UserPoolDescriptionType.BuilderImpl> userPools) {
            this.userPools = UserPoolListTypeCopier.copyFromBuilder(userPools);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUserPoolsResponse build() {
            return new ListUserPoolsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
