/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetUiCustomizationRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<SetUiCustomizationRequest.Builder, SetUiCustomizationRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetUiCustomizationRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetUiCustomizationRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> CSS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetUiCustomizationRequest::css)).setter(setter(Builder::css))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CSS").build()).build();

    private static final SdkField<SdkBytes> IMAGE_FILE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(SetUiCustomizationRequest::imageFile)).setter(setter(Builder::imageFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageFile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            CLIENT_ID_FIELD, CSS_FIELD, IMAGE_FILE_FIELD));

    private final String userPoolId;

    private final String clientId;

    private final String css;

    private final SdkBytes imageFile;

    private SetUiCustomizationRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.css = builder.css;
        this.imageFile = builder.imageFile;
    }

    /**
     * <p>
     * The user pool ID for the user pool.
     * </p>
     * 
     * @return The user pool ID for the user pool.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The client ID for the client app.
     * </p>
     * 
     * @return The client ID for the client app.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The CSS values in the UI customization.
     * </p>
     * 
     * @return The CSS values in the UI customization.
     */
    public String css() {
        return css;
    }

    /**
     * <p>
     * The uploaded logo image for the UI customization.
     * </p>
     * 
     * @return The uploaded logo image for the UI customization.
     */
    public SdkBytes imageFile() {
        return imageFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(css());
        hashCode = 31 * hashCode + Objects.hashCode(imageFile());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetUiCustomizationRequest)) {
            return false;
        }
        SetUiCustomizationRequest other = (SetUiCustomizationRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(css(), other.css()) && Objects.equals(imageFile(), other.imageFile());
    }

    @Override
    public String toString() {
        return ToString.builder("SetUiCustomizationRequest").add("UserPoolId", userPoolId()).add("ClientId", clientId())
                .add("CSS", css()).add("ImageFile", imageFile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "CSS":
            return Optional.ofNullable(clazz.cast(css()));
        case "ImageFile":
            return Optional.ofNullable(clazz.cast(imageFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetUiCustomizationRequest, T> g) {
        return obj -> g.apply((SetUiCustomizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetUiCustomizationRequest> {
        /**
         * <p>
         * The user pool ID for the user pool.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The client ID for the client app.
         * </p>
         * 
         * @param clientId
         *        The client ID for the client app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The CSS values in the UI customization.
         * </p>
         * 
         * @param css
         *        The CSS values in the UI customization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder css(String css);

        /**
         * <p>
         * The uploaded logo image for the UI customization.
         * </p>
         * 
         * @param imageFile
         *        The uploaded logo image for the UI customization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageFile(SdkBytes imageFile);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String clientId;

        private String css;

        private SdkBytes imageFile;

        private BuilderImpl() {
        }

        private BuilderImpl(SetUiCustomizationRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            clientId(model.clientId);
            css(model.css);
            imageFile(model.imageFile);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getCss() {
            return css;
        }

        @Override
        public final Builder css(String css) {
            this.css = css;
            return this;
        }

        public final void setCss(String css) {
            this.css = css;
        }

        public final ByteBuffer getImageFile() {
            return imageFile == null ? null : imageFile.asByteBuffer();
        }

        @Override
        public final Builder imageFile(SdkBytes imageFile) {
            this.imageFile = StandardMemberCopier.copy(imageFile);
            return this;
        }

        public final void setImageFile(ByteBuffer imageFile) {
            imageFile(imageFile == null ? null : SdkBytes.fromByteBuffer(imageFile));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetUiCustomizationRequest build() {
            return new SetUiCustomizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
