/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SMS text message multi-factor authentication (MFA) configuration type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SmsMfaConfigType implements SdkPojo, Serializable,
        ToCopyableBuilder<SmsMfaConfigType.Builder, SmsMfaConfigType> {
    private static final SdkField<String> SMS_AUTHENTICATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SmsMfaConfigType::smsAuthenticationMessage)).setter(setter(Builder::smsAuthenticationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsAuthenticationMessage").build())
            .build();

    private static final SdkField<SmsConfigurationType> SMS_CONFIGURATION_FIELD = SdkField
            .<SmsConfigurationType> builder(MarshallingType.SDK_POJO).getter(getter(SmsMfaConfigType::smsConfiguration))
            .setter(setter(Builder::smsConfiguration)).constructor(SmsConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SMS_AUTHENTICATION_MESSAGE_FIELD, SMS_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String smsAuthenticationMessage;

    private final SmsConfigurationType smsConfiguration;

    private SmsMfaConfigType(BuilderImpl builder) {
        this.smsAuthenticationMessage = builder.smsAuthenticationMessage;
        this.smsConfiguration = builder.smsConfiguration;
    }

    /**
     * <p>
     * The SMS authentication message.
     * </p>
     * 
     * @return The SMS authentication message.
     */
    public String smsAuthenticationMessage() {
        return smsAuthenticationMessage;
    }

    /**
     * <p>
     * The SMS configuration.
     * </p>
     * 
     * @return The SMS configuration.
     */
    public SmsConfigurationType smsConfiguration() {
        return smsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(smsAuthenticationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(smsConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmsMfaConfigType)) {
            return false;
        }
        SmsMfaConfigType other = (SmsMfaConfigType) obj;
        return Objects.equals(smsAuthenticationMessage(), other.smsAuthenticationMessage())
                && Objects.equals(smsConfiguration(), other.smsConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("SmsMfaConfigType").add("SmsAuthenticationMessage", smsAuthenticationMessage())
                .add("SmsConfiguration", smsConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SmsAuthenticationMessage":
            return Optional.ofNullable(clazz.cast(smsAuthenticationMessage()));
        case "SmsConfiguration":
            return Optional.ofNullable(clazz.cast(smsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SmsMfaConfigType, T> g) {
        return obj -> g.apply((SmsMfaConfigType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SmsMfaConfigType> {
        /**
         * <p>
         * The SMS authentication message.
         * </p>
         * 
         * @param smsAuthenticationMessage
         *        The SMS authentication message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsAuthenticationMessage(String smsAuthenticationMessage);

        /**
         * <p>
         * The SMS configuration.
         * </p>
         * 
         * @param smsConfiguration
         *        The SMS configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsConfiguration(SmsConfigurationType smsConfiguration);

        /**
         * <p>
         * The SMS configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link SmsConfigurationType.Builder} avoiding the need
         * to create one manually via {@link SmsConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link SmsConfigurationType.Builder#build()} is called immediately and
         * its result is passed to {@link #smsConfiguration(SmsConfigurationType)}.
         * 
         * @param smsConfiguration
         *        a consumer that will call methods on {@link SmsConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsConfiguration(SmsConfigurationType)
         */
        default Builder smsConfiguration(Consumer<SmsConfigurationType.Builder> smsConfiguration) {
            return smsConfiguration(SmsConfigurationType.builder().applyMutation(smsConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String smsAuthenticationMessage;

        private SmsConfigurationType smsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SmsMfaConfigType model) {
            smsAuthenticationMessage(model.smsAuthenticationMessage);
            smsConfiguration(model.smsConfiguration);
        }

        public final String getSmsAuthenticationMessage() {
            return smsAuthenticationMessage;
        }

        @Override
        public final Builder smsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
            return this;
        }

        public final void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
        }

        public final SmsConfigurationType.Builder getSmsConfiguration() {
            return smsConfiguration != null ? smsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder smsConfiguration(SmsConfigurationType smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        public final void setSmsConfiguration(SmsConfigurationType.BuilderImpl smsConfiguration) {
            this.smsConfiguration = smsConfiguration != null ? smsConfiguration.build() : null;
        }

        @Override
        public SmsMfaConfigType build() {
            return new SmsMfaConfigType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
