/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon Pinpoint analytics endpoint.
 * </p>
 * <p>
 * An endpoint uniquely identifies a mobile device, email address, or phone number that can receive messages from Amazon
 * Pinpoint analytics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsMetadataType implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyticsMetadataType.Builder, AnalyticsMetadataType> {
    private static final SdkField<String> ANALYTICS_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalyticsMetadataType::analyticsEndpointId)).setter(setter(Builder::analyticsEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsEndpointId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYTICS_ENDPOINT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String analyticsEndpointId;

    private AnalyticsMetadataType(BuilderImpl builder) {
        this.analyticsEndpointId = builder.analyticsEndpointId;
    }

    /**
     * <p>
     * The endpoint ID.
     * </p>
     * 
     * @return The endpoint ID.
     */
    public String analyticsEndpointId() {
        return analyticsEndpointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(analyticsEndpointId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsMetadataType)) {
            return false;
        }
        AnalyticsMetadataType other = (AnalyticsMetadataType) obj;
        return Objects.equals(analyticsEndpointId(), other.analyticsEndpointId());
    }

    @Override
    public String toString() {
        return ToString.builder("AnalyticsMetadataType").add("AnalyticsEndpointId", analyticsEndpointId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalyticsEndpointId":
            return Optional.ofNullable(clazz.cast(analyticsEndpointId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsMetadataType, T> g) {
        return obj -> g.apply((AnalyticsMetadataType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyticsMetadataType> {
        /**
         * <p>
         * The endpoint ID.
         * </p>
         * 
         * @param analyticsEndpointId
         *        The endpoint ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyticsEndpointId(String analyticsEndpointId);
    }

    static final class BuilderImpl implements Builder {
        private String analyticsEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsMetadataType model) {
            analyticsEndpointId(model.analyticsEndpointId);
        }

        public final String getAnalyticsEndpointId() {
            return analyticsEndpointId;
        }

        @Override
        public final Builder analyticsEndpointId(String analyticsEndpointId) {
            this.analyticsEndpointId = analyticsEndpointId;
            return this;
        }

        public final void setAnalyticsEndpointId(String analyticsEndpointId) {
            this.analyticsEndpointId = analyticsEndpointId;
        }

        @Override
        public AnalyticsMetadataType build() {
            return new AnalyticsMetadataType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
