/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The HTTP header.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpHeader implements SdkPojo, Serializable, ToCopyableBuilder<HttpHeader.Builder, HttpHeader> {
    private static final SdkField<String> HEADER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HttpHeader::headerName)).setter(setter(Builder::headerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headerName").build()).build();

    private static final SdkField<String> HEADER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HttpHeader::headerValue)).setter(setter(Builder::headerValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headerValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_NAME_FIELD,
            HEADER_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String headerName;

    private final String headerValue;

    private HttpHeader(BuilderImpl builder) {
        this.headerName = builder.headerName;
        this.headerValue = builder.headerValue;
    }

    /**
     * <p>
     * The header name
     * </p>
     * 
     * @return The header name
     */
    public String headerName() {
        return headerName;
    }

    /**
     * <p>
     * The header value.
     * </p>
     * 
     * @return The header value.
     */
    public String headerValue() {
        return headerValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(headerName());
        hashCode = 31 * hashCode + Objects.hashCode(headerValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpHeader)) {
            return false;
        }
        HttpHeader other = (HttpHeader) obj;
        return Objects.equals(headerName(), other.headerName()) && Objects.equals(headerValue(), other.headerValue());
    }

    @Override
    public String toString() {
        return ToString.builder("HttpHeader").add("HeaderName", headerName()).add("HeaderValue", headerValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "headerName":
            return Optional.ofNullable(clazz.cast(headerName()));
        case "headerValue":
            return Optional.ofNullable(clazz.cast(headerValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpHeader, T> g) {
        return obj -> g.apply((HttpHeader) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpHeader> {
        /**
         * <p>
         * The header name
         * </p>
         * 
         * @param headerName
         *        The header name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerName(String headerName);

        /**
         * <p>
         * The header value.
         * </p>
         * 
         * @param headerValue
         *        The header value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerValue(String headerValue);
    }

    static final class BuilderImpl implements Builder {
        private String headerName;

        private String headerValue;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpHeader model) {
            headerName(model.headerName);
            headerValue(model.headerValue);
        }

        public final String getHeaderName() {
            return headerName;
        }

        @Override
        public final Builder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public final void setHeaderName(String headerName) {
            this.headerName = headerName;
        }

        public final String getHeaderValue() {
            return headerValue;
        }

        @Override
        public final Builder headerValue(String headerValue) {
            this.headerValue = headerValue;
            return this;
        }

        public final void setHeaderValue(String headerValue) {
            this.headerValue = headerValue;
        }

        @Override
        public HttpHeader build() {
            return new HttpHeader(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
