/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceServerResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<CreateResourceServerResponse.Builder, CreateResourceServerResponse> {
    private static final SdkField<ResourceServerType> RESOURCE_SERVER_FIELD = SdkField
            .<ResourceServerType> builder(MarshallingType.SDK_POJO).getter(getter(CreateResourceServerResponse::resourceServer))
            .setter(setter(Builder::resourceServer)).constructor(ResourceServerType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceServer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SERVER_FIELD));

    private final ResourceServerType resourceServer;

    private CreateResourceServerResponse(BuilderImpl builder) {
        super(builder);
        this.resourceServer = builder.resourceServer;
    }

    /**
     * <p>
     * The newly created resource server.
     * </p>
     * 
     * @return The newly created resource server.
     */
    public ResourceServerType resourceServer() {
        return resourceServer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceServer());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceServerResponse)) {
            return false;
        }
        CreateResourceServerResponse other = (CreateResourceServerResponse) obj;
        return Objects.equals(resourceServer(), other.resourceServer());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateResourceServerResponse").add("ResourceServer", resourceServer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceServer":
            return Optional.ofNullable(clazz.cast(resourceServer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceServerResponse, T> g) {
        return obj -> g.apply((CreateResourceServerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResourceServerResponse> {
        /**
         * <p>
         * The newly created resource server.
         * </p>
         * 
         * @param resourceServer
         *        The newly created resource server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceServer(ResourceServerType resourceServer);

        /**
         * <p>
         * The newly created resource server.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceServerType.Builder} avoiding the need to
         * create one manually via {@link ResourceServerType#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceServerType.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceServer(ResourceServerType)}.
         * 
         * @param resourceServer
         *        a consumer that will call methods on {@link ResourceServerType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceServer(ResourceServerType)
         */
        default Builder resourceServer(Consumer<ResourceServerType.Builder> resourceServer) {
            return resourceServer(ResourceServerType.builder().applyMutation(resourceServer).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private ResourceServerType resourceServer;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceServerResponse model) {
            super(model);
            resourceServer(model.resourceServer);
        }

        public final ResourceServerType.Builder getResourceServer() {
            return resourceServer != null ? resourceServer.toBuilder() : null;
        }

        @Override
        public final Builder resourceServer(ResourceServerType resourceServer) {
            this.resourceServer = resourceServer;
            return this;
        }

        public final void setResourceServer(ResourceServerType.BuilderImpl resourceServer) {
            this.resourceServer = resourceServer != null ? resourceServer.build() : null;
        }

        @Override
        public CreateResourceServerResponse build() {
            return new CreateResourceServerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
