/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUiCustomizationResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<GetUiCustomizationResponse.Builder, GetUiCustomizationResponse> {
    private static final SdkField<UICustomizationType> UI_CUSTOMIZATION_FIELD = SdkField
            .<UICustomizationType> builder(MarshallingType.SDK_POJO).getter(getter(GetUiCustomizationResponse::uiCustomization))
            .setter(setter(Builder::uiCustomization)).constructor(UICustomizationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UICustomization").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UI_CUSTOMIZATION_FIELD));

    private final UICustomizationType uiCustomization;

    private GetUiCustomizationResponse(BuilderImpl builder) {
        super(builder);
        this.uiCustomization = builder.uiCustomization;
    }

    /**
     * <p>
     * The UI customization information.
     * </p>
     * 
     * @return The UI customization information.
     */
    public UICustomizationType uiCustomization() {
        return uiCustomization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uiCustomization());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUiCustomizationResponse)) {
            return false;
        }
        GetUiCustomizationResponse other = (GetUiCustomizationResponse) obj;
        return Objects.equals(uiCustomization(), other.uiCustomization());
    }

    @Override
    public String toString() {
        return ToString.builder("GetUiCustomizationResponse").add("UICustomization", uiCustomization()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UICustomization":
            return Optional.ofNullable(clazz.cast(uiCustomization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUiCustomizationResponse, T> g) {
        return obj -> g.apply((GetUiCustomizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetUiCustomizationResponse> {
        /**
         * <p>
         * The UI customization information.
         * </p>
         * 
         * @param uiCustomization
         *        The UI customization information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uiCustomization(UICustomizationType uiCustomization);

        /**
         * <p>
         * The UI customization information.
         * </p>
         * This is a convenience that creates an instance of the {@link UICustomizationType.Builder} avoiding the need
         * to create one manually via {@link UICustomizationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link UICustomizationType.Builder#build()} is called immediately and
         * its result is passed to {@link #uiCustomization(UICustomizationType)}.
         * 
         * @param uiCustomization
         *        a consumer that will call methods on {@link UICustomizationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uiCustomization(UICustomizationType)
         */
        default Builder uiCustomization(Consumer<UICustomizationType.Builder> uiCustomization) {
            return uiCustomization(UICustomizationType.builder().applyMutation(uiCustomization).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private UICustomizationType uiCustomization;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUiCustomizationResponse model) {
            super(model);
            uiCustomization(model.uiCustomization);
        }

        public final UICustomizationType.Builder getUiCustomization() {
            return uiCustomization != null ? uiCustomization.toBuilder() : null;
        }

        @Override
        public final Builder uiCustomization(UICustomizationType uiCustomization) {
            this.uiCustomization = uiCustomization;
            return this;
        }

        public final void setUiCustomization(UICustomizationType.BuilderImpl uiCustomization) {
            this.uiCustomization = uiCustomization != null ? uiCustomization.build() : null;
        }

        @Override
        public GetUiCustomizationResponse build() {
            return new GetUiCustomizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
