/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminSetUserMfaPreferenceRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<AdminSetUserMfaPreferenceRequest.Builder, AdminSetUserMfaPreferenceRequest> {
    private static final SdkField<SMSMfaSettingsType> SMS_MFA_SETTINGS_FIELD = SdkField
            .<SMSMfaSettingsType> builder(MarshallingType.SDK_POJO)
            .getter(getter(AdminSetUserMfaPreferenceRequest::smsMfaSettings)).setter(setter(Builder::smsMfaSettings))
            .constructor(SMSMfaSettingsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSMfaSettings").build()).build();

    private static final SdkField<SoftwareTokenMfaSettingsType> SOFTWARE_TOKEN_MFA_SETTINGS_FIELD = SdkField
            .<SoftwareTokenMfaSettingsType> builder(MarshallingType.SDK_POJO)
            .getter(getter(AdminSetUserMfaPreferenceRequest::softwareTokenMfaSettings))
            .setter(setter(Builder::softwareTokenMfaSettings)).constructor(SoftwareTokenMfaSettingsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareTokenMfaSettings").build())
            .build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminSetUserMfaPreferenceRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminSetUserMfaPreferenceRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_MFA_SETTINGS_FIELD,
            SOFTWARE_TOKEN_MFA_SETTINGS_FIELD, USERNAME_FIELD, USER_POOL_ID_FIELD));

    private final SMSMfaSettingsType smsMfaSettings;

    private final SoftwareTokenMfaSettingsType softwareTokenMfaSettings;

    private final String username;

    private final String userPoolId;

    private AdminSetUserMfaPreferenceRequest(BuilderImpl builder) {
        super(builder);
        this.smsMfaSettings = builder.smsMfaSettings;
        this.softwareTokenMfaSettings = builder.softwareTokenMfaSettings;
        this.username = builder.username;
        this.userPoolId = builder.userPoolId;
    }

    /**
     * <p>
     * The SMS text message MFA settings.
     * </p>
     * 
     * @return The SMS text message MFA settings.
     */
    public SMSMfaSettingsType smsMfaSettings() {
        return smsMfaSettings;
    }

    /**
     * <p>
     * The time-based one-time password software token MFA settings.
     * </p>
     * 
     * @return The time-based one-time password software token MFA settings.
     */
    public SoftwareTokenMfaSettingsType softwareTokenMfaSettings() {
        return softwareTokenMfaSettings;
    }

    /**
     * <p>
     * The user pool username or alias.
     * </p>
     * 
     * @return The user pool username or alias.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The user pool ID.
     * </p>
     * 
     * @return The user pool ID.
     */
    public String userPoolId() {
        return userPoolId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(smsMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(softwareTokenMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminSetUserMfaPreferenceRequest)) {
            return false;
        }
        AdminSetUserMfaPreferenceRequest other = (AdminSetUserMfaPreferenceRequest) obj;
        return Objects.equals(smsMfaSettings(), other.smsMfaSettings())
                && Objects.equals(softwareTokenMfaSettings(), other.softwareTokenMfaSettings())
                && Objects.equals(username(), other.username()) && Objects.equals(userPoolId(), other.userPoolId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AdminSetUserMfaPreferenceRequest").add("SMSMfaSettings", smsMfaSettings())
                .add("SoftwareTokenMfaSettings", softwareTokenMfaSettings())
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***").add("UserPoolId", userPoolId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SMSMfaSettings":
            return Optional.ofNullable(clazz.cast(smsMfaSettings()));
        case "SoftwareTokenMfaSettings":
            return Optional.ofNullable(clazz.cast(softwareTokenMfaSettings()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminSetUserMfaPreferenceRequest, T> g) {
        return obj -> g.apply((AdminSetUserMfaPreferenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AdminSetUserMfaPreferenceRequest> {
        /**
         * <p>
         * The SMS text message MFA settings.
         * </p>
         * 
         * @param smsMfaSettings
         *        The SMS text message MFA settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsMfaSettings(SMSMfaSettingsType smsMfaSettings);

        /**
         * <p>
         * The SMS text message MFA settings.
         * </p>
         * This is a convenience that creates an instance of the {@link SMSMfaSettingsType.Builder} avoiding the need to
         * create one manually via {@link SMSMfaSettingsType#builder()}.
         *
         * When the {@link Consumer} completes, {@link SMSMfaSettingsType.Builder#build()} is called immediately and its
         * result is passed to {@link #smsMfaSettings(SMSMfaSettingsType)}.
         * 
         * @param smsMfaSettings
         *        a consumer that will call methods on {@link SMSMfaSettingsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsMfaSettings(SMSMfaSettingsType)
         */
        default Builder smsMfaSettings(Consumer<SMSMfaSettingsType.Builder> smsMfaSettings) {
            return smsMfaSettings(SMSMfaSettingsType.builder().applyMutation(smsMfaSettings).build());
        }

        /**
         * <p>
         * The time-based one-time password software token MFA settings.
         * </p>
         * 
         * @param softwareTokenMfaSettings
         *        The time-based one-time password software token MFA settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareTokenMfaSettings(SoftwareTokenMfaSettingsType softwareTokenMfaSettings);

        /**
         * <p>
         * The time-based one-time password software token MFA settings.
         * </p>
         * This is a convenience that creates an instance of the {@link SoftwareTokenMfaSettingsType.Builder} avoiding
         * the need to create one manually via {@link SoftwareTokenMfaSettingsType#builder()}.
         *
         * When the {@link Consumer} completes, {@link SoftwareTokenMfaSettingsType.Builder#build()} is called
         * immediately and its result is passed to {@link #softwareTokenMfaSettings(SoftwareTokenMfaSettingsType)}.
         * 
         * @param softwareTokenMfaSettings
         *        a consumer that will call methods on {@link SoftwareTokenMfaSettingsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #softwareTokenMfaSettings(SoftwareTokenMfaSettingsType)
         */
        default Builder softwareTokenMfaSettings(Consumer<SoftwareTokenMfaSettingsType.Builder> softwareTokenMfaSettings) {
            return softwareTokenMfaSettings(SoftwareTokenMfaSettingsType.builder().applyMutation(softwareTokenMfaSettings)
                    .build());
        }

        /**
         * <p>
         * The user pool username or alias.
         * </p>
         * 
         * @param username
         *        The user pool username or alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The user pool ID.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private SMSMfaSettingsType smsMfaSettings;

        private SoftwareTokenMfaSettingsType softwareTokenMfaSettings;

        private String username;

        private String userPoolId;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminSetUserMfaPreferenceRequest model) {
            super(model);
            smsMfaSettings(model.smsMfaSettings);
            softwareTokenMfaSettings(model.softwareTokenMfaSettings);
            username(model.username);
            userPoolId(model.userPoolId);
        }

        public final SMSMfaSettingsType.Builder getSmsMfaSettings() {
            return smsMfaSettings != null ? smsMfaSettings.toBuilder() : null;
        }

        @Override
        public final Builder smsMfaSettings(SMSMfaSettingsType smsMfaSettings) {
            this.smsMfaSettings = smsMfaSettings;
            return this;
        }

        public final void setSmsMfaSettings(SMSMfaSettingsType.BuilderImpl smsMfaSettings) {
            this.smsMfaSettings = smsMfaSettings != null ? smsMfaSettings.build() : null;
        }

        public final SoftwareTokenMfaSettingsType.Builder getSoftwareTokenMfaSettings() {
            return softwareTokenMfaSettings != null ? softwareTokenMfaSettings.toBuilder() : null;
        }

        @Override
        public final Builder softwareTokenMfaSettings(SoftwareTokenMfaSettingsType softwareTokenMfaSettings) {
            this.softwareTokenMfaSettings = softwareTokenMfaSettings;
            return this;
        }

        public final void setSoftwareTokenMfaSettings(SoftwareTokenMfaSettingsType.BuilderImpl softwareTokenMfaSettings) {
            this.softwareTokenMfaSettings = softwareTokenMfaSettings != null ? softwareTokenMfaSettings.build() : null;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminSetUserMfaPreferenceRequest build() {
            return new AdminSetUserMfaPreferenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
