/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The feedback that your application submitted to an advanced security features event log, as displayed in an <a
 * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminListUserAuthEvents.html"
 * >AdminListUserAuthEvents</a> response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventFeedbackType implements SdkPojo, Serializable,
        ToCopyableBuilder<EventFeedbackType.Builder, EventFeedbackType> {
    private static final SdkField<String> FEEDBACK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeedbackValue").getter(getter(EventFeedbackType::feedbackValueAsString))
            .setter(setter(Builder::feedbackValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackValue").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Provider").getter(getter(EventFeedbackType::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()).build();

    private static final SdkField<Instant> FEEDBACK_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FeedbackDate").getter(getter(EventFeedbackType::feedbackDate)).setter(setter(Builder::feedbackDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEEDBACK_VALUE_FIELD,
            PROVIDER_FIELD, FEEDBACK_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String feedbackValue;

    private final String provider;

    private final Instant feedbackDate;

    private EventFeedbackType(BuilderImpl builder) {
        this.feedbackValue = builder.feedbackValue;
        this.provider = builder.provider;
        this.feedbackDate = builder.feedbackDate;
    }

    /**
     * <p>
     * The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
     * <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has evaluated some
     * level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>, you tell Amazon
     * Cognito that you don't trust a user session, or you don't believe that Amazon Cognito evaluated a high-enough
     * risk level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedbackValue}
     * will return {@link FeedbackValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #feedbackValueAsString}.
     * </p>
     * 
     * @return The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
     *         <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has
     *         evaluated some level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>
     *         , you tell Amazon Cognito that you don't trust a user session, or you don't believe that Amazon Cognito
     *         evaluated a high-enough risk level.
     * @see FeedbackValueType
     */
    public final FeedbackValueType feedbackValue() {
        return FeedbackValueType.fromValue(feedbackValue);
    }

    /**
     * <p>
     * The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
     * <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has evaluated some
     * level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>, you tell Amazon
     * Cognito that you don't trust a user session, or you don't believe that Amazon Cognito evaluated a high-enough
     * risk level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedbackValue}
     * will return {@link FeedbackValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #feedbackValueAsString}.
     * </p>
     * 
     * @return The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
     *         <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has
     *         evaluated some level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>
     *         , you tell Amazon Cognito that you don't trust a user session, or you don't believe that Amazon Cognito
     *         evaluated a high-enough risk level.
     * @see FeedbackValueType
     */
    public final String feedbackValueAsString() {
        return feedbackValue;
    }

    /**
     * <p>
     * The submitter of the event feedback. For example, if you submit event feedback in the Amazon Cognito console,
     * this value is <code>Admin</code>.
     * </p>
     * 
     * @return The submitter of the event feedback. For example, if you submit event feedback in the Amazon Cognito
     *         console, this value is <code>Admin</code>.
     */
    public final String provider() {
        return provider;
    }

    /**
     * <p>
     * The date that you or your user submitted the feedback.
     * </p>
     * 
     * @return The date that you or your user submitted the feedback.
     */
    public final Instant feedbackDate() {
        return feedbackDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(feedbackValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventFeedbackType)) {
            return false;
        }
        EventFeedbackType other = (EventFeedbackType) obj;
        return Objects.equals(feedbackValueAsString(), other.feedbackValueAsString())
                && Objects.equals(provider(), other.provider()) && Objects.equals(feedbackDate(), other.feedbackDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventFeedbackType").add("FeedbackValue", feedbackValueAsString()).add("Provider", provider())
                .add("FeedbackDate", feedbackDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeedbackValue":
            return Optional.ofNullable(clazz.cast(feedbackValueAsString()));
        case "Provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "FeedbackDate":
            return Optional.ofNullable(clazz.cast(feedbackDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FeedbackValue", FEEDBACK_VALUE_FIELD);
        map.put("Provider", PROVIDER_FIELD);
        map.put("FeedbackDate", FEEDBACK_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventFeedbackType, T> g) {
        return obj -> g.apply((EventFeedbackType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventFeedbackType> {
        /**
         * <p>
         * The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
         * <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has evaluated
         * some level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>, you tell
         * Amazon Cognito that you don't trust a user session, or you don't believe that Amazon Cognito evaluated a
         * high-enough risk level.
         * </p>
         * 
         * @param feedbackValue
         *        The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
         *        <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has
         *        evaluated some level of risk. When you provide a <code>FeedbackValue</code> value of
         *        <code>invalid</code>, you tell Amazon Cognito that you don't trust a user session, or you don't
         *        believe that Amazon Cognito evaluated a high-enough risk level.
         * @see FeedbackValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeedbackValueType
         */
        Builder feedbackValue(String feedbackValue);

        /**
         * <p>
         * The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
         * <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has evaluated
         * some level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>, you tell
         * Amazon Cognito that you don't trust a user session, or you don't believe that Amazon Cognito evaluated a
         * high-enough risk level.
         * </p>
         * 
         * @param feedbackValue
         *        The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
         *        <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has
         *        evaluated some level of risk. When you provide a <code>FeedbackValue</code> value of
         *        <code>invalid</code>, you tell Amazon Cognito that you don't trust a user session, or you don't
         *        believe that Amazon Cognito evaluated a high-enough risk level.
         * @see FeedbackValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeedbackValueType
         */
        Builder feedbackValue(FeedbackValueType feedbackValue);

        /**
         * <p>
         * The submitter of the event feedback. For example, if you submit event feedback in the Amazon Cognito console,
         * this value is <code>Admin</code>.
         * </p>
         * 
         * @param provider
         *        The submitter of the event feedback. For example, if you submit event feedback in the Amazon Cognito
         *        console, this value is <code>Admin</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The date that you or your user submitted the feedback.
         * </p>
         * 
         * @param feedbackDate
         *        The date that you or your user submitted the feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedbackDate(Instant feedbackDate);
    }

    static final class BuilderImpl implements Builder {
        private String feedbackValue;

        private String provider;

        private Instant feedbackDate;

        private BuilderImpl() {
        }

        private BuilderImpl(EventFeedbackType model) {
            feedbackValue(model.feedbackValue);
            provider(model.provider);
            feedbackDate(model.feedbackDate);
        }

        public final String getFeedbackValue() {
            return feedbackValue;
        }

        public final void setFeedbackValue(String feedbackValue) {
            this.feedbackValue = feedbackValue;
        }

        @Override
        public final Builder feedbackValue(String feedbackValue) {
            this.feedbackValue = feedbackValue;
            return this;
        }

        @Override
        public final Builder feedbackValue(FeedbackValueType feedbackValue) {
            this.feedbackValue(feedbackValue == null ? null : feedbackValue.toString());
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final Instant getFeedbackDate() {
            return feedbackDate;
        }

        public final void setFeedbackDate(Instant feedbackDate) {
            this.feedbackDate = feedbackDate;
        }

        @Override
        public final Builder feedbackDate(Instant feedbackDate) {
            this.feedbackDate = feedbackDate;
            return this;
        }

        @Override
        public EventFeedbackType build() {
            return new EventFeedbackType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
