/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Advanced security configuration options for additional authentication types in your user pool, including custom
 * authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdvancedSecurityAdditionalFlowsType implements SdkPojo, Serializable,
        ToCopyableBuilder<AdvancedSecurityAdditionalFlowsType.Builder, AdvancedSecurityAdditionalFlowsType> {
    private static final SdkField<String> CUSTOM_AUTH_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomAuthMode").getter(getter(AdvancedSecurityAdditionalFlowsType::customAuthModeAsString))
            .setter(setter(Builder::customAuthMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAuthMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_AUTH_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String customAuthMode;

    private AdvancedSecurityAdditionalFlowsType(BuilderImpl builder) {
        this.customAuthMode = builder.customAuthMode;
    }

    /**
     * <p>
     * The operating mode of advanced security features in custom authentication with <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html"> Custom
     * authentication challenge Lambda triggers</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customAuthMode}
     * will return {@link AdvancedSecurityEnabledModeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #customAuthModeAsString}.
     * </p>
     * 
     * @return The operating mode of advanced security features in custom authentication with <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html"> Custom
     *         authentication challenge Lambda triggers</a>.
     * @see AdvancedSecurityEnabledModeType
     */
    public final AdvancedSecurityEnabledModeType customAuthMode() {
        return AdvancedSecurityEnabledModeType.fromValue(customAuthMode);
    }

    /**
     * <p>
     * The operating mode of advanced security features in custom authentication with <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html"> Custom
     * authentication challenge Lambda triggers</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customAuthMode}
     * will return {@link AdvancedSecurityEnabledModeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #customAuthModeAsString}.
     * </p>
     * 
     * @return The operating mode of advanced security features in custom authentication with <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html"> Custom
     *         authentication challenge Lambda triggers</a>.
     * @see AdvancedSecurityEnabledModeType
     */
    public final String customAuthModeAsString() {
        return customAuthMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customAuthModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedSecurityAdditionalFlowsType)) {
            return false;
        }
        AdvancedSecurityAdditionalFlowsType other = (AdvancedSecurityAdditionalFlowsType) obj;
        return Objects.equals(customAuthModeAsString(), other.customAuthModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdvancedSecurityAdditionalFlowsType").add("CustomAuthMode", customAuthModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomAuthMode":
            return Optional.ofNullable(clazz.cast(customAuthModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomAuthMode", CUSTOM_AUTH_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdvancedSecurityAdditionalFlowsType, T> g) {
        return obj -> g.apply((AdvancedSecurityAdditionalFlowsType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdvancedSecurityAdditionalFlowsType> {
        /**
         * <p>
         * The operating mode of advanced security features in custom authentication with <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html"> Custom
         * authentication challenge Lambda triggers</a>.
         * </p>
         * 
         * @param customAuthMode
         *        The operating mode of advanced security features in custom authentication with <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">
         *        Custom authentication challenge Lambda triggers</a>.
         * @see AdvancedSecurityEnabledModeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdvancedSecurityEnabledModeType
         */
        Builder customAuthMode(String customAuthMode);

        /**
         * <p>
         * The operating mode of advanced security features in custom authentication with <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html"> Custom
         * authentication challenge Lambda triggers</a>.
         * </p>
         * 
         * @param customAuthMode
         *        The operating mode of advanced security features in custom authentication with <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">
         *        Custom authentication challenge Lambda triggers</a>.
         * @see AdvancedSecurityEnabledModeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdvancedSecurityEnabledModeType
         */
        Builder customAuthMode(AdvancedSecurityEnabledModeType customAuthMode);
    }

    static final class BuilderImpl implements Builder {
        private String customAuthMode;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedSecurityAdditionalFlowsType model) {
            customAuthMode(model.customAuthMode);
        }

        public final String getCustomAuthMode() {
            return customAuthMode;
        }

        public final void setCustomAuthMode(String customAuthMode) {
            this.customAuthMode = customAuthMode;
        }

        @Override
        public final Builder customAuthMode(String customAuthMode) {
            this.customAuthMode = customAuthMode;
            return this;
        }

        @Override
        public final Builder customAuthMode(AdvancedSecurityEnabledModeType customAuthMode) {
            this.customAuthMode(customAuthMode == null ? null : customAuthMode.toString());
            return this;
        }

        @Override
        public AdvancedSecurityAdditionalFlowsType build() {
            return new AdvancedSecurityAdditionalFlowsType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
