/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of user event logs to an external Amazon Web Services service like Amazon Data Firehose, Amazon S3,
 * or Amazon CloudWatch Logs.
 * </p>
 * <p>
 * This data type is a request parameter of <a href=
 * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetLogDeliveryConfiguration.html"
 * >SetLogDeliveryConfiguration</a> and a response parameter of <a href=
 * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetLogDeliveryConfiguration.html"
 * >GetLogDeliveryConfiguration</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<LogConfigurationType.Builder, LogConfigurationType> {
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogLevel").getter(getter(LogConfigurationType::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()).build();

    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSource").getter(getter(LogConfigurationType::eventSourceAsString))
            .setter(setter(Builder::eventSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()).build();

    private static final SdkField<CloudWatchLogsConfigurationType> CLOUD_WATCH_LOGS_CONFIGURATION_FIELD = SdkField
            .<CloudWatchLogsConfigurationType> builder(MarshallingType.SDK_POJO)
            .memberName("CloudWatchLogsConfiguration")
            .getter(getter(LogConfigurationType::cloudWatchLogsConfiguration))
            .setter(setter(Builder::cloudWatchLogsConfiguration))
            .constructor(CloudWatchLogsConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsConfiguration")
                    .build()).build();

    private static final SdkField<S3ConfigurationType> S3_CONFIGURATION_FIELD = SdkField
            .<S3ConfigurationType> builder(MarshallingType.SDK_POJO).memberName("S3Configuration")
            .getter(getter(LogConfigurationType::s3Configuration)).setter(setter(Builder::s3Configuration))
            .constructor(S3ConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()).build();

    private static final SdkField<FirehoseConfigurationType> FIREHOSE_CONFIGURATION_FIELD = SdkField
            .<FirehoseConfigurationType> builder(MarshallingType.SDK_POJO).memberName("FirehoseConfiguration")
            .getter(getter(LogConfigurationType::firehoseConfiguration)).setter(setter(Builder::firehoseConfiguration))
            .constructor(FirehoseConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_LEVEL_FIELD,
            EVENT_SOURCE_FIELD, CLOUD_WATCH_LOGS_CONFIGURATION_FIELD, S3_CONFIGURATION_FIELD, FIREHOSE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logLevel;

    private final String eventSource;

    private final CloudWatchLogsConfigurationType cloudWatchLogsConfiguration;

    private final S3ConfigurationType s3Configuration;

    private final FirehoseConfigurationType firehoseConfiguration;

    private LogConfigurationType(BuilderImpl builder) {
        this.logLevel = builder.logLevel;
        this.eventSource = builder.eventSource;
        this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
        this.s3Configuration = builder.s3Configuration;
        this.firehoseConfiguration = builder.firehoseConfiguration;
    }

    /**
     * <p>
     * The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging. To send
     * <code>userNotification</code> activity with <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/tracking-quotas-and-usage-in-cloud-watch-logs.html"
     * >information about message delivery</a>, choose <code>ERROR</code> with <code>CloudWatchLogsConfiguration</code>.
     * To send <code>userAuthEvents</code> activity with user logs from advanced security features, choose
     * <code>INFO</code> with one of <code>CloudWatchLogsConfiguration</code>, <code>FirehoseConfiguration</code>, or
     * <code>S3Configuration</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging. To
     *         send <code>userNotification</code> activity with <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/tracking-quotas-and-usage-in-cloud-watch-logs.html"
     *         >information about message delivery</a>, choose <code>ERROR</code> with
     *         <code>CloudWatchLogsConfiguration</code>. To send <code>userAuthEvents</code> activity with user logs
     *         from advanced security features, choose <code>INFO</code> with one of
     *         <code>CloudWatchLogsConfiguration</code>, <code>FirehoseConfiguration</code>, or
     *         <code>S3Configuration</code>.
     * @see LogLevel
     */
    public final LogLevel logLevel() {
        return LogLevel.fromValue(logLevel);
    }

    /**
     * <p>
     * The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging. To send
     * <code>userNotification</code> activity with <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/tracking-quotas-and-usage-in-cloud-watch-logs.html"
     * >information about message delivery</a>, choose <code>ERROR</code> with <code>CloudWatchLogsConfiguration</code>.
     * To send <code>userAuthEvents</code> activity with user logs from advanced security features, choose
     * <code>INFO</code> with one of <code>CloudWatchLogsConfiguration</code>, <code>FirehoseConfiguration</code>, or
     * <code>S3Configuration</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging. To
     *         send <code>userNotification</code> activity with <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/tracking-quotas-and-usage-in-cloud-watch-logs.html"
     *         >information about message delivery</a>, choose <code>ERROR</code> with
     *         <code>CloudWatchLogsConfiguration</code>. To send <code>userAuthEvents</code> activity with user logs
     *         from advanced security features, choose <code>INFO</code> with one of
     *         <code>CloudWatchLogsConfiguration</code>, <code>FirehoseConfiguration</code>, or
     *         <code>S3Configuration</code>.
     * @see LogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    /**
     * <p>
     * The source of events that your user pool sends for logging. To send error-level logs about user notification
     * activity, set to <code>userNotification</code>. To send info-level logs about advanced security features user
     * activity, set to <code>userAuthEvents</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventSource} will
     * return {@link EventSourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventSourceAsString}.
     * </p>
     * 
     * @return The source of events that your user pool sends for logging. To send error-level logs about user
     *         notification activity, set to <code>userNotification</code>. To send info-level logs about advanced
     *         security features user activity, set to <code>userAuthEvents</code>.
     * @see EventSourceName
     */
    public final EventSourceName eventSource() {
        return EventSourceName.fromValue(eventSource);
    }

    /**
     * <p>
     * The source of events that your user pool sends for logging. To send error-level logs about user notification
     * activity, set to <code>userNotification</code>. To send info-level logs about advanced security features user
     * activity, set to <code>userAuthEvents</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventSource} will
     * return {@link EventSourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventSourceAsString}.
     * </p>
     * 
     * @return The source of events that your user pool sends for logging. To send error-level logs about user
     *         notification activity, set to <code>userNotification</code>. To send info-level logs about advanced
     *         security features user activity, set to <code>userAuthEvents</code>.
     * @see EventSourceName
     */
    public final String eventSourceAsString() {
        return eventSource;
    }

    /**
     * <p>
     * The CloudWatch log group destination of user pool detailed activity logs, or of user activity log export with
     * advanced security features.
     * </p>
     * 
     * @return The CloudWatch log group destination of user pool detailed activity logs, or of user activity log export
     *         with advanced security features.
     */
    public final CloudWatchLogsConfigurationType cloudWatchLogsConfiguration() {
        return cloudWatchLogsConfiguration;
    }

    /**
     * <p>
     * The Amazon S3 bucket destination of user activity log export with advanced security features. To activate this
     * setting, <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html">
     * advanced security features</a> must be active in your user pool.
     * </p>
     * 
     * @return The Amazon S3 bucket destination of user activity log export with advanced security features. To activate
     *         this setting, <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
     *         > advanced security features</a> must be active in your user pool.
     */
    public final S3ConfigurationType s3Configuration() {
        return s3Configuration;
    }

    /**
     * <p>
     * The Amazon Data Firehose stream destination of user activity log export with advanced security features. To
     * activate this setting, <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html">
     * advanced security features</a> must be active in your user pool.
     * </p>
     * 
     * @return The Amazon Data Firehose stream destination of user activity log export with advanced security features.
     *         To activate this setting, <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
     *         > advanced security features</a> must be active in your user pool.
     */
    public final FirehoseConfigurationType firehoseConfiguration() {
        return firehoseConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(firehoseConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfigurationType)) {
            return false;
        }
        LogConfigurationType other = (LogConfigurationType) obj;
        return Objects.equals(logLevelAsString(), other.logLevelAsString())
                && Objects.equals(eventSourceAsString(), other.eventSourceAsString())
                && Objects.equals(cloudWatchLogsConfiguration(), other.cloudWatchLogsConfiguration())
                && Objects.equals(s3Configuration(), other.s3Configuration())
                && Objects.equals(firehoseConfiguration(), other.firehoseConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogConfigurationType").add("LogLevel", logLevelAsString())
                .add("EventSource", eventSourceAsString()).add("CloudWatchLogsConfiguration", cloudWatchLogsConfiguration())
                .add("S3Configuration", s3Configuration()).add("FirehoseConfiguration", firehoseConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        case "EventSource":
            return Optional.ofNullable(clazz.cast(eventSourceAsString()));
        case "CloudWatchLogsConfiguration":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsConfiguration()));
        case "S3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        case "FirehoseConfiguration":
            return Optional.ofNullable(clazz.cast(firehoseConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogLevel", LOG_LEVEL_FIELD);
        map.put("EventSource", EVENT_SOURCE_FIELD);
        map.put("CloudWatchLogsConfiguration", CLOUD_WATCH_LOGS_CONFIGURATION_FIELD);
        map.put("S3Configuration", S3_CONFIGURATION_FIELD);
        map.put("FirehoseConfiguration", FIREHOSE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogConfigurationType, T> g) {
        return obj -> g.apply((LogConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogConfigurationType> {
        /**
         * <p>
         * The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging. To send
         * <code>userNotification</code> activity with <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/tracking-quotas-and-usage-in-cloud-watch-logs.html"
         * >information about message delivery</a>, choose <code>ERROR</code> with
         * <code>CloudWatchLogsConfiguration</code>. To send <code>userAuthEvents</code> activity with user logs from
         * advanced security features, choose <code>INFO</code> with one of <code>CloudWatchLogsConfiguration</code>,
         * <code>FirehoseConfiguration</code>, or <code>S3Configuration</code>.
         * </p>
         * 
         * @param logLevel
         *        The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging. To
         *        send <code>userNotification</code> activity with <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/tracking-quotas-and-usage-in-cloud-watch-logs.html"
         *        >information about message delivery</a>, choose <code>ERROR</code> with
         *        <code>CloudWatchLogsConfiguration</code>. To send <code>userAuthEvents</code> activity with user logs
         *        from advanced security features, choose <code>INFO</code> with one of
         *        <code>CloudWatchLogsConfiguration</code>, <code>FirehoseConfiguration</code>, or
         *        <code>S3Configuration</code>.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * <p>
         * The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging. To send
         * <code>userNotification</code> activity with <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/tracking-quotas-and-usage-in-cloud-watch-logs.html"
         * >information about message delivery</a>, choose <code>ERROR</code> with
         * <code>CloudWatchLogsConfiguration</code>. To send <code>userAuthEvents</code> activity with user logs from
         * advanced security features, choose <code>INFO</code> with one of <code>CloudWatchLogsConfiguration</code>,
         * <code>FirehoseConfiguration</code>, or <code>S3Configuration</code>.
         * </p>
         * 
         * @param logLevel
         *        The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging. To
         *        send <code>userNotification</code> activity with <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/tracking-quotas-and-usage-in-cloud-watch-logs.html"
         *        >information about message delivery</a>, choose <code>ERROR</code> with
         *        <code>CloudWatchLogsConfiguration</code>. To send <code>userAuthEvents</code> activity with user logs
         *        from advanced security features, choose <code>INFO</code> with one of
         *        <code>CloudWatchLogsConfiguration</code>, <code>FirehoseConfiguration</code>, or
         *        <code>S3Configuration</code>.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(LogLevel logLevel);

        /**
         * <p>
         * The source of events that your user pool sends for logging. To send error-level logs about user notification
         * activity, set to <code>userNotification</code>. To send info-level logs about advanced security features user
         * activity, set to <code>userAuthEvents</code>.
         * </p>
         * 
         * @param eventSource
         *        The source of events that your user pool sends for logging. To send error-level logs about user
         *        notification activity, set to <code>userNotification</code>. To send info-level logs about advanced
         *        security features user activity, set to <code>userAuthEvents</code>.
         * @see EventSourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceName
         */
        Builder eventSource(String eventSource);

        /**
         * <p>
         * The source of events that your user pool sends for logging. To send error-level logs about user notification
         * activity, set to <code>userNotification</code>. To send info-level logs about advanced security features user
         * activity, set to <code>userAuthEvents</code>.
         * </p>
         * 
         * @param eventSource
         *        The source of events that your user pool sends for logging. To send error-level logs about user
         *        notification activity, set to <code>userNotification</code>. To send info-level logs about advanced
         *        security features user activity, set to <code>userAuthEvents</code>.
         * @see EventSourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceName
         */
        Builder eventSource(EventSourceName eventSource);

        /**
         * <p>
         * The CloudWatch log group destination of user pool detailed activity logs, or of user activity log export with
         * advanced security features.
         * </p>
         * 
         * @param cloudWatchLogsConfiguration
         *        The CloudWatch log group destination of user pool detailed activity logs, or of user activity log
         *        export with advanced security features.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsConfiguration(CloudWatchLogsConfigurationType cloudWatchLogsConfiguration);

        /**
         * <p>
         * The CloudWatch log group destination of user pool detailed activity logs, or of user activity log export with
         * advanced security features.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogsConfigurationType.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLogsConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogsConfigurationType.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchLogsConfiguration(CloudWatchLogsConfigurationType)}.
         * 
         * @param cloudWatchLogsConfiguration
         *        a consumer that will call methods on {@link CloudWatchLogsConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogsConfiguration(CloudWatchLogsConfigurationType)
         */
        default Builder cloudWatchLogsConfiguration(Consumer<CloudWatchLogsConfigurationType.Builder> cloudWatchLogsConfiguration) {
            return cloudWatchLogsConfiguration(CloudWatchLogsConfigurationType.builder()
                    .applyMutation(cloudWatchLogsConfiguration).build());
        }

        /**
         * <p>
         * The Amazon S3 bucket destination of user activity log export with advanced security features. To activate
         * this setting, <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
         * > advanced security features</a> must be active in your user pool.
         * </p>
         * 
         * @param s3Configuration
         *        The Amazon S3 bucket destination of user activity log export with advanced security features. To
         *        activate this setting, <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
         *        > advanced security features</a> must be active in your user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3ConfigurationType s3Configuration);

        /**
         * <p>
         * The Amazon S3 bucket destination of user activity log export with advanced security features. To activate
         * this setting, <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
         * > advanced security features</a> must be active in your user pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ConfigurationType.Builder} avoiding the
         * need to create one manually via {@link S3ConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ConfigurationType.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Configuration(S3ConfigurationType)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link S3ConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(S3ConfigurationType)
         */
        default Builder s3Configuration(Consumer<S3ConfigurationType.Builder> s3Configuration) {
            return s3Configuration(S3ConfigurationType.builder().applyMutation(s3Configuration).build());
        }

        /**
         * <p>
         * The Amazon Data Firehose stream destination of user activity log export with advanced security features. To
         * activate this setting, <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
         * > advanced security features</a> must be active in your user pool.
         * </p>
         * 
         * @param firehoseConfiguration
         *        The Amazon Data Firehose stream destination of user activity log export with advanced security
         *        features. To activate this setting, <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
         *        > advanced security features</a> must be active in your user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehoseConfiguration(FirehoseConfigurationType firehoseConfiguration);

        /**
         * <p>
         * The Amazon Data Firehose stream destination of user activity log export with advanced security features. To
         * activate this setting, <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
         * > advanced security features</a> must be active in your user pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link FirehoseConfigurationType.Builder}
         * avoiding the need to create one manually via {@link FirehoseConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FirehoseConfigurationType.Builder#build()} is called immediately
         * and its result is passed to {@link #firehoseConfiguration(FirehoseConfigurationType)}.
         * 
         * @param firehoseConfiguration
         *        a consumer that will call methods on {@link FirehoseConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firehoseConfiguration(FirehoseConfigurationType)
         */
        default Builder firehoseConfiguration(Consumer<FirehoseConfigurationType.Builder> firehoseConfiguration) {
            return firehoseConfiguration(FirehoseConfigurationType.builder().applyMutation(firehoseConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String logLevel;

        private String eventSource;

        private CloudWatchLogsConfigurationType cloudWatchLogsConfiguration;

        private S3ConfigurationType s3Configuration;

        private FirehoseConfigurationType firehoseConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfigurationType model) {
            logLevel(model.logLevel);
            eventSource(model.eventSource);
            cloudWatchLogsConfiguration(model.cloudWatchLogsConfiguration);
            s3Configuration(model.s3Configuration);
            firehoseConfiguration(model.firehoseConfiguration);
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final String getEventSource() {
            return eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        @Override
        public final Builder eventSource(EventSourceName eventSource) {
            this.eventSource(eventSource == null ? null : eventSource.toString());
            return this;
        }

        public final CloudWatchLogsConfigurationType.Builder getCloudWatchLogsConfiguration() {
            return cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchLogsConfiguration(CloudWatchLogsConfigurationType.BuilderImpl cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsConfiguration(CloudWatchLogsConfigurationType cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
            return this;
        }

        public final S3ConfigurationType.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3ConfigurationType.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3ConfigurationType s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final FirehoseConfigurationType.Builder getFirehoseConfiguration() {
            return firehoseConfiguration != null ? firehoseConfiguration.toBuilder() : null;
        }

        public final void setFirehoseConfiguration(FirehoseConfigurationType.BuilderImpl firehoseConfiguration) {
            this.firehoseConfiguration = firehoseConfiguration != null ? firehoseConfiguration.build() : null;
        }

        @Override
        public final Builder firehoseConfiguration(FirehoseConfigurationType firehoseConfiguration) {
            this.firehoseConfiguration = firehoseConfiguration;
            return this;
        }

        @Override
        public LogConfigurationType build() {
            return new LogConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
