/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AssetCategoryType {
    FAVICON_ICO("FAVICON_ICO"),
    FAVICON_SVG("FAVICON_SVG"),
    EMAIL_GRAPHIC("EMAIL_GRAPHIC"),
    SMS_GRAPHIC("SMS_GRAPHIC"),
    AUTH_APP_GRAPHIC("AUTH_APP_GRAPHIC"),
    PASSWORD_GRAPHIC("PASSWORD_GRAPHIC"),
    PASSKEY_GRAPHIC("PASSKEY_GRAPHIC"),
    PAGE_HEADER_LOGO("PAGE_HEADER_LOGO"),
    PAGE_HEADER_BACKGROUND("PAGE_HEADER_BACKGROUND"),
    PAGE_FOOTER_LOGO("PAGE_FOOTER_LOGO"),
    PAGE_FOOTER_BACKGROUND("PAGE_FOOTER_BACKGROUND"),
    PAGE_BACKGROUND("PAGE_BACKGROUND"),
    FORM_BACKGROUND("FORM_BACKGROUND"),
    FORM_LOGO("FORM_LOGO"),
    IDP_BUTTON_ICON("IDP_BUTTON_ICON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssetCategoryType> VALUE_MAP;
    private final String value;

    private AssetCategoryType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssetCategoryType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssetCategoryType> knownValues() {
        EnumSet<AssetCategoryType> knownValues = EnumSet.allOf(AssetCategoryType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AssetCategoryType.class, AssetCategoryType::toString);
    }
}

