/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompleteWebAuthnRegistrationRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<CompleteWebAuthnRegistrationRequest.Builder, CompleteWebAuthnRegistrationRequest> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessToken").getter(getter(CompleteWebAuthnRegistrationRequest::accessToken))
            .setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()).build();

    private static final SdkField<Document> CREDENTIAL_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("Credential").getter(getter(CompleteWebAuthnRegistrationRequest::credential))
            .setter(setter(Builder::credential))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credential").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            CREDENTIAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accessToken;

    private final Document credential;

    private CompleteWebAuthnRegistrationRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.credential = builder.credential;
    }

    /**
     * <p>
     * A valid access token that Amazon Cognito issued to the currently signed-in user. Must include a scope claim for
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * 
     * @return A valid access token that Amazon Cognito issued to the currently signed-in user. Must include a scope
     *         claim for <code>aws.cognito.signin.user.admin</code>.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * A <a href="https://www.w3.org/TR/WebAuthn-3/#dictdef-registrationresponsejson">RegistrationResponseJSON</a>
     * public-key credential response from the user's passkey provider.
     * </p>
     * 
     * @return A <a
     *         href="https://www.w3.org/TR/WebAuthn-3/#dictdef-registrationresponsejson">RegistrationResponseJSON</a>
     *         public-key credential response from the user's passkey provider.
     */
    public final Document credential() {
        return credential;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(credential());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteWebAuthnRegistrationRequest)) {
            return false;
        }
        CompleteWebAuthnRegistrationRequest other = (CompleteWebAuthnRegistrationRequest) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(credential(), other.credential());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompleteWebAuthnRegistrationRequest")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Credential", credential()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "Credential":
            return Optional.ofNullable(clazz.cast(credential()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessToken", ACCESS_TOKEN_FIELD);
        map.put("Credential", CREDENTIAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompleteWebAuthnRegistrationRequest, T> g) {
        return obj -> g.apply((CompleteWebAuthnRegistrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CompleteWebAuthnRegistrationRequest> {
        /**
         * <p>
         * A valid access token that Amazon Cognito issued to the currently signed-in user. Must include a scope claim
         * for <code>aws.cognito.signin.user.admin</code>.
         * </p>
         * 
         * @param accessToken
         *        A valid access token that Amazon Cognito issued to the currently signed-in user. Must include a scope
         *        claim for <code>aws.cognito.signin.user.admin</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * A <a href="https://www.w3.org/TR/WebAuthn-3/#dictdef-registrationresponsejson">RegistrationResponseJSON</a>
         * public-key credential response from the user's passkey provider.
         * </p>
         * 
         * @param credential
         *        A <a
         *        href="https://www.w3.org/TR/WebAuthn-3/#dictdef-registrationresponsejson">RegistrationResponseJSON</a>
         *        public-key credential response from the user's passkey provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credential(Document credential);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String accessToken;

        private Document credential;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteWebAuthnRegistrationRequest model) {
            super(model);
            accessToken(model.accessToken);
            credential(model.credential);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final Document getCredential() {
            return credential;
        }

        public final void setCredential(Document credential) {
            this.credential = credential;
        }

        @Override
        public final Builder credential(Document credential) {
            this.credential = credential;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CompleteWebAuthnRegistrationRequest build() {
            return new CompleteWebAuthnRegistrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
