/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserPoolDomainRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<CreateUserPoolDomainRequest.Builder, CreateUserPoolDomainRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(CreateUserPoolDomainRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(CreateUserPoolDomainRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<Integer> MANAGED_LOGIN_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManagedLoginVersion").getter(getter(CreateUserPoolDomainRequest::managedLoginVersion))
            .setter(setter(Builder::managedLoginVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedLoginVersion").build())
            .build();

    private static final SdkField<CustomDomainConfigType> CUSTOM_DOMAIN_CONFIG_FIELD = SdkField
            .<CustomDomainConfigType> builder(MarshallingType.SDK_POJO).memberName("CustomDomainConfig")
            .getter(getter(CreateUserPoolDomainRequest::customDomainConfig)).setter(setter(Builder::customDomainConfig))
            .constructor(CustomDomainConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            USER_POOL_ID_FIELD, MANAGED_LOGIN_VERSION_FIELD, CUSTOM_DOMAIN_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domain;

    private final String userPoolId;

    private final Integer managedLoginVersion;

    private final CustomDomainConfigType customDomainConfig;

    private CreateUserPoolDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.userPoolId = builder.userPoolId;
        this.managedLoginVersion = builder.managedLoginVersion;
        this.customDomainConfig = builder.customDomainConfig;
    }

    /**
     * <p>
     * The domain string. For custom domains, this is the fully-qualified domain name, such as
     * <code>auth.example.com</code>. For prefix domains, this is the prefix alone, such as <code>myprefix</code>. A
     * prefix value of <code>myprefix</code> for a user pool in the <code>us-east-1</code> Region results in a domain of
     * <code>myprefix.auth.us-east-1.amazoncognito.com</code>.
     * </p>
     * 
     * @return The domain string. For custom domains, this is the fully-qualified domain name, such as
     *         <code>auth.example.com</code>. For prefix domains, this is the prefix alone, such as
     *         <code>myprefix</code>. A prefix value of <code>myprefix</code> for a user pool in the
     *         <code>us-east-1</code> Region results in a domain of
     *         <code>myprefix.auth.us-east-1.amazoncognito.com</code>.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The ID of the user pool where you want to add a domain.
     * </p>
     * 
     * @return The ID of the user pool where you want to add a domain.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The version of managed login branding that you want to apply to your domain. A value of <code>1</code> indicates
     * hosted UI (classic) and a version of <code>2</code> indicates managed login.
     * </p>
     * <p>
     * Managed login requires that your user pool be configured for any <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html">feature
     * plan</a> other than <code>Lite</code>.
     * </p>
     * 
     * @return The version of managed login branding that you want to apply to your domain. A value of <code>1</code>
     *         indicates hosted UI (classic) and a version of <code>2</code> indicates managed login.</p>
     *         <p>
     *         Managed login requires that your user pool be configured for any <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html"
     *         >feature plan</a> other than <code>Lite</code>.
     */
    public final Integer managedLoginVersion() {
        return managedLoginVersion;
    }

    /**
     * <p>
     * The configuration for a custom domain. Configures your domain with an Certificate Manager certificate in the
     * <code>us-east-1</code> Region.
     * </p>
     * <p>
     * Provide this parameter only if you want to use a <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">custom
     * domain</a> for your user pool. Otherwise, you can omit this parameter and use a <a
     * href="cognito/latest/developerguide/cognito-user-pools-assign-domain-prefix.html">prefix domain</a> instead.
     * </p>
     * <p>
     * When you create a custom domain, the passkey RP ID defaults to the custom domain. If you had a prefix domain
     * active, this will cause passkey integration for your prefix domain to stop working due to a mismatch in RP ID. To
     * keep the prefix domain passkey integration working, you can explicitly set RP ID to the prefix domain.
     * </p>
     * 
     * @return The configuration for a custom domain. Configures your domain with an Certificate Manager certificate in
     *         the <code>us-east-1</code> Region.</p>
     *         <p>
     *         Provide this parameter only if you want to use a <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html"
     *         >custom domain</a> for your user pool. Otherwise, you can omit this parameter and use a <a
     *         href="cognito/latest/developerguide/cognito-user-pools-assign-domain-prefix.html">prefix domain</a>
     *         instead.
     *         </p>
     *         <p>
     *         When you create a custom domain, the passkey RP ID defaults to the custom domain. If you had a prefix
     *         domain active, this will cause passkey integration for your prefix domain to stop working due to a
     *         mismatch in RP ID. To keep the prefix domain passkey integration working, you can explicitly set RP ID to
     *         the prefix domain.
     */
    public final CustomDomainConfigType customDomainConfig() {
        return customDomainConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(managedLoginVersion());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserPoolDomainRequest)) {
            return false;
        }
        CreateUserPoolDomainRequest other = (CreateUserPoolDomainRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(userPoolId(), other.userPoolId())
                && Objects.equals(managedLoginVersion(), other.managedLoginVersion())
                && Objects.equals(customDomainConfig(), other.customDomainConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserPoolDomainRequest").add("Domain", domain()).add("UserPoolId", userPoolId())
                .add("ManagedLoginVersion", managedLoginVersion()).add("CustomDomainConfig", customDomainConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ManagedLoginVersion":
            return Optional.ofNullable(clazz.cast(managedLoginVersion()));
        case "CustomDomainConfig":
            return Optional.ofNullable(clazz.cast(customDomainConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Domain", DOMAIN_FIELD);
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("ManagedLoginVersion", MANAGED_LOGIN_VERSION_FIELD);
        map.put("CustomDomainConfig", CUSTOM_DOMAIN_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUserPoolDomainRequest, T> g) {
        return obj -> g.apply((CreateUserPoolDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateUserPoolDomainRequest> {
        /**
         * <p>
         * The domain string. For custom domains, this is the fully-qualified domain name, such as
         * <code>auth.example.com</code>. For prefix domains, this is the prefix alone, such as <code>myprefix</code>. A
         * prefix value of <code>myprefix</code> for a user pool in the <code>us-east-1</code> Region results in a
         * domain of <code>myprefix.auth.us-east-1.amazoncognito.com</code>.
         * </p>
         * 
         * @param domain
         *        The domain string. For custom domains, this is the fully-qualified domain name, such as
         *        <code>auth.example.com</code>. For prefix domains, this is the prefix alone, such as
         *        <code>myprefix</code>. A prefix value of <code>myprefix</code> for a user pool in the
         *        <code>us-east-1</code> Region results in a domain of
         *        <code>myprefix.auth.us-east-1.amazoncognito.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The ID of the user pool where you want to add a domain.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the user pool where you want to add a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The version of managed login branding that you want to apply to your domain. A value of <code>1</code>
         * indicates hosted UI (classic) and a version of <code>2</code> indicates managed login.
         * </p>
         * <p>
         * Managed login requires that your user pool be configured for any <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html">feature
         * plan</a> other than <code>Lite</code>.
         * </p>
         * 
         * @param managedLoginVersion
         *        The version of managed login branding that you want to apply to your domain. A value of <code>1</code>
         *        indicates hosted UI (classic) and a version of <code>2</code> indicates managed login.</p>
         *        <p>
         *        Managed login requires that your user pool be configured for any <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html"
         *        >feature plan</a> other than <code>Lite</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedLoginVersion(Integer managedLoginVersion);

        /**
         * <p>
         * The configuration for a custom domain. Configures your domain with an Certificate Manager certificate in the
         * <code>us-east-1</code> Region.
         * </p>
         * <p>
         * Provide this parameter only if you want to use a <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html"
         * >custom domain</a> for your user pool. Otherwise, you can omit this parameter and use a <a
         * href="cognito/latest/developerguide/cognito-user-pools-assign-domain-prefix.html">prefix domain</a> instead.
         * </p>
         * <p>
         * When you create a custom domain, the passkey RP ID defaults to the custom domain. If you had a prefix domain
         * active, this will cause passkey integration for your prefix domain to stop working due to a mismatch in RP
         * ID. To keep the prefix domain passkey integration working, you can explicitly set RP ID to the prefix domain.
         * </p>
         * 
         * @param customDomainConfig
         *        The configuration for a custom domain. Configures your domain with an Certificate Manager certificate
         *        in the <code>us-east-1</code> Region.</p>
         *        <p>
         *        Provide this parameter only if you want to use a <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html"
         *        >custom domain</a> for your user pool. Otherwise, you can omit this parameter and use a <a
         *        href="cognito/latest/developerguide/cognito-user-pools-assign-domain-prefix.html">prefix domain</a>
         *        instead.
         *        </p>
         *        <p>
         *        When you create a custom domain, the passkey RP ID defaults to the custom domain. If you had a prefix
         *        domain active, this will cause passkey integration for your prefix domain to stop working due to a
         *        mismatch in RP ID. To keep the prefix domain passkey integration working, you can explicitly set RP ID
         *        to the prefix domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainConfig(CustomDomainConfigType customDomainConfig);

        /**
         * <p>
         * The configuration for a custom domain. Configures your domain with an Certificate Manager certificate in the
         * <code>us-east-1</code> Region.
         * </p>
         * <p>
         * Provide this parameter only if you want to use a <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html"
         * >custom domain</a> for your user pool. Otherwise, you can omit this parameter and use a <a
         * href="cognito/latest/developerguide/cognito-user-pools-assign-domain-prefix.html">prefix domain</a> instead.
         * </p>
         * <p>
         * When you create a custom domain, the passkey RP ID defaults to the custom domain. If you had a prefix domain
         * active, this will cause passkey integration for your prefix domain to stop working due to a mismatch in RP
         * ID. To keep the prefix domain passkey integration working, you can explicitly set RP ID to the prefix domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomDomainConfigType.Builder} avoiding
         * the need to create one manually via {@link CustomDomainConfigType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomDomainConfigType.Builder#build()} is called immediately and
         * its result is passed to {@link #customDomainConfig(CustomDomainConfigType)}.
         * 
         * @param customDomainConfig
         *        a consumer that will call methods on {@link CustomDomainConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDomainConfig(CustomDomainConfigType)
         */
        default Builder customDomainConfig(Consumer<CustomDomainConfigType.Builder> customDomainConfig) {
            return customDomainConfig(CustomDomainConfigType.builder().applyMutation(customDomainConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String domain;

        private String userPoolId;

        private Integer managedLoginVersion;

        private CustomDomainConfigType customDomainConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserPoolDomainRequest model) {
            super(model);
            domain(model.domain);
            userPoolId(model.userPoolId);
            managedLoginVersion(model.managedLoginVersion);
            customDomainConfig(model.customDomainConfig);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final Integer getManagedLoginVersion() {
            return managedLoginVersion;
        }

        public final void setManagedLoginVersion(Integer managedLoginVersion) {
            this.managedLoginVersion = managedLoginVersion;
        }

        @Override
        public final Builder managedLoginVersion(Integer managedLoginVersion) {
            this.managedLoginVersion = managedLoginVersion;
            return this;
        }

        public final CustomDomainConfigType.Builder getCustomDomainConfig() {
            return customDomainConfig != null ? customDomainConfig.toBuilder() : null;
        }

        public final void setCustomDomainConfig(CustomDomainConfigType.BuilderImpl customDomainConfig) {
            this.customDomainConfig = customDomainConfig != null ? customDomainConfig.build() : null;
        }

        @Override
        public final Builder customDomainConfig(CustomDomainConfigType customDomainConfig) {
            this.customDomainConfig = customDomainConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserPoolDomainRequest build() {
            return new CreateUserPoolDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
