/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a user pool for username case sensitivity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsernameConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<UsernameConfigurationType.Builder, UsernameConfigurationType> {
    private static final SdkField<Boolean> CASE_SENSITIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CaseSensitive").getter(getter(UsernameConfigurationType::caseSensitive))
            .setter(setter(Builder::caseSensitive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaseSensitive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_SENSITIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean caseSensitive;

    private UsernameConfigurationType(BuilderImpl builder) {
        this.caseSensitive = builder.caseSensitive;
    }

    /**
     * <p>
     * Specifies whether user name case sensitivity will be applied for all users in the user pool through Amazon
     * Cognito APIs. For most use cases, set case sensitivity to <code>False</code> (case insensitive) as a best
     * practice. When usernames and email addresses are case insensitive, users can sign in as the same user when they
     * enter a different capitalization of their user name.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <dl>
     * <dt>true</dt>
     * <dd>
     * <p>
     * Enables case sensitivity for all username input. When this option is set to <code>true</code>, users must sign in
     * using the exact capitalization of their given username, such as “UserName”. This is the default value.
     * </p>
     * </dd>
     * <dt>false</dt>
     * <dd>
     * <p>
     * Enables case insensitivity for all username input. For example, when this option is set to <code>false</code>,
     * users can sign in using <code>username</code>, <code>USERNAME</code>, or <code>UserName</code>. This option also
     * enables both <code>preferred_username</code> and <code>email</code> alias to be case insensitive, in addition to
     * the <code>username</code> attribute.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return Specifies whether user name case sensitivity will be applied for all users in the user pool through
     *         Amazon Cognito APIs. For most use cases, set case sensitivity to <code>False</code> (case insensitive) as
     *         a best practice. When usernames and email addresses are case insensitive, users can sign in as the same
     *         user when they enter a different capitalization of their user name.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <dl>
     *         <dt>true</dt>
     *         <dd>
     *         <p>
     *         Enables case sensitivity for all username input. When this option is set to <code>true</code>, users must
     *         sign in using the exact capitalization of their given username, such as “UserName”. This is the default
     *         value.
     *         </p>
     *         </dd>
     *         <dt>false</dt>
     *         <dd>
     *         <p>
     *         Enables case insensitivity for all username input. For example, when this option is set to
     *         <code>false</code>, users can sign in using <code>username</code>, <code>USERNAME</code>, or
     *         <code>UserName</code>. This option also enables both <code>preferred_username</code> and
     *         <code>email</code> alias to be case insensitive, in addition to the <code>username</code> attribute.
     *         </p>
     *         </dd>
     */
    public final Boolean caseSensitive() {
        return caseSensitive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseSensitive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsernameConfigurationType)) {
            return false;
        }
        UsernameConfigurationType other = (UsernameConfigurationType) obj;
        return Objects.equals(caseSensitive(), other.caseSensitive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsernameConfigurationType").add("CaseSensitive", caseSensitive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CaseSensitive":
            return Optional.ofNullable(clazz.cast(caseSensitive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CaseSensitive", CASE_SENSITIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UsernameConfigurationType, T> g) {
        return obj -> g.apply((UsernameConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsernameConfigurationType> {
        /**
         * <p>
         * Specifies whether user name case sensitivity will be applied for all users in the user pool through Amazon
         * Cognito APIs. For most use cases, set case sensitivity to <code>False</code> (case insensitive) as a best
         * practice. When usernames and email addresses are case insensitive, users can sign in as the same user when
         * they enter a different capitalization of their user name.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <dl>
         * <dt>true</dt>
         * <dd>
         * <p>
         * Enables case sensitivity for all username input. When this option is set to <code>true</code>, users must
         * sign in using the exact capitalization of their given username, such as “UserName”. This is the default
         * value.
         * </p>
         * </dd>
         * <dt>false</dt>
         * <dd>
         * <p>
         * Enables case insensitivity for all username input. For example, when this option is set to <code>false</code>
         * , users can sign in using <code>username</code>, <code>USERNAME</code>, or <code>UserName</code>. This option
         * also enables both <code>preferred_username</code> and <code>email</code> alias to be case insensitive, in
         * addition to the <code>username</code> attribute.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param caseSensitive
         *        Specifies whether user name case sensitivity will be applied for all users in the user pool through
         *        Amazon Cognito APIs. For most use cases, set case sensitivity to <code>False</code> (case insensitive)
         *        as a best practice. When usernames and email addresses are case insensitive, users can sign in as the
         *        same user when they enter a different capitalization of their user name.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <dl>
         *        <dt>true</dt>
         *        <dd>
         *        <p>
         *        Enables case sensitivity for all username input. When this option is set to <code>true</code>, users
         *        must sign in using the exact capitalization of their given username, such as “UserName”. This is the
         *        default value.
         *        </p>
         *        </dd>
         *        <dt>false</dt>
         *        <dd>
         *        <p>
         *        Enables case insensitivity for all username input. For example, when this option is set to
         *        <code>false</code>, users can sign in using <code>username</code>, <code>USERNAME</code>, or
         *        <code>UserName</code>. This option also enables both <code>preferred_username</code> and
         *        <code>email</code> alias to be case insensitive, in addition to the <code>username</code> attribute.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseSensitive(Boolean caseSensitive);
    }

    static final class BuilderImpl implements Builder {
        private Boolean caseSensitive;

        private BuilderImpl() {
        }

        private BuilderImpl(UsernameConfigurationType model) {
            caseSensitive(model.caseSensitive);
        }

        public final Boolean getCaseSensitive() {
            return caseSensitive;
        }

        public final void setCaseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Override
        public final Builder caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public UsernameConfigurationType build() {
            return new UsernameConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
