/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeManagedLoginBrandingResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<DescribeManagedLoginBrandingResponse.Builder, DescribeManagedLoginBrandingResponse> {
    private static final SdkField<ManagedLoginBrandingType> MANAGED_LOGIN_BRANDING_FIELD = SdkField
            .<ManagedLoginBrandingType> builder(MarshallingType.SDK_POJO).memberName("ManagedLoginBranding")
            .getter(getter(DescribeManagedLoginBrandingResponse::managedLoginBranding))
            .setter(setter(Builder::managedLoginBranding)).constructor(ManagedLoginBrandingType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedLoginBranding").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_LOGIN_BRANDING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ManagedLoginBrandingType managedLoginBranding;

    private DescribeManagedLoginBrandingResponse(BuilderImpl builder) {
        super(builder);
        this.managedLoginBranding = builder.managedLoginBranding;
    }

    /**
     * <p>
     * The details of the requested branding style.
     * </p>
     * 
     * @return The details of the requested branding style.
     */
    public final ManagedLoginBrandingType managedLoginBranding() {
        return managedLoginBranding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(managedLoginBranding());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeManagedLoginBrandingResponse)) {
            return false;
        }
        DescribeManagedLoginBrandingResponse other = (DescribeManagedLoginBrandingResponse) obj;
        return Objects.equals(managedLoginBranding(), other.managedLoginBranding());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeManagedLoginBrandingResponse").add("ManagedLoginBranding", managedLoginBranding())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedLoginBranding":
            return Optional.ofNullable(clazz.cast(managedLoginBranding()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ManagedLoginBranding", MANAGED_LOGIN_BRANDING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeManagedLoginBrandingResponse, T> g) {
        return obj -> g.apply((DescribeManagedLoginBrandingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeManagedLoginBrandingResponse> {
        /**
         * <p>
         * The details of the requested branding style.
         * </p>
         * 
         * @param managedLoginBranding
         *        The details of the requested branding style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedLoginBranding(ManagedLoginBrandingType managedLoginBranding);

        /**
         * <p>
         * The details of the requested branding style.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedLoginBrandingType.Builder}
         * avoiding the need to create one manually via {@link ManagedLoginBrandingType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedLoginBrandingType.Builder#build()} is called immediately
         * and its result is passed to {@link #managedLoginBranding(ManagedLoginBrandingType)}.
         * 
         * @param managedLoginBranding
         *        a consumer that will call methods on {@link ManagedLoginBrandingType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedLoginBranding(ManagedLoginBrandingType)
         */
        default Builder managedLoginBranding(Consumer<ManagedLoginBrandingType.Builder> managedLoginBranding) {
            return managedLoginBranding(ManagedLoginBrandingType.builder().applyMutation(managedLoginBranding).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private ManagedLoginBrandingType managedLoginBranding;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeManagedLoginBrandingResponse model) {
            super(model);
            managedLoginBranding(model.managedLoginBranding);
        }

        public final ManagedLoginBrandingType.Builder getManagedLoginBranding() {
            return managedLoginBranding != null ? managedLoginBranding.toBuilder() : null;
        }

        public final void setManagedLoginBranding(ManagedLoginBrandingType.BuilderImpl managedLoginBranding) {
            this.managedLoginBranding = managedLoginBranding != null ? managedLoginBranding.build() : null;
        }

        @Override
        public final Builder managedLoginBranding(ManagedLoginBrandingType managedLoginBranding) {
            this.managedLoginBranding = managedLoginBranding;
            return this;
        }

        @Override
        public DescribeManagedLoginBrandingResponse build() {
            return new DescribeManagedLoginBrandingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
