/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An image file from a managed login branding style in a user pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetType implements SdkPojo, Serializable, ToCopyableBuilder<AssetType.Builder, AssetType> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(AssetType::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> COLOR_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColorMode").getter(getter(AssetType::colorModeAsString)).setter(setter(Builder::colorMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorMode").build()).build();

    private static final SdkField<String> EXTENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Extension").getter(getter(AssetType::extensionAsString)).setter(setter(Builder::extension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Extension").build()).build();

    private static final SdkField<SdkBytes> BYTES_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Bytes").getter(getter(AssetType::bytes)).setter(setter(Builder::bytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bytes").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(AssetType::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD,
            COLOR_MODE_FIELD, EXTENSION_FIELD, BYTES_FIELD, RESOURCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String category;

    private final String colorMode;

    private final String extension;

    private final SdkBytes bytes;

    private final String resourceId;

    private AssetType(BuilderImpl builder) {
        this.category = builder.category;
        this.colorMode = builder.colorMode;
        this.extension = builder.extension;
        this.bytes = builder.bytes;
        this.resourceId = builder.resourceId;
    }

    /**
     * <p>
     * The category that the image corresponds to in your managed login configuration. Managed login has asset
     * categories for different types of logos, backgrounds, and icons.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link AssetCategoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category that the image corresponds to in your managed login configuration. Managed login has asset
     *         categories for different types of logos, backgrounds, and icons.
     * @see AssetCategoryType
     */
    public final AssetCategoryType category() {
        return AssetCategoryType.fromValue(category);
    }

    /**
     * <p>
     * The category that the image corresponds to in your managed login configuration. Managed login has asset
     * categories for different types of logos, backgrounds, and icons.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link AssetCategoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category that the image corresponds to in your managed login configuration. Managed login has asset
     *         categories for different types of logos, backgrounds, and icons.
     * @see AssetCategoryType
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * The display-mode target of the asset: light, dark, or browser-adaptive. For example, Amazon Cognito displays a
     * dark-mode image only when the browser or application is in dark mode, but displays a browser-adaptive file in all
     * contexts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorMode} will
     * return {@link ColorSchemeModeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #colorModeAsString}.
     * </p>
     * 
     * @return The display-mode target of the asset: light, dark, or browser-adaptive. For example, Amazon Cognito
     *         displays a dark-mode image only when the browser or application is in dark mode, but displays a
     *         browser-adaptive file in all contexts.
     * @see ColorSchemeModeType
     */
    public final ColorSchemeModeType colorMode() {
        return ColorSchemeModeType.fromValue(colorMode);
    }

    /**
     * <p>
     * The display-mode target of the asset: light, dark, or browser-adaptive. For example, Amazon Cognito displays a
     * dark-mode image only when the browser or application is in dark mode, but displays a browser-adaptive file in all
     * contexts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorMode} will
     * return {@link ColorSchemeModeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #colorModeAsString}.
     * </p>
     * 
     * @return The display-mode target of the asset: light, dark, or browser-adaptive. For example, Amazon Cognito
     *         displays a dark-mode image only when the browser or application is in dark mode, but displays a
     *         browser-adaptive file in all contexts.
     * @see ColorSchemeModeType
     */
    public final String colorModeAsString() {
        return colorMode;
    }

    /**
     * <p>
     * The file type of the image file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #extension} will
     * return {@link AssetExtensionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #extensionAsString}.
     * </p>
     * 
     * @return The file type of the image file.
     * @see AssetExtensionType
     */
    public final AssetExtensionType extension() {
        return AssetExtensionType.fromValue(extension);
    }

    /**
     * <p>
     * The file type of the image file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #extension} will
     * return {@link AssetExtensionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #extensionAsString}.
     * </p>
     * 
     * @return The file type of the image file.
     * @see AssetExtensionType
     */
    public final String extensionAsString() {
        return extension;
    }

    /**
     * <p>
     * The image file, in Base64-encoded binary.
     * </p>
     * 
     * @return The image file, in Base64-encoded binary.
     */
    public final SdkBytes bytes() {
        return bytes;
    }

    /**
     * <p>
     * The ID of the asset.
     * </p>
     * 
     * @return The ID of the asset.
     */
    public final String resourceId() {
        return resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(colorModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(extensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bytes());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetType)) {
            return false;
        }
        AssetType other = (AssetType) obj;
        return Objects.equals(categoryAsString(), other.categoryAsString())
                && Objects.equals(colorModeAsString(), other.colorModeAsString())
                && Objects.equals(extensionAsString(), other.extensionAsString()) && Objects.equals(bytes(), other.bytes())
                && Objects.equals(resourceId(), other.resourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetType").add("Category", categoryAsString()).add("ColorMode", colorModeAsString())
                .add("Extension", extensionAsString()).add("Bytes", bytes()).add("ResourceId", resourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "ColorMode":
            return Optional.ofNullable(clazz.cast(colorModeAsString()));
        case "Extension":
            return Optional.ofNullable(clazz.cast(extensionAsString()));
        case "Bytes":
            return Optional.ofNullable(clazz.cast(bytes()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Category", CATEGORY_FIELD);
        map.put("ColorMode", COLOR_MODE_FIELD);
        map.put("Extension", EXTENSION_FIELD);
        map.put("Bytes", BYTES_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetType, T> g) {
        return obj -> g.apply((AssetType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetType> {
        /**
         * <p>
         * The category that the image corresponds to in your managed login configuration. Managed login has asset
         * categories for different types of logos, backgrounds, and icons.
         * </p>
         * 
         * @param category
         *        The category that the image corresponds to in your managed login configuration. Managed login has
         *        asset categories for different types of logos, backgrounds, and icons.
         * @see AssetCategoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetCategoryType
         */
        Builder category(String category);

        /**
         * <p>
         * The category that the image corresponds to in your managed login configuration. Managed login has asset
         * categories for different types of logos, backgrounds, and icons.
         * </p>
         * 
         * @param category
         *        The category that the image corresponds to in your managed login configuration. Managed login has
         *        asset categories for different types of logos, backgrounds, and icons.
         * @see AssetCategoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetCategoryType
         */
        Builder category(AssetCategoryType category);

        /**
         * <p>
         * The display-mode target of the asset: light, dark, or browser-adaptive. For example, Amazon Cognito displays
         * a dark-mode image only when the browser or application is in dark mode, but displays a browser-adaptive file
         * in all contexts.
         * </p>
         * 
         * @param colorMode
         *        The display-mode target of the asset: light, dark, or browser-adaptive. For example, Amazon Cognito
         *        displays a dark-mode image only when the browser or application is in dark mode, but displays a
         *        browser-adaptive file in all contexts.
         * @see ColorSchemeModeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorSchemeModeType
         */
        Builder colorMode(String colorMode);

        /**
         * <p>
         * The display-mode target of the asset: light, dark, or browser-adaptive. For example, Amazon Cognito displays
         * a dark-mode image only when the browser or application is in dark mode, but displays a browser-adaptive file
         * in all contexts.
         * </p>
         * 
         * @param colorMode
         *        The display-mode target of the asset: light, dark, or browser-adaptive. For example, Amazon Cognito
         *        displays a dark-mode image only when the browser or application is in dark mode, but displays a
         *        browser-adaptive file in all contexts.
         * @see ColorSchemeModeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorSchemeModeType
         */
        Builder colorMode(ColorSchemeModeType colorMode);

        /**
         * <p>
         * The file type of the image file.
         * </p>
         * 
         * @param extension
         *        The file type of the image file.
         * @see AssetExtensionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetExtensionType
         */
        Builder extension(String extension);

        /**
         * <p>
         * The file type of the image file.
         * </p>
         * 
         * @param extension
         *        The file type of the image file.
         * @see AssetExtensionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetExtensionType
         */
        Builder extension(AssetExtensionType extension);

        /**
         * <p>
         * The image file, in Base64-encoded binary.
         * </p>
         * 
         * @param bytes
         *        The image file, in Base64-encoded binary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytes(SdkBytes bytes);

        /**
         * <p>
         * The ID of the asset.
         * </p>
         * 
         * @param resourceId
         *        The ID of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);
    }

    static final class BuilderImpl implements Builder {
        private String category;

        private String colorMode;

        private String extension;

        private SdkBytes bytes;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetType model) {
            category(model.category);
            colorMode(model.colorMode);
            extension(model.extension);
            bytes(model.bytes);
            resourceId(model.resourceId);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(AssetCategoryType category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getColorMode() {
            return colorMode;
        }

        public final void setColorMode(String colorMode) {
            this.colorMode = colorMode;
        }

        @Override
        public final Builder colorMode(String colorMode) {
            this.colorMode = colorMode;
            return this;
        }

        @Override
        public final Builder colorMode(ColorSchemeModeType colorMode) {
            this.colorMode(colorMode == null ? null : colorMode.toString());
            return this;
        }

        public final String getExtension() {
            return extension;
        }

        public final void setExtension(String extension) {
            this.extension = extension;
        }

        @Override
        public final Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        @Override
        public final Builder extension(AssetExtensionType extension) {
            this.extension(extension == null ? null : extension.toString());
            return this;
        }

        public final ByteBuffer getBytes() {
            return bytes == null ? null : bytes.asByteBuffer();
        }

        public final void setBytes(ByteBuffer bytes) {
            bytes(bytes == null ? null : SdkBytes.fromByteBuffer(bytes));
        }

        @Override
        public final Builder bytes(SdkBytes bytes) {
            this.bytes = bytes;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Override
        public AssetType build() {
            return new AssetType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
