/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sets or shows configuration for user pool email message MFA and sign-in with one-time passwords (OTPs). Includes the
 * subject and body of the email message template for sign-in and MFA messages. To activate this setting, your user pool
 * must be in the <a
 * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html"> Essentials
 * tier</a> or higher.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailMfaConfigType implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailMfaConfigType.Builder, EmailMfaConfigType> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(EmailMfaConfigType::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(EmailMfaConfigType::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, SUBJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String message;

    private final String subject;

    private EmailMfaConfigType(BuilderImpl builder) {
        this.message = builder.message;
        this.subject = builder.subject;
    }

    /**
     * <p>
     * The template for the email messages that your user pool sends to users with codes for MFA and sign-in with email
     * OTPs. The message must contain the <code>{####}</code> placeholder. In the message, Amazon Cognito replaces this
     * placeholder with the code. If you don't provide this parameter, Amazon Cognito sends messages in the default
     * format.
     * </p>
     * 
     * @return The template for the email messages that your user pool sends to users with codes for MFA and sign-in
     *         with email OTPs. The message must contain the <code>{####}</code> placeholder. In the message, Amazon
     *         Cognito replaces this placeholder with the code. If you don't provide this parameter, Amazon Cognito
     *         sends messages in the default format.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The subject of the email messages that your user pool sends to users with codes for MFA and email OTP sign-in.
     * </p>
     * 
     * @return The subject of the email messages that your user pool sends to users with codes for MFA and email OTP
     *         sign-in.
     */
    public final String subject() {
        return subject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailMfaConfigType)) {
            return false;
        }
        EmailMfaConfigType other = (EmailMfaConfigType) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(subject(), other.subject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailMfaConfigType").add("Message", message()).add("Subject", subject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Message", MESSAGE_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailMfaConfigType, T> g) {
        return obj -> g.apply((EmailMfaConfigType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailMfaConfigType> {
        /**
         * <p>
         * The template for the email messages that your user pool sends to users with codes for MFA and sign-in with
         * email OTPs. The message must contain the <code>{####}</code> placeholder. In the message, Amazon Cognito
         * replaces this placeholder with the code. If you don't provide this parameter, Amazon Cognito sends messages
         * in the default format.
         * </p>
         * 
         * @param message
         *        The template for the email messages that your user pool sends to users with codes for MFA and sign-in
         *        with email OTPs. The message must contain the <code>{####}</code> placeholder. In the message, Amazon
         *        Cognito replaces this placeholder with the code. If you don't provide this parameter, Amazon Cognito
         *        sends messages in the default format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The subject of the email messages that your user pool sends to users with codes for MFA and email OTP
         * sign-in.
         * </p>
         * 
         * @param subject
         *        The subject of the email messages that your user pool sends to users with codes for MFA and email OTP
         *        sign-in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String subject;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailMfaConfigType model) {
            message(model.message);
            subject(model.subject);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        @Override
        public EmailMfaConfigType build() {
            return new EmailMfaConfigType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
