/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetUserMfaPreferenceRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<SetUserMfaPreferenceRequest.Builder, SetUserMfaPreferenceRequest> {
    private static final SdkField<SMSMfaSettingsType> SMS_MFA_SETTINGS_FIELD = SdkField
            .<SMSMfaSettingsType> builder(MarshallingType.SDK_POJO).memberName("SMSMfaSettings")
            .getter(getter(SetUserMfaPreferenceRequest::smsMfaSettings)).setter(setter(Builder::smsMfaSettings))
            .constructor(SMSMfaSettingsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSMfaSettings").build()).build();

    private static final SdkField<SoftwareTokenMfaSettingsType> SOFTWARE_TOKEN_MFA_SETTINGS_FIELD = SdkField
            .<SoftwareTokenMfaSettingsType> builder(MarshallingType.SDK_POJO).memberName("SoftwareTokenMfaSettings")
            .getter(getter(SetUserMfaPreferenceRequest::softwareTokenMfaSettings))
            .setter(setter(Builder::softwareTokenMfaSettings)).constructor(SoftwareTokenMfaSettingsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareTokenMfaSettings").build())
            .build();

    private static final SdkField<EmailMfaSettingsType> EMAIL_MFA_SETTINGS_FIELD = SdkField
            .<EmailMfaSettingsType> builder(MarshallingType.SDK_POJO).memberName("EmailMfaSettings")
            .getter(getter(SetUserMfaPreferenceRequest::emailMfaSettings)).setter(setter(Builder::emailMfaSettings))
            .constructor(EmailMfaSettingsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMfaSettings").build()).build();

    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessToken").getter(getter(SetUserMfaPreferenceRequest::accessToken))
            .setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_MFA_SETTINGS_FIELD,
            SOFTWARE_TOKEN_MFA_SETTINGS_FIELD, EMAIL_MFA_SETTINGS_FIELD, ACCESS_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SMSMfaSettingsType smsMfaSettings;

    private final SoftwareTokenMfaSettingsType softwareTokenMfaSettings;

    private final EmailMfaSettingsType emailMfaSettings;

    private final String accessToken;

    private SetUserMfaPreferenceRequest(BuilderImpl builder) {
        super(builder);
        this.smsMfaSettings = builder.smsMfaSettings;
        this.softwareTokenMfaSettings = builder.softwareTokenMfaSettings;
        this.emailMfaSettings = builder.emailMfaSettings;
        this.accessToken = builder.accessToken;
    }

    /**
     * <p>
     * User preferences for SMS message MFA. Activates or deactivates SMS MFA and sets it as the preferred MFA method
     * when multiple methods are available.
     * </p>
     * 
     * @return User preferences for SMS message MFA. Activates or deactivates SMS MFA and sets it as the preferred MFA
     *         method when multiple methods are available.
     */
    public final SMSMfaSettingsType smsMfaSettings() {
        return smsMfaSettings;
    }

    /**
     * <p>
     * User preferences for time-based one-time password (TOTP) MFA. Activates or deactivates TOTP MFA and sets it as
     * the preferred MFA method when multiple methods are available. Users must register a TOTP authenticator before
     * they set this as their preferred MFA method.
     * </p>
     * 
     * @return User preferences for time-based one-time password (TOTP) MFA. Activates or deactivates TOTP MFA and sets
     *         it as the preferred MFA method when multiple methods are available. Users must register a TOTP
     *         authenticator before they set this as their preferred MFA method.
     */
    public final SoftwareTokenMfaSettingsType softwareTokenMfaSettings() {
        return softwareTokenMfaSettings;
    }

    /**
     * <p>
     * User preferences for email message MFA. Activates or deactivates email MFA and sets it as the preferred MFA
     * method when multiple methods are available. To activate this setting, your user pool must be in the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
     * Essentials tier</a> or higher.
     * </p>
     * 
     * @return User preferences for email message MFA. Activates or deactivates email MFA and sets it as the preferred
     *         MFA method when multiple methods are available. To activate this setting, your user pool must be in the
     *         <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
     *         Essentials tier</a> or higher.
     */
    public final EmailMfaSettingsType emailMfaSettings() {
        return emailMfaSettings;
    }

    /**
     * <p>
     * A valid access token that Amazon Cognito issued to the currently signed-in user. Must include a scope claim for
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * 
     * @return A valid access token that Amazon Cognito issued to the currently signed-in user. Must include a scope
     *         claim for <code>aws.cognito.signin.user.admin</code>.
     */
    public final String accessToken() {
        return accessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(smsMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(softwareTokenMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(emailMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetUserMfaPreferenceRequest)) {
            return false;
        }
        SetUserMfaPreferenceRequest other = (SetUserMfaPreferenceRequest) obj;
        return Objects.equals(smsMfaSettings(), other.smsMfaSettings())
                && Objects.equals(softwareTokenMfaSettings(), other.softwareTokenMfaSettings())
                && Objects.equals(emailMfaSettings(), other.emailMfaSettings())
                && Objects.equals(accessToken(), other.accessToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetUserMfaPreferenceRequest").add("SMSMfaSettings", smsMfaSettings())
                .add("SoftwareTokenMfaSettings", softwareTokenMfaSettings()).add("EmailMfaSettings", emailMfaSettings())
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SMSMfaSettings":
            return Optional.ofNullable(clazz.cast(smsMfaSettings()));
        case "SoftwareTokenMfaSettings":
            return Optional.ofNullable(clazz.cast(softwareTokenMfaSettings()));
        case "EmailMfaSettings":
            return Optional.ofNullable(clazz.cast(emailMfaSettings()));
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SMSMfaSettings", SMS_MFA_SETTINGS_FIELD);
        map.put("SoftwareTokenMfaSettings", SOFTWARE_TOKEN_MFA_SETTINGS_FIELD);
        map.put("EmailMfaSettings", EMAIL_MFA_SETTINGS_FIELD);
        map.put("AccessToken", ACCESS_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetUserMfaPreferenceRequest, T> g) {
        return obj -> g.apply((SetUserMfaPreferenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetUserMfaPreferenceRequest> {
        /**
         * <p>
         * User preferences for SMS message MFA. Activates or deactivates SMS MFA and sets it as the preferred MFA
         * method when multiple methods are available.
         * </p>
         * 
         * @param smsMfaSettings
         *        User preferences for SMS message MFA. Activates or deactivates SMS MFA and sets it as the preferred
         *        MFA method when multiple methods are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsMfaSettings(SMSMfaSettingsType smsMfaSettings);

        /**
         * <p>
         * User preferences for SMS message MFA. Activates or deactivates SMS MFA and sets it as the preferred MFA
         * method when multiple methods are available.
         * </p>
         * This is a convenience method that creates an instance of the {@link SMSMfaSettingsType.Builder} avoiding the
         * need to create one manually via {@link SMSMfaSettingsType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SMSMfaSettingsType.Builder#build()} is called immediately and its
         * result is passed to {@link #smsMfaSettings(SMSMfaSettingsType)}.
         * 
         * @param smsMfaSettings
         *        a consumer that will call methods on {@link SMSMfaSettingsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsMfaSettings(SMSMfaSettingsType)
         */
        default Builder smsMfaSettings(Consumer<SMSMfaSettingsType.Builder> smsMfaSettings) {
            return smsMfaSettings(SMSMfaSettingsType.builder().applyMutation(smsMfaSettings).build());
        }

        /**
         * <p>
         * User preferences for time-based one-time password (TOTP) MFA. Activates or deactivates TOTP MFA and sets it
         * as the preferred MFA method when multiple methods are available. Users must register a TOTP authenticator
         * before they set this as their preferred MFA method.
         * </p>
         * 
         * @param softwareTokenMfaSettings
         *        User preferences for time-based one-time password (TOTP) MFA. Activates or deactivates TOTP MFA and
         *        sets it as the preferred MFA method when multiple methods are available. Users must register a TOTP
         *        authenticator before they set this as their preferred MFA method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareTokenMfaSettings(SoftwareTokenMfaSettingsType softwareTokenMfaSettings);

        /**
         * <p>
         * User preferences for time-based one-time password (TOTP) MFA. Activates or deactivates TOTP MFA and sets it
         * as the preferred MFA method when multiple methods are available. Users must register a TOTP authenticator
         * before they set this as their preferred MFA method.
         * </p>
         * This is a convenience method that creates an instance of the {@link SoftwareTokenMfaSettingsType.Builder}
         * avoiding the need to create one manually via {@link SoftwareTokenMfaSettingsType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SoftwareTokenMfaSettingsType.Builder#build()} is called
         * immediately and its result is passed to {@link #softwareTokenMfaSettings(SoftwareTokenMfaSettingsType)}.
         * 
         * @param softwareTokenMfaSettings
         *        a consumer that will call methods on {@link SoftwareTokenMfaSettingsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #softwareTokenMfaSettings(SoftwareTokenMfaSettingsType)
         */
        default Builder softwareTokenMfaSettings(Consumer<SoftwareTokenMfaSettingsType.Builder> softwareTokenMfaSettings) {
            return softwareTokenMfaSettings(SoftwareTokenMfaSettingsType.builder().applyMutation(softwareTokenMfaSettings)
                    .build());
        }

        /**
         * <p>
         * User preferences for email message MFA. Activates or deactivates email MFA and sets it as the preferred MFA
         * method when multiple methods are available. To activate this setting, your user pool must be in the <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
         * Essentials tier</a> or higher.
         * </p>
         * 
         * @param emailMfaSettings
         *        User preferences for email message MFA. Activates or deactivates email MFA and sets it as the
         *        preferred MFA method when multiple methods are available. To activate this setting, your user pool
         *        must be in the <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
         *        Essentials tier</a> or higher.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMfaSettings(EmailMfaSettingsType emailMfaSettings);

        /**
         * <p>
         * User preferences for email message MFA. Activates or deactivates email MFA and sets it as the preferred MFA
         * method when multiple methods are available. To activate this setting, your user pool must be in the <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
         * Essentials tier</a> or higher.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailMfaSettingsType.Builder} avoiding
         * the need to create one manually via {@link EmailMfaSettingsType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailMfaSettingsType.Builder#build()} is called immediately and
         * its result is passed to {@link #emailMfaSettings(EmailMfaSettingsType)}.
         * 
         * @param emailMfaSettings
         *        a consumer that will call methods on {@link EmailMfaSettingsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailMfaSettings(EmailMfaSettingsType)
         */
        default Builder emailMfaSettings(Consumer<EmailMfaSettingsType.Builder> emailMfaSettings) {
            return emailMfaSettings(EmailMfaSettingsType.builder().applyMutation(emailMfaSettings).build());
        }

        /**
         * <p>
         * A valid access token that Amazon Cognito issued to the currently signed-in user. Must include a scope claim
         * for <code>aws.cognito.signin.user.admin</code>.
         * </p>
         * 
         * @param accessToken
         *        A valid access token that Amazon Cognito issued to the currently signed-in user. Must include a scope
         *        claim for <code>aws.cognito.signin.user.admin</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private SMSMfaSettingsType smsMfaSettings;

        private SoftwareTokenMfaSettingsType softwareTokenMfaSettings;

        private EmailMfaSettingsType emailMfaSettings;

        private String accessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SetUserMfaPreferenceRequest model) {
            super(model);
            smsMfaSettings(model.smsMfaSettings);
            softwareTokenMfaSettings(model.softwareTokenMfaSettings);
            emailMfaSettings(model.emailMfaSettings);
            accessToken(model.accessToken);
        }

        public final SMSMfaSettingsType.Builder getSmsMfaSettings() {
            return smsMfaSettings != null ? smsMfaSettings.toBuilder() : null;
        }

        public final void setSmsMfaSettings(SMSMfaSettingsType.BuilderImpl smsMfaSettings) {
            this.smsMfaSettings = smsMfaSettings != null ? smsMfaSettings.build() : null;
        }

        @Override
        public final Builder smsMfaSettings(SMSMfaSettingsType smsMfaSettings) {
            this.smsMfaSettings = smsMfaSettings;
            return this;
        }

        public final SoftwareTokenMfaSettingsType.Builder getSoftwareTokenMfaSettings() {
            return softwareTokenMfaSettings != null ? softwareTokenMfaSettings.toBuilder() : null;
        }

        public final void setSoftwareTokenMfaSettings(SoftwareTokenMfaSettingsType.BuilderImpl softwareTokenMfaSettings) {
            this.softwareTokenMfaSettings = softwareTokenMfaSettings != null ? softwareTokenMfaSettings.build() : null;
        }

        @Override
        public final Builder softwareTokenMfaSettings(SoftwareTokenMfaSettingsType softwareTokenMfaSettings) {
            this.softwareTokenMfaSettings = softwareTokenMfaSettings;
            return this;
        }

        public final EmailMfaSettingsType.Builder getEmailMfaSettings() {
            return emailMfaSettings != null ? emailMfaSettings.toBuilder() : null;
        }

        public final void setEmailMfaSettings(EmailMfaSettingsType.BuilderImpl emailMfaSettings) {
            this.emailMfaSettings = emailMfaSettings != null ? emailMfaSettings.build() : null;
        }

        @Override
        public final Builder emailMfaSettings(EmailMfaSettingsType emailMfaSettings) {
            this.emailMfaSettings = emailMfaSettings;
            return this;
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetUserMfaPreferenceRequest build() {
            return new SetUserMfaPreferenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
