/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The policy for allowed types of authentication in a user pool. To activate this setting, your user pool must be in
 * the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
 * Essentials tier</a> or higher.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignInPolicyType implements SdkPojo, Serializable,
        ToCopyableBuilder<SignInPolicyType.Builder, SignInPolicyType> {
    private static final SdkField<List<String>> ALLOWED_FIRST_AUTH_FACTORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedFirstAuthFactors")
            .getter(getter(SignInPolicyType::allowedFirstAuthFactorsAsStrings))
            .setter(setter(Builder::allowedFirstAuthFactorsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedFirstAuthFactors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ALLOWED_FIRST_AUTH_FACTORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> allowedFirstAuthFactors;

    private SignInPolicyType(BuilderImpl builder) {
        this.allowedFirstAuthFactors = builder.allowedFirstAuthFactors;
    }

    /**
     * <p>
     * The sign-in methods that a user pool supports as the first factor. You can permit users to start authentication
     * with a standard username and password, or with other one-time password and hardware factors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedFirstAuthFactors} method.
     * </p>
     * 
     * @return The sign-in methods that a user pool supports as the first factor. You can permit users to start
     *         authentication with a standard username and password, or with other one-time password and hardware
     *         factors.
     */
    public final List<AuthFactorType> allowedFirstAuthFactors() {
        return AllowedFirstAuthFactorsListTypeCopier.copyStringToEnum(allowedFirstAuthFactors);
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedFirstAuthFactors property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedFirstAuthFactors() {
        return allowedFirstAuthFactors != null && !(allowedFirstAuthFactors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sign-in methods that a user pool supports as the first factor. You can permit users to start authentication
     * with a standard username and password, or with other one-time password and hardware factors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedFirstAuthFactors} method.
     * </p>
     * 
     * @return The sign-in methods that a user pool supports as the first factor. You can permit users to start
     *         authentication with a standard username and password, or with other one-time password and hardware
     *         factors.
     */
    public final List<String> allowedFirstAuthFactorsAsStrings() {
        return allowedFirstAuthFactors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedFirstAuthFactors() ? allowedFirstAuthFactorsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignInPolicyType)) {
            return false;
        }
        SignInPolicyType other = (SignInPolicyType) obj;
        return hasAllowedFirstAuthFactors() == other.hasAllowedFirstAuthFactors()
                && Objects.equals(allowedFirstAuthFactorsAsStrings(), other.allowedFirstAuthFactorsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignInPolicyType")
                .add("AllowedFirstAuthFactors", hasAllowedFirstAuthFactors() ? allowedFirstAuthFactorsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowedFirstAuthFactors":
            return Optional.ofNullable(clazz.cast(allowedFirstAuthFactorsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllowedFirstAuthFactors", ALLOWED_FIRST_AUTH_FACTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignInPolicyType, T> g) {
        return obj -> g.apply((SignInPolicyType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SignInPolicyType> {
        /**
         * <p>
         * The sign-in methods that a user pool supports as the first factor. You can permit users to start
         * authentication with a standard username and password, or with other one-time password and hardware factors.
         * </p>
         * 
         * @param allowedFirstAuthFactors
         *        The sign-in methods that a user pool supports as the first factor. You can permit users to start
         *        authentication with a standard username and password, or with other one-time password and hardware
         *        factors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedFirstAuthFactorsWithStrings(Collection<String> allowedFirstAuthFactors);

        /**
         * <p>
         * The sign-in methods that a user pool supports as the first factor. You can permit users to start
         * authentication with a standard username and password, or with other one-time password and hardware factors.
         * </p>
         * 
         * @param allowedFirstAuthFactors
         *        The sign-in methods that a user pool supports as the first factor. You can permit users to start
         *        authentication with a standard username and password, or with other one-time password and hardware
         *        factors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedFirstAuthFactorsWithStrings(String... allowedFirstAuthFactors);

        /**
         * <p>
         * The sign-in methods that a user pool supports as the first factor. You can permit users to start
         * authentication with a standard username and password, or with other one-time password and hardware factors.
         * </p>
         * 
         * @param allowedFirstAuthFactors
         *        The sign-in methods that a user pool supports as the first factor. You can permit users to start
         *        authentication with a standard username and password, or with other one-time password and hardware
         *        factors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedFirstAuthFactors(Collection<AuthFactorType> allowedFirstAuthFactors);

        /**
         * <p>
         * The sign-in methods that a user pool supports as the first factor. You can permit users to start
         * authentication with a standard username and password, or with other one-time password and hardware factors.
         * </p>
         * 
         * @param allowedFirstAuthFactors
         *        The sign-in methods that a user pool supports as the first factor. You can permit users to start
         *        authentication with a standard username and password, or with other one-time password and hardware
         *        factors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedFirstAuthFactors(AuthFactorType... allowedFirstAuthFactors);
    }

    static final class BuilderImpl implements Builder {
        private List<String> allowedFirstAuthFactors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SignInPolicyType model) {
            allowedFirstAuthFactorsWithStrings(model.allowedFirstAuthFactors);
        }

        public final Collection<String> getAllowedFirstAuthFactors() {
            if (allowedFirstAuthFactors instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedFirstAuthFactors;
        }

        public final void setAllowedFirstAuthFactors(Collection<String> allowedFirstAuthFactors) {
            this.allowedFirstAuthFactors = AllowedFirstAuthFactorsListTypeCopier.copy(allowedFirstAuthFactors);
        }

        @Override
        public final Builder allowedFirstAuthFactorsWithStrings(Collection<String> allowedFirstAuthFactors) {
            this.allowedFirstAuthFactors = AllowedFirstAuthFactorsListTypeCopier.copy(allowedFirstAuthFactors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedFirstAuthFactorsWithStrings(String... allowedFirstAuthFactors) {
            allowedFirstAuthFactorsWithStrings(Arrays.asList(allowedFirstAuthFactors));
            return this;
        }

        @Override
        public final Builder allowedFirstAuthFactors(Collection<AuthFactorType> allowedFirstAuthFactors) {
            this.allowedFirstAuthFactors = AllowedFirstAuthFactorsListTypeCopier.copyEnumToString(allowedFirstAuthFactors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedFirstAuthFactors(AuthFactorType... allowedFirstAuthFactors) {
            allowedFirstAuthFactors(Arrays.asList(allowedFirstAuthFactors));
            return this;
        }

        @Override
        public SignInPolicyType build() {
            return new SignInPolicyType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
