/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGroupRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<UpdateGroupRequest.Builder, UpdateGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(UpdateGroupRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(UpdateGroupRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateGroupRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateGroupRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Integer> PRECEDENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Precedence").getter(getter(UpdateGroupRequest::precedence)).setter(setter(Builder::precedence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precedence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            USER_POOL_ID_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, PRECEDENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String groupName;

    private final String userPoolId;

    private final String description;

    private final String roleArn;

    private final Integer precedence;

    private UpdateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.userPoolId = builder.userPoolId;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.precedence = builder.precedence;
    }

    /**
     * <p>
     * The name of the group that you want to update.
     * </p>
     * 
     * @return The name of the group that you want to update.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The ID of the user pool that contains the group you want to update.
     * </p>
     * 
     * @return The ID of the user pool that contains the group you want to update.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * A new description of the existing group.
     * </p>
     * 
     * @return A new description of the existing group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that you want to associate with the group. The role assignment
     * contributes to the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in group members'
     * tokens.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that you want to associate with the group. The role
     *         assignment contributes to the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims
     *         in group members' tokens.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A non-negative integer value that specifies the precedence of this group relative to the other groups that a user
     * can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code>
     * values take precedence over groups with higher or null <code>Precedence</code> values. If a user belongs to two
     * or more groups, it is the group with the lowest precedence value whose role ARN is given in the user's tokens for
     * the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims.
     * </p>
     * <p>
     * Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over
     * the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the
     * <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different
     * role ARNs, the <code>cognito:preferred_role</code> claim isn't set in users' tokens.
     * </p>
     * <p>
     * The default <code>Precedence</code> value is null. The maximum <code>Precedence</code> value is
     * <code>2^31-1</code>.
     * </p>
     * 
     * @return A non-negative integer value that specifies the precedence of this group relative to the other groups
     *         that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower
     *         <code>Precedence</code> values take precedence over groups with higher or null <code>Precedence</code>
     *         values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose
     *         role ARN is given in the user's tokens for the <code>cognito:roles</code> and
     *         <code>cognito:preferred_role</code> claims.</p>
     *         <p>
     *         Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes
     *         precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN,
     *         that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If
     *         the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim isn't set in
     *         users' tokens.
     *         </p>
     *         <p>
     *         The default <code>Precedence</code> value is null. The maximum <code>Precedence</code> value is
     *         <code>2^31-1</code>.
     */
    public final Integer precedence() {
        return precedence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(precedence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGroupRequest)) {
            return false;
        }
        UpdateGroupRequest other = (UpdateGroupRequest) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(userPoolId(), other.userPoolId())
                && Objects.equals(description(), other.description()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(precedence(), other.precedence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGroupRequest").add("GroupName", groupName()).add("UserPoolId", userPoolId())
                .add("Description", description()).add("RoleArn", roleArn()).add("Precedence", precedence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Precedence":
            return Optional.ofNullable(clazz.cast(precedence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Precedence", PRECEDENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGroupRequest, T> g) {
        return obj -> g.apply((UpdateGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateGroupRequest> {
        /**
         * <p>
         * The name of the group that you want to update.
         * </p>
         * 
         * @param groupName
         *        The name of the group that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The ID of the user pool that contains the group you want to update.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the user pool that contains the group you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * A new description of the existing group.
         * </p>
         * 
         * @param description
         *        A new description of the existing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that you want to associate with the group. The role assignment
         * contributes to the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in group
         * members' tokens.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that you want to associate with the group. The role
         *        assignment contributes to the <code>cognito:roles</code> and <code>cognito:preferred_role</code>
         *        claims in group members' tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A non-negative integer value that specifies the precedence of this group relative to the other groups that a
         * user can belong to in the user pool. Zero is the highest precedence value. Groups with lower
         * <code>Precedence</code> values take precedence over groups with higher or null <code>Precedence</code>
         * values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role
         * ARN is given in the user's tokens for the <code>cognito:roles</code> and <code>cognito:preferred_role</code>
         * claims.
         * </p>
         * <p>
         * Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence
         * over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used
         * in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have
         * different role ARNs, the <code>cognito:preferred_role</code> claim isn't set in users' tokens.
         * </p>
         * <p>
         * The default <code>Precedence</code> value is null. The maximum <code>Precedence</code> value is
         * <code>2^31-1</code>.
         * </p>
         * 
         * @param precedence
         *        A non-negative integer value that specifies the precedence of this group relative to the other groups
         *        that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower
         *        <code>Precedence</code> values take precedence over groups with higher or null <code>Precedence</code>
         *        values. If a user belongs to two or more groups, it is the group with the lowest precedence value
         *        whose role ARN is given in the user's tokens for the <code>cognito:roles</code> and
         *        <code>cognito:preferred_role</code> claims.</p>
         *        <p>
         *        Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes
         *        precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN,
         *        that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group.
         *        If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim isn't set in
         *        users' tokens.
         *        </p>
         *        <p>
         *        The default <code>Precedence</code> value is null. The maximum <code>Precedence</code> value is
         *        <code>2^31-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precedence(Integer precedence);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String groupName;

        private String userPoolId;

        private String description;

        private String roleArn;

        private Integer precedence;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGroupRequest model) {
            super(model);
            groupName(model.groupName);
            userPoolId(model.userPoolId);
            description(model.description);
            roleArn(model.roleArn);
            precedence(model.precedence);
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Integer getPrecedence() {
            return precedence;
        }

        public final void setPrecedence(Integer precedence) {
            this.precedence = precedence;
        }

        @Override
        public final Builder precedence(Integer precedence) {
            this.precedence = precedence;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGroupRequest build() {
            return new UpdateGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
