/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ColorSchemeModeType {
    LIGHT("LIGHT"),
    DARK("DARK"),
    DYNAMIC("DYNAMIC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ColorSchemeModeType> VALUE_MAP;
    private final String value;

    private ColorSchemeModeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ColorSchemeModeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ColorSchemeModeType> knownValues() {
        EnumSet<ColorSchemeModeType> knownValues = EnumSet.allOf(ColorSchemeModeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ColorSchemeModeType.class, ColorSchemeModeType::toString);
    }
}

