/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIdentityProviderResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, CreateIdentityProviderResponse> {
    private static final SdkField<IdentityProviderType> IDENTITY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityProvider").getter(CreateIdentityProviderResponse.getter(CreateIdentityProviderResponse::identityProvider)).setter(CreateIdentityProviderResponse.setter(Builder::identityProvider)).constructor(IdentityProviderType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIdentityProviderResponse.memberNameToFieldInitializer();
    private final IdentityProviderType identityProvider;

    private CreateIdentityProviderResponse(BuilderImpl builder) {
        super(builder);
        this.identityProvider = builder.identityProvider;
    }

    public final IdentityProviderType identityProvider() {
        return this.identityProvider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProvider());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdentityProviderResponse)) {
            return false;
        }
        CreateIdentityProviderResponse other = (CreateIdentityProviderResponse)((Object)obj);
        return Objects.equals(this.identityProvider(), other.identityProvider());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIdentityProviderResponse").add("IdentityProvider", (Object)this.identityProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityProvider": {
                return Optional.ofNullable(clazz.cast(this.identityProvider()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<IdentityProviderType>> map = new HashMap<String, SdkField<IdentityProviderType>>();
        map.put("IdentityProvider", IDENTITY_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIdentityProviderResponse, T> g) {
        return obj -> g.apply((CreateIdentityProviderResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private IdentityProviderType identityProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIdentityProviderResponse model) {
            super(model);
            this.identityProvider(model.identityProvider);
        }

        public final IdentityProviderType.Builder getIdentityProvider() {
            return this.identityProvider != null ? this.identityProvider.toBuilder() : null;
        }

        public final void setIdentityProvider(IdentityProviderType.BuilderImpl identityProvider) {
            this.identityProvider = identityProvider != null ? identityProvider.build() : null;
        }

        @Override
        public final Builder identityProvider(IdentityProviderType identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        @Override
        public CreateIdentityProviderResponse build() {
            return new CreateIdentityProviderResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIdentityProviderResponse> {
        public Builder identityProvider(IdentityProviderType var1);

        default public Builder identityProvider(Consumer<IdentityProviderType.Builder> identityProvider) {
            return this.identityProvider((IdentityProviderType)((IdentityProviderType.Builder)IdentityProviderType.builder().applyMutation(identityProvider)).build());
        }
    }
}

