/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of your app client for refresh token rotation. When enabled, your app client issues new ID, access,
 * and refresh tokens when users renew their sessions with refresh tokens. When disabled, token refresh issues only ID
 * and access tokens.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshTokenRotationType implements SdkPojo, Serializable,
        ToCopyableBuilder<RefreshTokenRotationType.Builder, RefreshTokenRotationType> {
    private static final SdkField<String> FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Feature")
            .getter(getter(RefreshTokenRotationType::featureAsString)).setter(setter(Builder::feature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feature").build()).build();

    private static final SdkField<Integer> RETRY_GRACE_PERIOD_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetryGracePeriodSeconds").getter(getter(RefreshTokenRotationType::retryGracePeriodSeconds))
            .setter(setter(Builder::retryGracePeriodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryGracePeriodSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_FIELD,
            RETRY_GRACE_PERIOD_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String feature;

    private final Integer retryGracePeriodSeconds;

    private RefreshTokenRotationType(BuilderImpl builder) {
        this.feature = builder.feature;
        this.retryGracePeriodSeconds = builder.retryGracePeriodSeconds;
    }

    /**
     * <p>
     * The state of refresh token rotation for the current app client.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link FeatureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureAsString}.
     * </p>
     * 
     * @return The state of refresh token rotation for the current app client.
     * @see FeatureType
     */
    public final FeatureType feature() {
        return FeatureType.fromValue(feature);
    }

    /**
     * <p>
     * The state of refresh token rotation for the current app client.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link FeatureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureAsString}.
     * </p>
     * 
     * @return The state of refresh token rotation for the current app client.
     * @see FeatureType
     */
    public final String featureAsString() {
        return feature;
    }

    /**
     * <p>
     * When you request a token refresh with <code>GetTokensFromRefreshToken</code>, the original refresh token that
     * you're rotating out can remain valid for a period of time of up to 60 seconds. This allows for client-side
     * retries. When <code>RetryGracePeriodSeconds</code> is <code>0</code>, the grace period is disabled and a
     * successful request immediately invalidates the submitted refresh token.
     * </p>
     * 
     * @return When you request a token refresh with <code>GetTokensFromRefreshToken</code>, the original refresh token
     *         that you're rotating out can remain valid for a period of time of up to 60 seconds. This allows for
     *         client-side retries. When <code>RetryGracePeriodSeconds</code> is <code>0</code>, the grace period is
     *         disabled and a successful request immediately invalidates the submitted refresh token.
     */
    public final Integer retryGracePeriodSeconds() {
        return retryGracePeriodSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retryGracePeriodSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshTokenRotationType)) {
            return false;
        }
        RefreshTokenRotationType other = (RefreshTokenRotationType) obj;
        return Objects.equals(featureAsString(), other.featureAsString())
                && Objects.equals(retryGracePeriodSeconds(), other.retryGracePeriodSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefreshTokenRotationType").add("Feature", featureAsString())
                .add("RetryGracePeriodSeconds", retryGracePeriodSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Feature":
            return Optional.ofNullable(clazz.cast(featureAsString()));
        case "RetryGracePeriodSeconds":
            return Optional.ofNullable(clazz.cast(retryGracePeriodSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Feature", FEATURE_FIELD);
        map.put("RetryGracePeriodSeconds", RETRY_GRACE_PERIOD_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RefreshTokenRotationType, T> g) {
        return obj -> g.apply((RefreshTokenRotationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RefreshTokenRotationType> {
        /**
         * <p>
         * The state of refresh token rotation for the current app client.
         * </p>
         * 
         * @param feature
         *        The state of refresh token rotation for the current app client.
         * @see FeatureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureType
         */
        Builder feature(String feature);

        /**
         * <p>
         * The state of refresh token rotation for the current app client.
         * </p>
         * 
         * @param feature
         *        The state of refresh token rotation for the current app client.
         * @see FeatureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureType
         */
        Builder feature(FeatureType feature);

        /**
         * <p>
         * When you request a token refresh with <code>GetTokensFromRefreshToken</code>, the original refresh token that
         * you're rotating out can remain valid for a period of time of up to 60 seconds. This allows for client-side
         * retries. When <code>RetryGracePeriodSeconds</code> is <code>0</code>, the grace period is disabled and a
         * successful request immediately invalidates the submitted refresh token.
         * </p>
         * 
         * @param retryGracePeriodSeconds
         *        When you request a token refresh with <code>GetTokensFromRefreshToken</code>, the original refresh
         *        token that you're rotating out can remain valid for a period of time of up to 60 seconds. This allows
         *        for client-side retries. When <code>RetryGracePeriodSeconds</code> is <code>0</code>, the grace period
         *        is disabled and a successful request immediately invalidates the submitted refresh token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryGracePeriodSeconds(Integer retryGracePeriodSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String feature;

        private Integer retryGracePeriodSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshTokenRotationType model) {
            feature(model.feature);
            retryGracePeriodSeconds(model.retryGracePeriodSeconds);
        }

        public final String getFeature() {
            return feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(FeatureType feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        public final Integer getRetryGracePeriodSeconds() {
            return retryGracePeriodSeconds;
        }

        public final void setRetryGracePeriodSeconds(Integer retryGracePeriodSeconds) {
            this.retryGracePeriodSeconds = retryGracePeriodSeconds;
        }

        @Override
        public final Builder retryGracePeriodSeconds(Integer retryGracePeriodSeconds) {
            this.retryGracePeriodSeconds = retryGracePeriodSeconds;
            return this;
        }

        @Override
        public RefreshTokenRotationType build() {
            return new RefreshTokenRotationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
