/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTokensFromRefreshTokenResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, GetTokensFromRefreshTokenResponse> {
    private static final SdkField<AuthenticationResultType> AUTHENTICATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationResult").getter(GetTokensFromRefreshTokenResponse.getter(GetTokensFromRefreshTokenResponse::authenticationResult)).setter(GetTokensFromRefreshTokenResponse.setter(Builder::authenticationResult)).constructor(AuthenticationResultType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTokensFromRefreshTokenResponse.memberNameToFieldInitializer();
    private final AuthenticationResultType authenticationResult;

    private GetTokensFromRefreshTokenResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationResult = builder.authenticationResult;
    }

    public final AuthenticationResultType authenticationResult() {
        return this.authenticationResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTokensFromRefreshTokenResponse)) {
            return false;
        }
        GetTokensFromRefreshTokenResponse other = (GetTokensFromRefreshTokenResponse)((Object)obj);
        return Objects.equals(this.authenticationResult(), other.authenticationResult());
    }

    public final String toString() {
        return ToString.builder((String)"GetTokensFromRefreshTokenResponse").add("AuthenticationResult", (Object)this.authenticationResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationResult": {
                return Optional.ofNullable(clazz.cast(this.authenticationResult()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<AuthenticationResultType>> map = new HashMap<String, SdkField<AuthenticationResultType>>();
        map.put("AuthenticationResult", AUTHENTICATION_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTokensFromRefreshTokenResponse, T> g) {
        return obj -> g.apply((GetTokensFromRefreshTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private AuthenticationResultType authenticationResult;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTokensFromRefreshTokenResponse model) {
            super(model);
            this.authenticationResult(model.authenticationResult);
        }

        public final AuthenticationResultType.Builder getAuthenticationResult() {
            return this.authenticationResult != null ? this.authenticationResult.toBuilder() : null;
        }

        public final void setAuthenticationResult(AuthenticationResultType.BuilderImpl authenticationResult) {
            this.authenticationResult = authenticationResult != null ? authenticationResult.build() : null;
        }

        @Override
        public final Builder authenticationResult(AuthenticationResultType authenticationResult) {
            this.authenticationResult = authenticationResult;
            return this;
        }

        @Override
        public GetTokensFromRefreshTokenResponse build() {
            return new GetTokensFromRefreshTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTokensFromRefreshTokenResponse> {
        public Builder authenticationResult(AuthenticationResultType var1);

        default public Builder authenticationResult(Consumer<AuthenticationResultType.Builder> authenticationResult) {
            return this.authenticationResult((AuthenticationResultType)((AuthenticationResultType.Builder)AuthenticationResultType.builder().applyMutation(authenticationResult)).build());
        }
    }
}

