/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cognitoidentityprovider.internal.CognitoIdentityProviderServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AliasExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryFailureException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeMismatchException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CompleteWebAuthnRegistrationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CompleteWebAuthnRegistrationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateManagedLoginBrandingRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateManagedLoginBrandingResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteManagedLoginBrandingRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteManagedLoginBrandingResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteWebAuthnCredentialRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteWebAuthnCredentialResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeManagedLoginBrandingByClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeManagedLoginBrandingByClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeManagedLoginBrandingRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeManagedLoginBrandingResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceKeyExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DuplicateProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EnableSoftwareTokenMfaException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ExpiredCodeException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.FeatureUnavailableInTierException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForbiddenException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetTokensFromRefreshTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetTokensFromRefreshTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAuthFactorsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAuthFactorsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GroupExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InternalErrorException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidEmailRoleAccessPolicyException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidLambdaResponseException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidOAuthFlowException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidParameterException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidPasswordException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidSmsRoleAccessPolicyException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidSmsRoleTrustRelationshipException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidUserPoolConfigurationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LimitExceededException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListWebAuthnCredentialsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListWebAuthnCredentialsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ManagedLoginBrandingExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MfaMethodNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.NotAuthorizedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordHistoryPolicyViolationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordResetRequiredException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PreconditionNotMetException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RefreshTokenReuseException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ScopeDoesNotExistException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartWebAuthnRegistrationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartWebAuthnRegistrationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TierChangeNotAllowedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TooManyFailedAttemptsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TooManyRequestsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnauthorizedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnexpectedLambdaException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedIdentityProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedTokenTypeException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedUserStateException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateManagedLoginBrandingRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateManagedLoginBrandingResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportInProgressException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserLambdaValidationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserNotConfirmedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolAddOnNotEnabledException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolTaggingException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnChallengeNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnClientMismatchException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnConfigurationMissingException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnCredentialNotSupportedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnNotEnabledException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnOriginNotAllowedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnRelyingPartyMismatchException;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AddCustomAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminAddUserToGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminConfirmSignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminCreateUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDeleteUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDeleteUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDisableProviderForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDisableUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminEnableUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminForgetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminInitiateAuthRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminLinkProviderForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListDevicesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListGroupsForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListUserAuthEventsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminRemoveUserFromGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminResetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminRespondToAuthChallengeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserMfaPreferenceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateAuthEventFeedbackRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateDeviceStatusRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUserGlobalSignOutRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AssociateSoftwareTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ChangePasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CompleteWebAuthnRegistrationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmForgotPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmSignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateManagedLoginBrandingRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteManagedLoginBrandingRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteWebAuthnCredentialRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeManagedLoginBrandingByClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeManagedLoginBrandingRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeRiskConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ForgetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ForgotPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetCsvHeaderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetIdentityProviderByIdentifierRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetLogDeliveryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetSigningCertificateRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetTokensFromRefreshTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUiCustomizationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserAttributeVerificationCodeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserAuthFactorsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserPoolMfaConfigRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GlobalSignOutRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.InitiateAuthRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListIdentityProvidersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListResourceServersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserImportJobsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserPoolClientsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserPoolsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUsersInGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListWebAuthnCredentialsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ResendConfirmationCodeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.RespondToAuthChallengeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.RevokeTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetLogDeliveryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetRiskConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUiCustomizationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserMfaPreferenceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserPoolMfaConfigRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StartUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StartWebAuthnRegistrationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StopUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateAuthEventFeedbackRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateDeviceStatusRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateManagedLoginBrandingRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.VerifySoftwareTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.VerifyUserAttributeRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link CognitoIdentityProviderAsyncClient}.
 *
 * @see CognitoIdentityProviderAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCognitoIdentityProviderAsyncClient implements CognitoIdentityProviderAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCognitoIdentityProviderAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCognitoIdentityProviderAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds additional user attributes to the user pool schema. Custom attributes can be mutable or immutable and have a
     * <code>custom:</code> or <code>dev:</code> prefix. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-custom-attributes"
     * >Custom attributes</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param addCustomAttributesRequest
     *        Represents the request to add custom attributes.
     * @return A Java Future containing the result of the AddCustomAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you're trying to modify a user pool while
     *         a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AddCustomAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AddCustomAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddCustomAttributesResponse> addCustomAttributes(
            AddCustomAttributesRequest addCustomAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addCustomAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addCustomAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddCustomAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddCustomAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddCustomAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddCustomAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddCustomAttributesRequest, AddCustomAttributesResponse>()
                            .withOperationName("AddCustomAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddCustomAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addCustomAttributesRequest));
            CompletableFuture<AddCustomAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a user to a group. A user who is in a group can present a preferred-role claim to an identity pool, and
     * populates a <code>cognito:groups</code> claim to their access and identity tokens.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminAddUserToGroupRequest
     * @return A Java Future containing the result of the AdminAddUserToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminAddUserToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminAddUserToGroupResponse> adminAddUserToGroup(
            AdminAddUserToGroupRequest adminAddUserToGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminAddUserToGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminAddUserToGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminAddUserToGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminAddUserToGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminAddUserToGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminAddUserToGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminAddUserToGroupRequest, AdminAddUserToGroupResponse>()
                            .withOperationName("AdminAddUserToGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminAddUserToGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminAddUserToGroupRequest));
            CompletableFuture<AdminAddUserToGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Confirms user sign-up as an administrator.
     * </p>
     * <p>
     * This request sets a user account active in a user pool that <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#signing-up-users-in-your-app-and-confirming-them-as-admin"
     * >requires confirmation of new user accounts</a> before they can sign in. You can configure your user pool to not
     * send confirmation codes to new users and instead confirm them with this API operation on the back end.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * To configure your user pool to require administrative confirmation of users, set
     * <code>AllowAdminCreateUserOnly</code> to <code>true</code> in a <code>CreateUserPool</code> or
     * <code>UpdateUserPool</code> request.
     * </p>
     *
     * @param adminConfirmSignUpRequest
     *        Confirm a user's registration as a user pool administrator.
     * @return A Java Future containing the result of the AdminConfirmSignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action, such as sign-in.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminConfirmSignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminConfirmSignUpResponse> adminConfirmSignUp(AdminConfirmSignUpRequest adminConfirmSignUpRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminConfirmSignUpRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminConfirmSignUpRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminConfirmSignUp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminConfirmSignUpResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminConfirmSignUpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminConfirmSignUpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminConfirmSignUpRequest, AdminConfirmSignUpResponse>()
                            .withOperationName("AdminConfirmSignUp").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminConfirmSignUpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminConfirmSignUpRequest));
            CompletableFuture<AdminConfirmSignUpResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new user in the specified user pool.
     * </p>
     * <p>
     * If <code>MessageAction</code> isn't set, the default is to send a welcome message via email or phone (SMS).
     * </p>
     * <p>
     * This message is based on a template that you configured in your call to create or update a user pool. This
     * template includes your custom sign-up instructions and placeholders for user name and temporary password.
     * </p>
     * <p>
     * Alternatively, you can call <code>AdminCreateUser</code> with <code>SUPPRESS</code> for the
     * <code>MessageAction</code> parameter, and Amazon Cognito won't send any email.
     * </p>
     * <p>
     * In either case, if the user has a password, they will be in the <code>FORCE_CHANGE_PASSWORD</code> state until
     * they sign in and set their password. Your invitation message template must have the <code>{####}</code> password
     * placeholder if your users have passwords. If your template doesn't have this placeholder, Amazon Cognito doesn't
     * deliver the invitation message. In this case, you must update your message template and resend the password with
     * a new <code>AdminCreateUser</code> request with a <code>MessageAction</code> value of <code>RESEND</code>.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminCreateUserRequest
     *        Creates a new user in the specified user pool.
     * @return A Java Future containing the result of the AdminCreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UnsupportedUserStateException The request failed because the user is in an unsupported state.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminCreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminCreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminCreateUserResponse> adminCreateUser(AdminCreateUserRequest adminCreateUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminCreateUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminCreateUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminCreateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminCreateUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminCreateUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminCreateUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminCreateUserRequest, AdminCreateUserResponse>()
                            .withOperationName("AdminCreateUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminCreateUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminCreateUserRequest));
            CompletableFuture<AdminCreateUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user profile in your user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDeleteUserRequest
     *        Represents the request to delete a user as an administrator.
     * @return A Java Future containing the result of the AdminDeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminDeleteUserResponse> adminDeleteUser(AdminDeleteUserRequest adminDeleteUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminDeleteUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminDeleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminDeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminDeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminDeleteUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminDeleteUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminDeleteUserRequest, AdminDeleteUserResponse>()
                            .withOperationName("AdminDeleteUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminDeleteUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminDeleteUserRequest));
            CompletableFuture<AdminDeleteUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes attribute values from a user. This operation doesn't affect tokens for existing user sessions. The next
     * ID token that the user receives will no longer have the deleted attributes.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDeleteUserAttributesRequest
     *        Represents the request to delete user attributes as an administrator.
     * @return A Java Future containing the result of the AdminDeleteUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDeleteUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminDeleteUserAttributesResponse> adminDeleteUserAttributes(
            AdminDeleteUserAttributesRequest adminDeleteUserAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminDeleteUserAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminDeleteUserAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminDeleteUserAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminDeleteUserAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminDeleteUserAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminDeleteUserAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminDeleteUserAttributesRequest, AdminDeleteUserAttributesResponse>()
                            .withOperationName("AdminDeleteUserAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminDeleteUserAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminDeleteUserAttributesRequest));
            CompletableFuture<AdminDeleteUserAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Prevents the user from signing in with the specified external (SAML or social) identity provider (IdP). If the
     * user that you want to deactivate is a Amazon Cognito user pools native username + password user, they can't use
     * their password to sign in. If the user to deactivate is a linked external IdP user, any link between that user
     * and an existing user is removed. When the external user signs in again, and the user is no longer attached to the
     * previously linked <code>DestinationUser</code>, the user must create a new user account.
     * </p>
     * <p>
     * The value of <code>ProviderName</code> must match the name of a user pool IdP.
     * </p>
     * <p>
     * To deactivate a local user, set <code>ProviderName</code> to <code>Cognito</code> and the
     * <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. The <code>ProviderAttributeValue</code> must
     * be user's local username.
     * </p>
     * <p>
     * The <code>ProviderAttributeName</code> must always be <code>Cognito_Subject</code> for social IdPs. The
     * <code>ProviderAttributeValue</code> must always be the exact subject that was used when the user was originally
     * linked as a source user.
     * </p>
     * <p>
     * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign in,
     * the <code>ProviderAttributeName</code> and <code>ProviderAttributeValue</code> must be the same values that were
     * used for the <code>SourceUser</code> when the identities were originally linked using
     * <code> AdminLinkProviderForUser</code> call. This is also true if the linking was done with
     * <code>ProviderAttributeName</code> set to <code>Cognito_Subject</code>. If the user has already signed in, the
     * <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code> and <code>ProviderAttributeValue</code>
     * must be the <code>NameID</code> from their SAML assertion.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDisableProviderForUserRequest
     * @return A Java Future containing the result of the AdminDisableProviderForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDisableProviderForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminDisableProviderForUserResponse> adminDisableProviderForUser(
            AdminDisableProviderForUserRequest adminDisableProviderForUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminDisableProviderForUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminDisableProviderForUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminDisableProviderForUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminDisableProviderForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminDisableProviderForUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminDisableProviderForUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminDisableProviderForUserRequest, AdminDisableProviderForUserResponse>()
                            .withOperationName("AdminDisableProviderForUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminDisableProviderForUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminDisableProviderForUserRequest));
            CompletableFuture<AdminDisableProviderForUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deactivates a user profile and revokes all access tokens for the user. A deactivated user can't sign in, but
     * still appears in the responses to <code>ListUsers</code> API requests.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDisableUserRequest
     *        Represents the request to disable the user as an administrator.
     * @return A Java Future containing the result of the AdminDisableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDisableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminDisableUserResponse> adminDisableUser(AdminDisableUserRequest adminDisableUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminDisableUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminDisableUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminDisableUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminDisableUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminDisableUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminDisableUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminDisableUserRequest, AdminDisableUserResponse>()
                            .withOperationName("AdminDisableUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminDisableUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminDisableUserRequest));
            CompletableFuture<AdminDisableUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Activates sign-in for a user profile that previously had sign-in access disabled.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminEnableUserRequest
     *        Represents the request that enables the user as an administrator.
     * @return A Java Future containing the result of the AdminEnableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminEnableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminEnableUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminEnableUserResponse> adminEnableUser(AdminEnableUserRequest adminEnableUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminEnableUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminEnableUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminEnableUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminEnableUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminEnableUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminEnableUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminEnableUserRequest, AdminEnableUserResponse>()
                            .withOperationName("AdminEnableUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminEnableUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminEnableUserRequest));
            CompletableFuture<AdminEnableUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Forgets, or deletes, a remembered device from a user's profile. After you forget the device, the user can no
     * longer complete device authentication with that device and when applicable, must submit MFA codes again. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with devices</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminForgetDeviceRequest
     *        Sends the forgot device request, as an administrator.
     * @return A Java Future containing the result of the AdminForgetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminForgetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminForgetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminForgetDeviceResponse> adminForgetDevice(AdminForgetDeviceRequest adminForgetDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminForgetDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminForgetDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminForgetDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminForgetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminForgetDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminForgetDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminForgetDeviceRequest, AdminForgetDeviceResponse>()
                            .withOperationName("AdminForgetDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminForgetDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminForgetDeviceRequest));
            CompletableFuture<AdminForgetDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given the device key, returns details for a user's device. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with devices</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminGetDeviceRequest
     *        Represents the request to get the device, as an administrator.
     * @return A Java Future containing the result of the AdminGetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminGetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminGetDeviceResponse> adminGetDevice(AdminGetDeviceRequest adminGetDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminGetDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminGetDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminGetDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminGetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminGetDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminGetDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminGetDeviceRequest, AdminGetDeviceResponse>()
                            .withOperationName("AdminGetDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminGetDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminGetDeviceRequest));
            CompletableFuture<AdminGetDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a username, returns details about a user profile in a user pool. You can specify alias attributes in the
     * <code>Username</code> request parameter.
     * </p>
     * <p>
     * This operation contributes to your monthly active user (MAU) count for the purpose of billing.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminGetUserRequest
     *        Represents the request to get the specified user as an administrator.
     * @return A Java Future containing the result of the AdminGetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminGetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AdminGetUserResponse> adminGetUser(AdminGetUserRequest adminGetUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminGetUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminGetUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminGetUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminGetUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AdminGetUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminGetUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminGetUserRequest, AdminGetUserResponse>()
                            .withOperationName("AdminGetUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminGetUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminGetUserRequest));
            CompletableFuture<AdminGetUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts sign-in for applications with a server-side component, for example a traditional web application. This
     * operation specifies the authentication flow that you'd like to begin. The authentication flow that you specify
     * must be supported in your app client configuration. For more information about authentication flows, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html"
     * >Authentication flows</a>.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminInitiateAuthRequest
     *        Initiates the authorization request, as an administrator.
     * @return A Java Future containing the result of the AdminInitiateAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>UnsupportedOperationException Exception that is thrown when you attempt to perform an operation that
     *         isn't enabled for the user pool client.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito can't find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminInitiateAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminInitiateAuth" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminInitiateAuthResponse> adminInitiateAuth(AdminInitiateAuthRequest adminInitiateAuthRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminInitiateAuthRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminInitiateAuthRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminInitiateAuth");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminInitiateAuthResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminInitiateAuthResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminInitiateAuthResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminInitiateAuthRequest, AdminInitiateAuthResponse>()
                            .withOperationName("AdminInitiateAuth").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminInitiateAuthRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminInitiateAuthRequest));
            CompletableFuture<AdminInitiateAuthResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Links an existing user account in a user pool, or <code>DestinationUser</code>, to an identity from an external
     * IdP, or <code>SourceUser</code>, based on a specified attribute name and value from the external IdP.
     * </p>
     * <p>
     * This operation connects a local user profile with a user identity who hasn't yet signed in from their third-party
     * IdP. When the user signs in with their IdP, they get access-control configuration from the local user profile.
     * Linked local users can also sign in with SDK-based API operations like <code>InitiateAuth</code> after they sign
     * in at least once through their IdP. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html"
     * >Linking federated users</a>.
     * </p>
     * <note>
     * <p>
     * The maximum number of federated identities linked to a user is five.
     * </p>
     * </note> <important>
     * <p>
     * Because this API allows a user with an external federated identity to sign in as a local user, it is critical
     * that it only be used with external IdPs and linked attributes that you trust.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminLinkProviderForUserRequest
     * @return A Java Future containing the result of the AdminLinkProviderForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminLinkProviderForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminLinkProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminLinkProviderForUserResponse> adminLinkProviderForUser(
            AdminLinkProviderForUserRequest adminLinkProviderForUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminLinkProviderForUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminLinkProviderForUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminLinkProviderForUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminLinkProviderForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminLinkProviderForUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminLinkProviderForUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminLinkProviderForUserRequest, AdminLinkProviderForUserResponse>()
                            .withOperationName("AdminLinkProviderForUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminLinkProviderForUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminLinkProviderForUserRequest));
            CompletableFuture<AdminLinkProviderForUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists a user's registered devices. Remembered devices are used in authentication services where you offer a
     * "Remember me" option for users who you want to permit to sign in without MFA from a trusted device. Users can
     * bypass MFA while your application performs device SRP authentication on the back end. For more information, see
     * <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with devices</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminListDevicesRequest
     *        Represents the request to list devices, as an administrator.
     * @return A Java Future containing the result of the AdminListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminListDevicesResponse> adminListDevices(AdminListDevicesRequest adminListDevicesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminListDevicesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminListDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminListDevices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminListDevicesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminListDevicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminListDevicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminListDevicesRequest, AdminListDevicesResponse>()
                            .withOperationName("AdminListDevices").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminListDevicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminListDevicesRequest));
            CompletableFuture<AdminListDevicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the groups that a user belongs to. User pool groups are identifiers that you can reference from the
     * contents of ID and access tokens, and set preferred IAM roles for identity-pool authentication. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-user-groups.html">Adding
     * groups to a user pool</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminListGroupsForUserRequest
     * @return A Java Future containing the result of the AdminListGroupsForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminListGroupsForUserResponse> adminListGroupsForUser(
            AdminListGroupsForUserRequest adminListGroupsForUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminListGroupsForUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminListGroupsForUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminListGroupsForUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminListGroupsForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminListGroupsForUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminListGroupsForUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminListGroupsForUserRequest, AdminListGroupsForUserResponse>()
                            .withOperationName("AdminListGroupsForUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminListGroupsForUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminListGroupsForUserRequest));
            CompletableFuture<AdminListGroupsForUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests a history of user activity and any risks detected as part of Amazon Cognito threat protection. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-event-user-history"
     * >Viewing user event history</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminListUserAuthEventsRequest
     * @return A Java Future containing the result of the AdminListUserAuthEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListUserAuthEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminListUserAuthEventsResponse> adminListUserAuthEvents(
            AdminListUserAuthEventsRequest adminListUserAuthEventsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminListUserAuthEventsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminListUserAuthEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminListUserAuthEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminListUserAuthEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminListUserAuthEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminListUserAuthEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminListUserAuthEventsRequest, AdminListUserAuthEventsResponse>()
                            .withOperationName("AdminListUserAuthEvents").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminListUserAuthEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminListUserAuthEventsRequest));
            CompletableFuture<AdminListUserAuthEventsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a username and a group name, removes them from the group. User pool groups are identifiers that you can
     * reference from the contents of ID and access tokens, and set preferred IAM roles for identity-pool
     * authentication. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-user-groups.html">Adding
     * groups to a user pool</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminRemoveUserFromGroupRequest
     * @return A Java Future containing the result of the AdminRemoveUserFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminRemoveUserFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRemoveUserFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminRemoveUserFromGroupResponse> adminRemoveUserFromGroup(
            AdminRemoveUserFromGroupRequest adminRemoveUserFromGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminRemoveUserFromGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminRemoveUserFromGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminRemoveUserFromGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminRemoveUserFromGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminRemoveUserFromGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminRemoveUserFromGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminRemoveUserFromGroupRequest, AdminRemoveUserFromGroupResponse>()
                            .withOperationName("AdminRemoveUserFromGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminRemoveUserFromGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminRemoveUserFromGroupRequest));
            CompletableFuture<AdminRemoveUserFromGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resets the specified user's password in a user pool. This operation doesn't change the user's password, but sends
     * a password-reset code.
     * </p>
     * <p>
     * To use this API operation, your user pool must have self-service account recovery configured.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminResetUserPasswordRequest
     *        Represents the request to reset a user's password as an administrator.
     * @return A Java Future containing the result of the AdminResetUserPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminResetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminResetUserPasswordResponse> adminResetUserPassword(
            AdminResetUserPasswordRequest adminResetUserPasswordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminResetUserPasswordRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminResetUserPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminResetUserPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminResetUserPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminResetUserPasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminResetUserPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminResetUserPasswordRequest, AdminResetUserPasswordResponse>()
                            .withOperationName("AdminResetUserPassword").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminResetUserPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminResetUserPasswordRequest));
            CompletableFuture<AdminResetUserPasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for device authentication
     * that bypasses MFA, or for a custom authentication challenge. An <code>AdminRespondToAuthChallenge</code> API
     * request provides the answer to that challenge, like a code or a secure remote password (SRP). The parameters of a
     * response to an authentication challenge vary with the type of challenge.
     * </p>
     * <p>
     * For more information about custom authentication challenges, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">Custom
     * authentication challenge Lambda triggers</a>.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminRespondToAuthChallengeRequest
     *        The request to respond to the authentication challenge, as an administrator.
     * @return A Java Future containing the result of the AdminRespondToAuthChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>PasswordHistoryPolicyViolationException The message returned when a user's new password matches a
     *         previous password and doesn't comply with the password-history policy.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito can't find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminRespondToAuthChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminRespondToAuthChallengeResponse> adminRespondToAuthChallenge(
            AdminRespondToAuthChallengeRequest adminRespondToAuthChallengeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminRespondToAuthChallengeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminRespondToAuthChallengeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminRespondToAuthChallenge");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminRespondToAuthChallengeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminRespondToAuthChallengeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminRespondToAuthChallengeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminRespondToAuthChallengeRequest, AdminRespondToAuthChallengeResponse>()
                            .withOperationName("AdminRespondToAuthChallenge").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminRespondToAuthChallengeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminRespondToAuthChallengeRequest));
            CompletableFuture<AdminRespondToAuthChallengeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the user's multi-factor authentication (MFA) preference, including which MFA options are activated, and if
     * any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate
     * a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge
     * to choose an MFA option will be returned during sign-in.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminSetUserMfaPreferenceRequest
     * @return A Java Future containing the result of the AdminSetUserMFAPreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserMFAPreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminSetUserMfaPreferenceResponse> adminSetUserMFAPreference(
            AdminSetUserMfaPreferenceRequest adminSetUserMfaPreferenceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminSetUserMfaPreferenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminSetUserMfaPreferenceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminSetUserMFAPreference");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminSetUserMfaPreferenceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminSetUserMfaPreferenceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminSetUserMfaPreferenceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminSetUserMfaPreferenceRequest, AdminSetUserMfaPreferenceResponse>()
                            .withOperationName("AdminSetUserMFAPreference").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminSetUserMfaPreferenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminSetUserMfaPreferenceRequest));
            CompletableFuture<AdminSetUserMfaPreferenceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the specified user's password in a user pool. This operation administratively sets a temporary or permanent
     * password for a user. With this operation, you can bypass self-service password changes and permit immediate
     * sign-in with the password that you set. To do this, set <code>Permanent</code> to <code>true</code>.
     * </p>
     * <p>
     * You can also set a new temporary password in this request, send it to a user, and require them to choose a new
     * password on their next sign-in. To do this, set <code>Permanent</code> to <code>false</code>.
     * </p>
     * <p>
     * If the password is temporary, the user's <code>Status</code> becomes <code>FORCE_CHANGE_PASSWORD</code>. When the
     * user next tries to sign in, the <code>InitiateAuth</code> or <code>AdminInitiateAuth</code> response includes the
     * <code>NEW_PASSWORD_REQUIRED</code> challenge. If the user doesn't sign in before the temporary password expires,
     * they can no longer sign in and you must repeat this operation to set a temporary or permanent password for them.
     * </p>
     * <p>
     * After the user sets a new password, or if you set a permanent password, their status becomes
     * <code>Confirmed</code>.
     * </p>
     * <p>
     * <code>AdminSetUserPassword</code> can set a password for the user profile that Amazon Cognito creates for
     * third-party federated users. When you set a password, the federated user's status changes from
     * <code>EXTERNAL_PROVIDER</code> to <code>CONFIRMED</code>. A user in this state can sign in as a federated user,
     * and initiate authentication flows in the API like a linked native user. They can also modify their password and
     * attributes in token-authenticated API requests like <code>ChangePassword</code> and
     * <code>UpdateUserAttributes</code>. As a best security practice and to keep users in sync with your external IdP,
     * don't set passwords on federated user profiles. To set up a federated user for native sign-in with a linked
     * native user, refer to <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html"
     * >Linking federated users to an existing user profile</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminSetUserPasswordRequest
     * @return A Java Future containing the result of the AdminSetUserPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>PasswordHistoryPolicyViolationException The message returned when a user's new password matches a
     *         previous password and doesn't comply with the password-history policy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminSetUserPasswordResponse> adminSetUserPassword(
            AdminSetUserPasswordRequest adminSetUserPasswordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminSetUserPasswordRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminSetUserPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminSetUserPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminSetUserPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminSetUserPasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminSetUserPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminSetUserPasswordRequest, AdminSetUserPasswordResponse>()
                            .withOperationName("AdminSetUserPassword").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminSetUserPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminSetUserPasswordRequest));
            CompletableFuture<AdminSetUserPasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to
     * configure time-based one-time password (TOTP) software token MFA.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminSetUserSettingsRequest
     *        You can use this parameter to set an MFA configuration that uses the SMS delivery medium.
     * @return A Java Future containing the result of the AdminSetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminSetUserSettingsResponse> adminSetUserSettings(
            AdminSetUserSettingsRequest adminSetUserSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminSetUserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminSetUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminSetUserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminSetUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminSetUserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminSetUserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminSetUserSettingsRequest, AdminSetUserSettingsResponse>()
                            .withOperationName("AdminSetUserSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminSetUserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminSetUserSettingsRequest));
            CompletableFuture<AdminSetUserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the feedback for an authentication event generated by threat protection features. Your response
     * indicates that you think that the event either was from a valid user or was an unwanted authentication attempt.
     * This feedback improves the risk evaluation decision for the user pool as part of Amazon Cognito threat
     * protection. To activate this setting, your user pool must be on the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-plus.html"> Plus tier</a>.
     * </p>
     * <p>
     * To train the threat-protection model to recognize trusted and untrusted sign-in characteristics, configure threat
     * protection in audit-only mode and provide a mechanism for users or administrators to submit feedback. Your
     * feedback can tell Amazon Cognito that a risk rating was assigned at a level you don't agree with.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminUpdateAuthEventFeedbackRequest
     * @return A Java Future containing the result of the AdminUpdateAuthEventFeedback operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateAuthEventFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminUpdateAuthEventFeedbackResponse> adminUpdateAuthEventFeedback(
            AdminUpdateAuthEventFeedbackRequest adminUpdateAuthEventFeedbackRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminUpdateAuthEventFeedbackRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminUpdateAuthEventFeedbackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminUpdateAuthEventFeedback");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminUpdateAuthEventFeedbackResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminUpdateAuthEventFeedbackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminUpdateAuthEventFeedbackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminUpdateAuthEventFeedbackRequest, AdminUpdateAuthEventFeedbackResponse>()
                            .withOperationName("AdminUpdateAuthEventFeedback").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminUpdateAuthEventFeedbackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminUpdateAuthEventFeedbackRequest));
            CompletableFuture<AdminUpdateAuthEventFeedbackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the status of a user's device so that it is marked as remembered or not remembered for the purpose of
     * device authentication. Device authentication is a "remember me" mechanism that silently completes sign-in from
     * trusted devices with a device key instead of a user-provided MFA code. This operation changes the status of a
     * device without deleting it, so you can enable it again later. For more information about device authentication,
     * see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with devices</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminUpdateDeviceStatusRequest
     *        The request to update the device status, as an administrator.
     * @return A Java Future containing the result of the AdminUpdateDeviceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateDeviceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminUpdateDeviceStatusResponse> adminUpdateDeviceStatus(
            AdminUpdateDeviceStatusRequest adminUpdateDeviceStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminUpdateDeviceStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminUpdateDeviceStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminUpdateDeviceStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminUpdateDeviceStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminUpdateDeviceStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminUpdateDeviceStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminUpdateDeviceStatusRequest, AdminUpdateDeviceStatusResponse>()
                            .withOperationName("AdminUpdateDeviceStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminUpdateDeviceStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminUpdateDeviceStatusRequest));
            CompletableFuture<AdminUpdateDeviceStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified user's attributes. To delete an attribute from your user, submit the attribute in your API
     * request with a blank value.
     * </p>
     * <p>
     * For custom attributes, you must add a <code>custom:</code> prefix to the attribute name, for example
     * <code>custom:department</code>.
     * </p>
     * <p>
     * This operation can set a user's email address or phone number as verified and permit immediate sign-in in user
     * pools that require verification of these attributes. To do this, set the <code>email_verified</code> or
     * <code>phone_number_verified</code> attribute to <code>true</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param adminUpdateUserAttributesRequest
     *        Represents the request to update the user's attributes as an administrator.
     * @return A Java Future containing the result of the AdminUpdateUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminUpdateUserAttributesResponse> adminUpdateUserAttributes(
            AdminUpdateUserAttributesRequest adminUpdateUserAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminUpdateUserAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminUpdateUserAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminUpdateUserAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminUpdateUserAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminUpdateUserAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminUpdateUserAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminUpdateUserAttributesRequest, AdminUpdateUserAttributesResponse>()
                            .withOperationName("AdminUpdateUserAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminUpdateUserAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminUpdateUserAttributesRequest));
            CompletableFuture<AdminUpdateUserAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user. Call this operation
     * with your administrative credentials when your user signs out of your app. This results in the following
     * behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts <i>token-authorized</i> user operations that you authorize with a signed-out
     * user's access tokens. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * <p>
     * Amazon Cognito returns an <code>Access Token has been revoked</code> error when your app attempts to authorize a
     * user pools API request with a revoked access token that contains the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's ID token in a <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetId.html">GetId </a> request to an
     * identity pool with <code>ServerSideTokenCheck</code> enabled for its user pool IdP configuration in <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_CognitoIdentityProvider.html"
     * >CognitoIdentityProvider</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's refresh tokens in refresh requests.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Other requests might be valid until your user's token expires. This operation doesn't clear the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html">managed
     * login</a> session cookie. To clear the session for a user who signed in with managed login or the classic hosted
     * UI, direct their browser session to the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/logout-endpoint.html">logout endpoint</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminUserGlobalSignOutRequest
     *        The request to sign out of all devices, as an administrator.
     * @return A Java Future containing the result of the AdminUserGlobalSignOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUserGlobalSignOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUserGlobalSignOut"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminUserGlobalSignOutResponse> adminUserGlobalSignOut(
            AdminUserGlobalSignOutRequest adminUserGlobalSignOutRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminUserGlobalSignOutRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminUserGlobalSignOutRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminUserGlobalSignOut");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminUserGlobalSignOutResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminUserGlobalSignOutResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminUserGlobalSignOutResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminUserGlobalSignOutRequest, AdminUserGlobalSignOutResponse>()
                            .withOperationName("AdminUserGlobalSignOut").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminUserGlobalSignOutRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminUserGlobalSignOutRequest));
            CompletableFuture<AdminUserGlobalSignOutResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Begins setup of time-based one-time password (TOTP) multi-factor authentication (MFA) for a user, with a unique
     * private key that Amazon Cognito generates and returns in the API response. You can authorize an
     * <code>AssociateSoftwareToken</code> request with either the user's access token, or a session string from a
     * challenge response that you received from Amazon Cognito.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     *
     * @param associateSoftwareTokenRequest
     * @return A Java Future containing the result of the AssociateSoftwareToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AssociateSoftwareToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AssociateSoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateSoftwareTokenResponse> associateSoftwareToken(
            AssociateSoftwareTokenRequest associateSoftwareTokenRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateSoftwareTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateSoftwareTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateSoftwareToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateSoftwareTokenResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateSoftwareTokenResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateSoftwareTokenResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateSoftwareTokenRequest, AssociateSoftwareTokenResponse>()
                            .withOperationName("AssociateSoftwareToken").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateSoftwareTokenRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateSoftwareTokenRequest));
            CompletableFuture<AssociateSoftwareTokenResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the password for the currently signed-in user.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param changePasswordRequest
     *        Represents the request to change a user password.
     * @return A Java Future containing the result of the ChangePassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>PasswordHistoryPolicyViolationException The message returned when a user's new password matches a
     *         previous password and doesn't comply with the password-history policy.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ChangePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ChangePassword" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ChangePasswordResponse> changePassword(ChangePasswordRequest changePasswordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(changePasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, changePasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ChangePassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ChangePasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ChangePasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ChangePasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ChangePasswordRequest, ChangePasswordResponse>()
                            .withOperationName("ChangePassword").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ChangePasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(changePasswordRequest));
            CompletableFuture<ChangePasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Completes registration of a passkey authenticator for the currently signed-in user.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     *
     * @param completeWebAuthnRegistrationRequest
     * @return A Java Future containing the result of the CompleteWebAuthnRegistration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>WebAuthnNotEnabledException This exception is thrown when the passkey feature isn't enabled for the
     *         user pool.</li>
     *         <li>WebAuthnChallengeNotFoundException This exception is thrown when the challenge from
     *         <code>StartWebAuthn</code> registration has expired.</li>
     *         <li>WebAuthnRelyingPartyMismatchException This exception is thrown when the given passkey credential is
     *         associated with a different relying party ID than the user pool relying party ID.</li>
     *         <li>WebAuthnClientMismatchException This exception is thrown when the access token is for a different
     *         client than the one in the original <code>StartWebAuthnRegistration</code> request.</li>
     *         <li>WebAuthnOriginNotAllowedException This exception is thrown when the passkey credential's registration
     *         origin does not align with the user pool relying party id.</li>
     *         <li>WebAuthnCredentialNotSupportedException This exception is thrown when a user presents passkey
     *         credentials from an unsupported device or provider.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CompleteWebAuthnRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CompleteWebAuthnRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CompleteWebAuthnRegistrationResponse> completeWebAuthnRegistration(
            CompleteWebAuthnRegistrationRequest completeWebAuthnRegistrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(completeWebAuthnRegistrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, completeWebAuthnRegistrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CompleteWebAuthnRegistration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CompleteWebAuthnRegistrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CompleteWebAuthnRegistrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CompleteWebAuthnRegistrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CompleteWebAuthnRegistrationRequest, CompleteWebAuthnRegistrationResponse>()
                            .withOperationName("CompleteWebAuthnRegistration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CompleteWebAuthnRegistrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(completeWebAuthnRegistrationRequest));
            CompletableFuture<CompleteWebAuthnRegistrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Confirms a device that a user wants to remember. A remembered device is a "Remember me on this device" option for
     * user pools that perform authentication with the device key of a trusted device in the back end, instead of a
     * user-provided MFA code. For more information about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param confirmDeviceRequest
     *        The confirm-device request.
     * @return A Java Future containing the result of the ConfirmDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>DeviceKeyExistsException This exception is thrown when a user attempts to confirm a device with a
     *         device key that already exists.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmDeviceResponse> confirmDevice(ConfirmDeviceRequest confirmDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConfirmDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ConfirmDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ConfirmDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConfirmDeviceRequest, ConfirmDeviceResponse>()
                            .withOperationName("ConfirmDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConfirmDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(confirmDeviceRequest));
            CompletableFuture<ConfirmDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This public API operation accepts a confirmation code that Amazon Cognito sent to a user and accepts a new
     * password for that user.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param confirmForgotPasswordRequest
     *        The request representing the confirmation for a password reset.
     * @return A Java Future containing the result of the ConfirmForgotPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>PasswordHistoryPolicyViolationException The message returned when a user's new password matches a
     *         previous password and doesn't comply with the password-history policy.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action, such as sign-in.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmForgotPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmForgotPassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmForgotPasswordResponse> confirmForgotPassword(
            ConfirmForgotPasswordRequest confirmForgotPasswordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmForgotPasswordRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmForgotPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmForgotPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConfirmForgotPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ConfirmForgotPasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ConfirmForgotPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConfirmForgotPasswordRequest, ConfirmForgotPasswordResponse>()
                            .withOperationName("ConfirmForgotPassword").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConfirmForgotPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(confirmForgotPasswordRequest));
            CompletableFuture<ConfirmForgotPasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Confirms the account of a new user. This public API operation submits a code that Amazon Cognito sent to your
     * user when they signed up in your user pool. After your user enters their code, they confirm ownership of the
     * email address or phone number that they provided, and their user account becomes active. Depending on your user
     * pool configuration, your users will receive their confirmation code in an email or SMS message.
     * </p>
     * <p>
     * Local users who signed up in your user pool are the only type of user who can confirm sign-up with a code. Users
     * who federate through an external identity provider (IdP) have already been confirmed by their IdP.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param confirmSignUpRequest
     *        Represents the request to confirm registration of a user.
     * @return A Java Future containing the result of the ConfirmSignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action, such as sign-in.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmSignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmSignUpResponse> confirmSignUp(ConfirmSignUpRequest confirmSignUpRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmSignUpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmSignUpRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmSignUp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConfirmSignUpResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ConfirmSignUpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ConfirmSignUpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConfirmSignUpRequest, ConfirmSignUpResponse>()
                            .withOperationName("ConfirmSignUp").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConfirmSignUpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(confirmSignUpRequest));
            CompletableFuture<ConfirmSignUpResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new group in the specified user pool. For more information about user pool groups, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-user-groups.html">Adding
     * groups to a user pool</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>GroupExistsException This exception is thrown when Amazon Cognito encounters a group that already
     *         exists in the user pool.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                            .withOperationName("CreateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createGroupRequest));
            CompletableFuture<CreateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a configuration and trust relationship between a third-party identity provider (IdP) and a user pool. Amazon
     * Cognito accepts sign-in with third-party identity providers through managed login and OIDC relying-party
     * libraries. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html"
     * >Third-party IdP sign-in</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createIdentityProviderRequest
     * @return A Java Future containing the result of the CreateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>DuplicateProviderException This exception is thrown when the provider is already supported by the
     *         user pool.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIdentityProviderResponse> createIdentityProvider(
            CreateIdentityProviderRequest createIdentityProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIdentityProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateIdentityProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIdentityProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIdentityProviderRequest, CreateIdentityProviderResponse>()
                            .withOperationName("CreateIdentityProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIdentityProviderRequest));
            CompletableFuture<CreateIdentityProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new set of branding settings for a user pool style and associates it with an app client. This operation
     * is the programmatic option for the creation of a new style in the branding designer.
     * </p>
     * <p>
     * Provides values for UI customization in a <code>Settings</code> JSON object and image files in an
     * <code>Assets</code> array. To send the JSON object <code>Document</code> type parameter in <code>Settings</code>,
     * you might need to update to the most recent version of your Amazon Web Services SDK. To create a new style with
     * default settings, set <code>UseCognitoProvidedValues</code> to <code>true</code> and don't provide values for any
     * other options.
     * </p>
     * <p>
     * This operation has a 2-megabyte request-size limit and include the CSS settings and image assets for your app
     * client. Your branding settings might exceed 2MB in size. Amazon Cognito doesn't require that you pass all
     * parameters in one request and preserves existing style settings that you don't specify. If your request is larger
     * than 2MB, separate it into multiple requests, each with a size smaller than the limit.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createManagedLoginBrandingRequest
     * @return A Java Future containing the result of the CreateManagedLoginBranding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>ManagedLoginBrandingExistsException This exception is thrown when you attempt to apply a managed
     *         login branding style to an app client that already has an assigned style.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateManagedLoginBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateManagedLoginBranding"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateManagedLoginBrandingResponse> createManagedLoginBranding(
            CreateManagedLoginBrandingRequest createManagedLoginBrandingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createManagedLoginBrandingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createManagedLoginBrandingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateManagedLoginBranding");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateManagedLoginBrandingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateManagedLoginBrandingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateManagedLoginBrandingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateManagedLoginBrandingRequest, CreateManagedLoginBrandingResponse>()
                            .withOperationName("CreateManagedLoginBranding").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateManagedLoginBrandingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createManagedLoginBrandingRequest));
            CompletableFuture<CreateManagedLoginBrandingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new OAuth2.0 resource server and defines custom scopes within it. Resource servers are associated with
     * custom scopes and machine-to-machine (M2M) authorization. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-define-resource-servers.html"
     * >Access control with resource servers</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createResourceServerRequest
     * @return A Java Future containing the result of the CreateResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourceServerResponse> createResourceServer(
            CreateResourceServerRequest createResourceServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResourceServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourceServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourceServerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResourceServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResourceServerRequest, CreateResourceServerResponse>()
                            .withOperationName("CreateResourceServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateResourceServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createResourceServerRequest));
            CompletableFuture<CreateResourceServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a user import job. You can import users into user pools from a comma-separated values (CSV) file without
     * adding Amazon Cognito MAU costs to your Amazon Web Services bill.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserImportJobRequest
     *        Represents the request to create the user import job.
     * @return A Java Future containing the result of the CreateUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserImportJobResponse> createUserImportJob(
            CreateUserImportJobRequest createUserImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUserImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserImportJobRequest, CreateUserImportJobResponse>()
                            .withOperationName("CreateUserImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUserImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUserImportJobRequest));
            CompletableFuture<CreateUserImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Amazon Cognito user pool. This operation sets basic and advanced configuration options.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserPoolRequest
     *        Represents the request to create a user pool.
     * @return A Java Future containing the result of the CreateUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag can't be set or updated.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>TierChangeNotAllowedException This exception is thrown when you've attempted to change your feature
     *         plan but the operation isn't permitted.</li>
     *         <li>FeatureUnavailableInTierException This exception is thrown when a feature you attempted to configure
     *         isn't available in your current feature plan.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserPoolResponse> createUserPool(CreateUserPoolRequest createUserPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUserPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserPoolRequest, CreateUserPoolResponse>()
                            .withOperationName("CreateUserPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUserPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUserPoolRequest));
            CompletableFuture<CreateUserPoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an app client in a user pool. This operation sets basic and advanced configuration options.
     * </p>
     * <p>
     * Unlike app clients created in the console, Amazon Cognito doesn't automatically assign a branding style to app
     * clients that you configure with this API operation. Managed login and classic hosted UI pages aren't available
     * for your client until after you apply a branding style.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserPoolClientRequest
     *        Represents the request to create a user pool client.
     * @return A Java Future containing the result of the CreateUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ScopeDoesNotExistException This exception is thrown when the specified scope doesn't exist.</li>
     *         <li>InvalidOAuthFlowException This exception is thrown when the specified OAuth flow is not valid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>FeatureUnavailableInTierException This exception is thrown when a feature you attempted to configure
     *         isn't available in your current feature plan.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserPoolClientResponse> createUserPoolClient(
            CreateUserPoolClientRequest createUserPoolClientRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserPoolClientRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserPoolClientRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserPoolClient");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserPoolClientResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUserPoolClientResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserPoolClientResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserPoolClientRequest, CreateUserPoolClientResponse>()
                            .withOperationName("CreateUserPoolClient").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUserPoolClientRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUserPoolClientRequest));
            CompletableFuture<CreateUserPoolClientResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A user pool domain hosts managed login, an authorization server and web server for authentication in your
     * application. This operation creates a new user pool prefix domain or custom domain and sets the managed login
     * branding version. Set the branding version to <code>1</code> for hosted UI (classic) or <code>2</code> for
     * managed login. When you choose a custom domain, you must provide an SSL certificate in the US East (N. Virginia)
     * Amazon Web Services Region in your request.
     * </p>
     * <p>
     * Your prefix domain might take up to one minute to take effect. Your custom domain is online within five minutes,
     * but it can take up to one hour to distribute your SSL certificate.
     * </p>
     * <p>
     * For more information about adding a custom domain to your user pool, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html"
     * >Configuring a user pool domain</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserPoolDomainRequest
     * @return A Java Future containing the result of the CreateUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>FeatureUnavailableInTierException This exception is thrown when a feature you attempted to configure
     *         isn't available in your current feature plan.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserPoolDomainResponse> createUserPoolDomain(
            CreateUserPoolDomainRequest createUserPoolDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserPoolDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserPoolDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserPoolDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserPoolDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUserPoolDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserPoolDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserPoolDomainRequest, CreateUserPoolDomainResponse>()
                            .withOperationName("CreateUserPoolDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUserPoolDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUserPoolDomainRequest));
            CompletableFuture<CreateUserPoolDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a group from the specified user pool. When you delete a group, that group no longer contributes to users'
     * <code>cognito:preferred_group</code> or <code>cognito:groups</code> claims, and no longer influence
     * access-control decision that are based on group membership. For more information about user pool groups, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-user-groups.html">Adding
     * groups to a user pool</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                            .withOperationName("DeleteGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGroupRequest));
            CompletableFuture<DeleteGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user pool identity provider (IdP). After you delete an IdP, users can no longer sign in to your user
     * pool through that IdP. For more information about user pool IdPs, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html"
     * >Third-party IdP sign-in</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteIdentityProviderRequest
     * @return A Java Future containing the result of the DeleteIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedIdentityProviderException This exception is thrown when the specified identifier isn't
     *         supported.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIdentityProviderResponse> deleteIdentityProvider(
            DeleteIdentityProviderRequest deleteIdentityProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIdentityProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIdentityProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIdentityProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse>()
                            .withOperationName("DeleteIdentityProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIdentityProviderRequest));
            CompletableFuture<DeleteIdentityProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a managed login branding style. When you delete a style, you delete the branding association for an app
     * client. When an app client doesn't have a style assigned, your managed login pages for that app client are
     * nonfunctional until you create a new style or switch the domain branding version.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteManagedLoginBrandingRequest
     * @return A Java Future containing the result of the DeleteManagedLoginBranding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteManagedLoginBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteManagedLoginBranding"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteManagedLoginBrandingResponse> deleteManagedLoginBranding(
            DeleteManagedLoginBrandingRequest deleteManagedLoginBrandingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteManagedLoginBrandingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteManagedLoginBrandingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteManagedLoginBranding");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteManagedLoginBrandingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteManagedLoginBrandingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteManagedLoginBrandingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteManagedLoginBrandingRequest, DeleteManagedLoginBrandingResponse>()
                            .withOperationName("DeleteManagedLoginBranding").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteManagedLoginBrandingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteManagedLoginBrandingRequest));
            CompletableFuture<DeleteManagedLoginBrandingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a resource server. After you delete a resource server, users can no longer generate access tokens with
     * scopes that are associate with that resource server.
     * </p>
     * <p>
     * Resource servers are associated with custom scopes and machine-to-machine (M2M) authorization. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-define-resource-servers.html"
     * >Access control with resource servers</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteResourceServerRequest
     * @return A Java Future containing the result of the DeleteResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourceServerResponse> deleteResourceServer(
            DeleteResourceServerRequest deleteResourceServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourceServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourceServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourceServerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResourceServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceServerRequest, DeleteResourceServerResponse>()
                            .withOperationName("DeleteResourceServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourceServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourceServerRequest));
            CompletableFuture<DeleteResourceServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the profile of the currently signed-in user. A deleted user profile can no longer be used to sign in and
     * can't be restored.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param deleteUserRequest
     *        Represents the request to delete a user.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserRequest));
            CompletableFuture<DeleteUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes attributes from the currently signed-in user. For example, your application can submit a request to this
     * operation when a user wants to remove their <code>birthdate</code> attribute value.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param deleteUserAttributesRequest
     *        Represents the request to delete user attributes.
     * @return A Java Future containing the result of the DeleteUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserAttributesResponse> deleteUserAttributes(
            DeleteUserAttributesRequest deleteUserAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserAttributesRequest, DeleteUserAttributesResponse>()
                            .withOperationName("DeleteUserAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserAttributesRequest));
            CompletableFuture<DeleteUserAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user pool. After you delete a user pool, users can no longer sign in to any associated applications.
     * </p>
     * <p>
     * When you delete a user pool, it's no longer visible or operational in your Amazon Web Services account. Amazon
     * Cognito retains deleted user pools in an inactive state for 14 days, then begins a cleanup process that fully
     * removes them from Amazon Web Services systems. In case of accidental deletion, contact Amazon Web ServicesSupport
     * within 14 days for restoration assistance.
     * </p>
     * <p>
     * Amazon Cognito begins full deletion of all resources from deleted user pools after 14 days. In the case of large
     * user pools, the cleanup process might take significant additional time before all user data is permanently
     * deleted.
     * </p>
     *
     * @param deleteUserPoolRequest
     *        Represents the request to delete a user pool.
     * @return A Java Future containing the result of the DeleteUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you're trying to modify a user pool while
     *         a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserPoolResponse> deleteUserPool(DeleteUserPoolRequest deleteUserPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserPoolRequest, DeleteUserPoolResponse>()
                            .withOperationName("DeleteUserPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserPoolRequest));
            CompletableFuture<DeleteUserPoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user pool app client. After you delete an app client, users can no longer sign in to the associated
     * application.
     * </p>
     *
     * @param deleteUserPoolClientRequest
     *        Represents the request to delete a user pool client.
     * @return A Java Future containing the result of the DeleteUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserPoolClientResponse> deleteUserPoolClient(
            DeleteUserPoolClientRequest deleteUserPoolClientRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserPoolClientRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserPoolClientRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserPoolClient");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserPoolClientResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserPoolClientResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserPoolClientResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserPoolClientRequest, DeleteUserPoolClientResponse>()
                            .withOperationName("DeleteUserPoolClient").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserPoolClientRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserPoolClientRequest));
            CompletableFuture<DeleteUserPoolClientResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID and domain identifier, deletes a user pool domain. After you delete a user pool domain, your
     * managed login pages and authorization server are no longer available.
     * </p>
     *
     * @param deleteUserPoolDomainRequest
     * @return A Java Future containing the result of the DeleteUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserPoolDomainResponse> deleteUserPoolDomain(
            DeleteUserPoolDomainRequest deleteUserPoolDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserPoolDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserPoolDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserPoolDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserPoolDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserPoolDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserPoolDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserPoolDomainRequest, DeleteUserPoolDomainResponse>()
                            .withOperationName("DeleteUserPoolDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserPoolDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserPoolDomainRequest));
            CompletableFuture<DeleteUserPoolDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a registered passkey, or WebAuthn, authenticator for the currently signed-in user.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param deleteWebAuthnCredentialRequest
     * @return A Java Future containing the result of the DeleteWebAuthnCredential operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteWebAuthnCredential
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteWebAuthnCredential"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWebAuthnCredentialResponse> deleteWebAuthnCredential(
            DeleteWebAuthnCredentialRequest deleteWebAuthnCredentialRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWebAuthnCredentialRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWebAuthnCredentialRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWebAuthnCredential");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWebAuthnCredentialResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWebAuthnCredentialResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWebAuthnCredentialResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWebAuthnCredentialRequest, DeleteWebAuthnCredentialResponse>()
                            .withOperationName("DeleteWebAuthnCredential").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteWebAuthnCredentialRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWebAuthnCredentialRequest));
            CompletableFuture<DeleteWebAuthnCredentialResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID and identity provider (IdP) name, returns details about the IdP.
     * </p>
     *
     * @param describeIdentityProviderRequest
     * @return A Java Future containing the result of the DescribeIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIdentityProviderResponse> describeIdentityProvider(
            DescribeIdentityProviderRequest describeIdentityProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeIdentityProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeIdentityProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeIdentityProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeIdentityProviderRequest, DescribeIdentityProviderResponse>()
                            .withOperationName("DescribeIdentityProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeIdentityProviderRequest));
            CompletableFuture<DescribeIdentityProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given the ID of a managed login branding style, returns detailed information about the style.
     * </p>
     *
     * @param describeManagedLoginBrandingRequest
     * @return A Java Future containing the result of the DescribeManagedLoginBranding operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeManagedLoginBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeManagedLoginBranding"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeManagedLoginBrandingResponse> describeManagedLoginBranding(
            DescribeManagedLoginBrandingRequest describeManagedLoginBrandingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeManagedLoginBrandingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeManagedLoginBrandingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeManagedLoginBranding");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeManagedLoginBrandingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeManagedLoginBrandingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeManagedLoginBrandingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeManagedLoginBrandingRequest, DescribeManagedLoginBrandingResponse>()
                            .withOperationName("DescribeManagedLoginBranding").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeManagedLoginBrandingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeManagedLoginBrandingRequest));
            CompletableFuture<DescribeManagedLoginBrandingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given the ID of a user pool app client, returns detailed information about the style assigned to the app client.
     * </p>
     *
     * @param describeManagedLoginBrandingByClientRequest
     * @return A Java Future containing the result of the DescribeManagedLoginBrandingByClient operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeManagedLoginBrandingByClient
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeManagedLoginBrandingByClient"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeManagedLoginBrandingByClientResponse> describeManagedLoginBrandingByClient(
            DescribeManagedLoginBrandingByClientRequest describeManagedLoginBrandingByClientRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeManagedLoginBrandingByClientRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeManagedLoginBrandingByClientRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeManagedLoginBrandingByClient");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeManagedLoginBrandingByClientResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeManagedLoginBrandingByClientResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeManagedLoginBrandingByClientResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeManagedLoginBrandingByClientRequest, DescribeManagedLoginBrandingByClientResponse>()
                            .withOperationName("DescribeManagedLoginBrandingByClient").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeManagedLoginBrandingByClientRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeManagedLoginBrandingByClientRequest));
            CompletableFuture<DescribeManagedLoginBrandingByClientResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a resource server. For more information about resource servers, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-define-resource-servers.html"
     * >Access control with resource servers</a>.
     * </p>
     *
     * @param describeResourceServerRequest
     * @return A Java Future containing the result of the DescribeResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeResourceServerResponse> describeResourceServer(
            DescribeResourceServerRequest describeResourceServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeResourceServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResourceServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResourceServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeResourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeResourceServerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeResourceServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeResourceServerRequest, DescribeResourceServerResponse>()
                            .withOperationName("DescribeResourceServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeResourceServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeResourceServerRequest));
            CompletableFuture<DescribeResourceServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given an app client or user pool ID where threat protection is configured, describes the risk configuration. This
     * operation returns details about adaptive authentication, compromised credentials, and IP-address allow- and
     * denylists. For more information about threat protection, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-threat-protection.html"
     * >Threat protection</a>.
     * </p>
     *
     * @param describeRiskConfigurationRequest
     * @return A Java Future containing the result of the DescribeRiskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeRiskConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRiskConfigurationResponse> describeRiskConfiguration(
            DescribeRiskConfigurationRequest describeRiskConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRiskConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRiskConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRiskConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRiskConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRiskConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRiskConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRiskConfigurationRequest, DescribeRiskConfigurationResponse>()
                            .withOperationName("DescribeRiskConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRiskConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRiskConfigurationRequest));
            CompletableFuture<DescribeRiskConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a user import job. For more information about user CSV import, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-using-import-tool.html"
     * >Importing users from a CSV file</a>.
     * </p>
     *
     * @param describeUserImportJobRequest
     *        Represents the request to describe the user import job.
     * @return A Java Future containing the result of the DescribeUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserImportJobResponse> describeUserImportJob(
            DescribeUserImportJobRequest describeUserImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUserImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUserImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUserImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeUserImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUserImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserImportJobRequest, DescribeUserImportJobResponse>()
                            .withOperationName("DescribeUserImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeUserImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeUserImportJobRequest));
            CompletableFuture<DescribeUserImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID, returns configuration information. This operation is useful when you want to inspect an
     * existing user pool and programmatically replicate the configuration to another user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeUserPoolRequest
     *        Represents the request to describe the user pool.
     * @return A Java Future containing the result of the DescribeUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag can't be set or updated.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserPoolResponse> describeUserPool(DescribeUserPoolRequest describeUserPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUserPoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUserPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUserPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeUserPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUserPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserPoolRequest, DescribeUserPoolResponse>()
                            .withOperationName("DescribeUserPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeUserPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeUserPoolRequest));
            CompletableFuture<DescribeUserPoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given an app client ID, returns configuration information. This operation is useful when you want to inspect an
     * existing app client and programmatically replicate the configuration to another app client. For more information
     * about app clients, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html">App
     * clients</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeUserPoolClientRequest
     *        Represents the request to describe a user pool client.
     * @return A Java Future containing the result of the DescribeUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserPoolClientResponse> describeUserPoolClient(
            DescribeUserPoolClientRequest describeUserPoolClientRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUserPoolClientRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserPoolClientRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUserPoolClient");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUserPoolClientResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeUserPoolClientResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUserPoolClientResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserPoolClientRequest, DescribeUserPoolClientResponse>()
                            .withOperationName("DescribeUserPoolClient").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeUserPoolClientRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeUserPoolClientRequest));
            CompletableFuture<DescribeUserPoolClientResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool domain name, returns information about the domain configuration.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeUserPoolDomainRequest
     * @return A Java Future containing the result of the DescribeUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserPoolDomainResponse> describeUserPoolDomain(
            DescribeUserPoolDomainRequest describeUserPoolDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUserPoolDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserPoolDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUserPoolDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUserPoolDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeUserPoolDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUserPoolDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserPoolDomainRequest, DescribeUserPoolDomainResponse>()
                            .withOperationName("DescribeUserPoolDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeUserPoolDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeUserPoolDomainRequest));
            CompletableFuture<DescribeUserPoolDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a device key, deletes a remembered device as the currently signed-in user. For more information about
     * device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param forgetDeviceRequest
     *        Represents the request to forget the device.
     * @return A Java Future containing the result of the ForgetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ForgetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ForgetDeviceResponse> forgetDevice(ForgetDeviceRequest forgetDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(forgetDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, forgetDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ForgetDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ForgetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ForgetDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ForgetDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ForgetDeviceRequest, ForgetDeviceResponse>()
                            .withOperationName("ForgetDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ForgetDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(forgetDeviceRequest));
            CompletableFuture<ForgetDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sends a password-reset confirmation code for the currently signed-in user.
     * </p>
     * <p>
     * For the <code>Username</code> parameter, you can use the username or user alias.
     * </p>
     * <p>
     * If neither a verified phone number nor a verified email exists, Amazon Cognito responds with an
     * <code>InvalidParameterException</code> error . If your app client has a client secret and you don't provide a
     * <code>SECRET_HASH</code> parameter, this API returns <code>NotAuthorizedException</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param forgotPasswordRequest
     *        Represents the request to reset a user's password.
     * @return A Java Future containing the result of the ForgotPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ForgotPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPassword" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ForgotPasswordResponse> forgotPassword(ForgotPasswordRequest forgotPasswordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(forgotPasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, forgotPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ForgotPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ForgotPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ForgotPasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ForgotPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ForgotPasswordRequest, ForgotPasswordResponse>()
                            .withOperationName("ForgotPassword").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ForgotPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(forgotPasswordRequest));
            CompletableFuture<ForgotPasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID, generates a comma-separated value (CSV) list populated with available user attributes in
     * the user pool. This list is the header for the CSV file that determines the users in a user import job. Save the
     * content of <code>CSVHeader</code> in the response as a <code>.csv</code> file and populate it with the usernames
     * and attributes of users that you want to import. For more information about CSV user import, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-using-import-tool.html"
     * >Importing users from a CSV file</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param getCsvHeaderRequest
     *        Represents the request to get the header information of the CSV file for the user import job.
     * @return A Java Future containing the result of the GetCSVHeader operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetCSVHeader
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetCSVHeader" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCsvHeaderResponse> getCSVHeader(GetCsvHeaderRequest getCsvHeaderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCsvHeaderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCsvHeaderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCSVHeader");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCsvHeaderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetCsvHeaderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCsvHeaderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCsvHeaderRequest, GetCsvHeaderResponse>()
                            .withOperationName("GetCSVHeader").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCsvHeaderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCsvHeaderRequest));
            CompletableFuture<GetCsvHeaderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a device key, returns information about a remembered device for the current user. For more information
     * about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param getDeviceRequest
     *        Represents the request to get the device.
     * @return A Java Future containing the result of the GetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeviceResponse> getDevice(GetDeviceRequest getDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeviceRequest, GetDeviceResponse>().withOperationName("GetDevice")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeviceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDeviceRequest));
            CompletableFuture<GetDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID and a group name, returns information about the user group.
     * </p>
     * <p>
     * For more information about user pool groups, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-user-groups.html">Adding
     * groups to a user pool</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param getGroupRequest
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetGroupResponse> getGroup(GetGroupRequest getGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGroupRequest, GetGroupResponse>().withOperationName("GetGroup")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getGroupRequest));
            CompletableFuture<GetGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given the identifier of an identity provider (IdP), for example <code>examplecorp</code>, returns information
     * about the user pool configuration for that IdP. For more information about IdPs, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html"
     * >Third-party IdP sign-in</a>.
     * </p>
     *
     * @param getIdentityProviderByIdentifierRequest
     * @return A Java Future containing the result of the GetIdentityProviderByIdentifier operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetIdentityProviderByIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetIdentityProviderByIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetIdentityProviderByIdentifierResponse> getIdentityProviderByIdentifier(
            GetIdentityProviderByIdentifierRequest getIdentityProviderByIdentifierRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIdentityProviderByIdentifierRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getIdentityProviderByIdentifierRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIdentityProviderByIdentifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIdentityProviderByIdentifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIdentityProviderByIdentifierResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIdentityProviderByIdentifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIdentityProviderByIdentifierRequest, GetIdentityProviderByIdentifierResponse>()
                            .withOperationName("GetIdentityProviderByIdentifier").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIdentityProviderByIdentifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getIdentityProviderByIdentifierRequest));
            CompletableFuture<GetIdentityProviderByIdentifierResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID, returns the logging configuration. User pools can export message-delivery error and
     * threat-protection activity logs to external Amazon Web Services services. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/exporting-quotas-and-usage.html">Exporting user
     * pool logs</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param getLogDeliveryConfigurationRequest
     * @return A Java Future containing the result of the GetLogDeliveryConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetLogDeliveryConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetLogDeliveryConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLogDeliveryConfigurationResponse> getLogDeliveryConfiguration(
            GetLogDeliveryConfigurationRequest getLogDeliveryConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLogDeliveryConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLogDeliveryConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLogDeliveryConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLogDeliveryConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLogDeliveryConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLogDeliveryConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLogDeliveryConfigurationRequest, GetLogDeliveryConfigurationResponse>()
                            .withOperationName("GetLogDeliveryConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetLogDeliveryConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getLogDeliveryConfigurationRequest));
            CompletableFuture<GetLogDeliveryConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID, returns the signing certificate for SAML 2.0 federation.
     * </p>
     * <p>
     * Issued certificates are valid for 10 years from the date of issue. Amazon Cognito issues and assigns a new
     * signing certificate annually. This renewal process returns a new value in the response to
     * <code>GetSigningCertificate</code>, but doesn't invalidate the original certificate.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-SAML-signing-encryption.html#cognito-user-pools-SAML-signing"
     * >Signing SAML requests</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param getSigningCertificateRequest
     *        Request to get a signing certificate from Amazon Cognito.
     * @return A Java Future containing the result of the GetSigningCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetSigningCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetSigningCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSigningCertificateResponse> getSigningCertificate(
            GetSigningCertificateRequest getSigningCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSigningCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSigningCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSigningCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSigningCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSigningCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSigningCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSigningCertificateRequest, GetSigningCertificateResponse>()
                            .withOperationName("GetSigningCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSigningCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSigningCertificateRequest));
            CompletableFuture<GetSigningCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a refresh token, issues new ID, access, and optionally refresh tokens for the user who owns the submitted
     * token. This operation issues a new refresh token and invalidates the original refresh token after an optional
     * grace period when refresh token rotation is enabled. If refresh token rotation is disabled, issues new ID and
     * access tokens only.
     * </p>
     *
     * @param getTokensFromRefreshTokenRequest
     * @return A Java Future containing the result of the GetTokensFromRefreshToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>RefreshTokenReuseException This exception is throw when your application requests token refresh with
     *         a refresh token that has been invalidated by refresh-token rotation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetTokensFromRefreshToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetTokensFromRefreshToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTokensFromRefreshTokenResponse> getTokensFromRefreshToken(
            GetTokensFromRefreshTokenRequest getTokensFromRefreshTokenRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTokensFromRefreshTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTokensFromRefreshTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTokensFromRefreshToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTokensFromRefreshTokenResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTokensFromRefreshTokenResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTokensFromRefreshTokenResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTokensFromRefreshTokenRequest, GetTokensFromRefreshTokenResponse>()
                            .withOperationName("GetTokensFromRefreshToken").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTokensFromRefreshTokenRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTokensFromRefreshTokenRequest));
            CompletableFuture<GetTokensFromRefreshTokenResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID or app client, returns information about classic hosted UI branding that you applied, if
     * any. Returns user-pool level branding information if no app client branding is applied, or if you don't specify
     * an app client ID. Returns an empty object if you haven't applied hosted UI branding to either the client or the
     * user pool. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-ui-classic-branding.html">Hosted UI
     * (classic) branding</a>.
     * </p>
     *
     * @param getUiCustomizationRequest
     * @return A Java Future containing the result of the GetUICustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUICustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUICustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUiCustomizationResponse> getUICustomization(GetUiCustomizationRequest getUiCustomizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUiCustomizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUiCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUICustomization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUiCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUiCustomizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUiCustomizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUiCustomizationRequest, GetUiCustomizationResponse>()
                            .withOperationName("GetUICustomization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUiCustomizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUiCustomizationRequest));
            CompletableFuture<GetUiCustomizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets user attributes and and MFA settings for the currently signed-in user.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param getUserRequest
     *        Represents the request to get information about the user.
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserResponse> getUser(GetUserRequest getUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUserRequest, GetUserResponse>().withOperationName("GetUser")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUserRequest));
            CompletableFuture<GetUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given an attribute name, sends a user attribute verification code for the specified attribute name to the
     * currently signed-in user.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param getUserAttributeVerificationCodeRequest
     *        Represents the request to get user attribute verification.
     * @return A Java Future containing the result of the GetUserAttributeVerificationCode operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUserAttributeVerificationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCode"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserAttributeVerificationCodeResponse> getUserAttributeVerificationCode(
            GetUserAttributeVerificationCodeRequest getUserAttributeVerificationCodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserAttributeVerificationCodeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getUserAttributeVerificationCodeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserAttributeVerificationCode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUserAttributeVerificationCodeResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetUserAttributeVerificationCodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUserAttributeVerificationCodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUserAttributeVerificationCodeRequest, GetUserAttributeVerificationCodeResponse>()
                            .withOperationName("GetUserAttributeVerificationCode").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUserAttributeVerificationCodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUserAttributeVerificationCodeRequest));
            CompletableFuture<GetUserAttributeVerificationCodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the authentication options for the currently signed-in user. Returns the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * The user's multi-factor authentication (MFA) preferences.
     * </p>
     * </li>
     * <li>
     * <p>
     * The user's options for choice-based authentication with the <code>USER_AUTH</code> flow.
     * </p>
     * </li>
     * </ol>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param getUserAuthFactorsRequest
     * @return A Java Future containing the result of the GetUserAuthFactors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUserAuthFactors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAuthFactors"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserAuthFactorsResponse> getUserAuthFactors(GetUserAuthFactorsRequest getUserAuthFactorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserAuthFactorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserAuthFactorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserAuthFactors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUserAuthFactorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUserAuthFactorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUserAuthFactorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUserAuthFactorsRequest, GetUserAuthFactorsResponse>()
                            .withOperationName("GetUserAuthFactors").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUserAuthFactorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUserAuthFactorsRequest));
            CompletableFuture<GetUserAuthFactorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID, returns configuration for sign-in with WebAuthn authenticators and for multi-factor
     * authentication (MFA). This operation describes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The WebAuthn relying party (RP) ID and user-verification settings.
     * </p>
     * </li>
     * <li>
     * <p>
     * The required, optional, or disabled state of MFA for all user pool users.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message templates for email and SMS MFA.
     * </p>
     * </li>
     * <li>
     * <p>
     * The enabled or disabled state of time-based one-time password (TOTP) MFA.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param getUserPoolMfaConfigRequest
     * @return A Java Future containing the result of the GetUserPoolMfaConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUserPoolMfaConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserPoolMfaConfigResponse> getUserPoolMfaConfig(
            GetUserPoolMfaConfigRequest getUserPoolMfaConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserPoolMfaConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserPoolMfaConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserPoolMfaConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUserPoolMfaConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUserPoolMfaConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUserPoolMfaConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUserPoolMfaConfigRequest, GetUserPoolMfaConfigResponse>()
                            .withOperationName("GetUserPoolMfaConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUserPoolMfaConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUserPoolMfaConfigRequest));
            CompletableFuture<GetUserPoolMfaConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user. Call this operation
     * when your user signs out of your app. This results in the following behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts <i>token-authorized</i> user operations that you authorize with a signed-out
     * user's access tokens. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * <p>
     * Amazon Cognito returns an <code>Access Token has been revoked</code> error when your app attempts to authorize a
     * user pools API request with a revoked access token that contains the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's ID token in a <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetId.html">GetId </a> request to an
     * identity pool with <code>ServerSideTokenCheck</code> enabled for its user pool IdP configuration in <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_CognitoIdentityProvider.html"
     * >CognitoIdentityProvider</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's refresh tokens in refresh requests.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Other requests might be valid until your user's token expires. This operation doesn't clear the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html">managed
     * login</a> session cookie. To clear the session for a user who signed in with managed login or the classic hosted
     * UI, direct their browser session to the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/logout-endpoint.html">logout endpoint</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param globalSignOutRequest
     *        Represents the request to sign out all devices.
     * @return A Java Future containing the result of the GlobalSignOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GlobalSignOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GlobalSignOut" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GlobalSignOutResponse> globalSignOut(GlobalSignOutRequest globalSignOutRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(globalSignOutRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, globalSignOutRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GlobalSignOut");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GlobalSignOutResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GlobalSignOutResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GlobalSignOutResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GlobalSignOutRequest, GlobalSignOutResponse>()
                            .withOperationName("GlobalSignOut").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GlobalSignOutRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(globalSignOutRequest));
            CompletableFuture<GlobalSignOutResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Declares an authentication flow and initiates sign-in for a user in the Amazon Cognito user directory. Amazon
     * Cognito might respond with an additional challenge or an <code>AuthenticationResult</code> that contains the
     * outcome of a successful authentication. You can't sign in a user with a federated IdP with
     * <code>InitiateAuth</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication.html">Authentication</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param initiateAuthRequest
     *        Initiates the authentication request.
     * @return A Java Future containing the result of the InitiateAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedOperationException Exception that is thrown when you attempt to perform an operation that
     *         isn't enabled for the user pool client.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.InitiateAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/InitiateAuth" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<InitiateAuthResponse> initiateAuth(InitiateAuthRequest initiateAuthRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(initiateAuthRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, initiateAuthRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "InitiateAuth");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<InitiateAuthResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    InitiateAuthResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<InitiateAuthResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<InitiateAuthRequest, InitiateAuthResponse>()
                            .withOperationName("InitiateAuth").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new InitiateAuthRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(initiateAuthRequest));
            CompletableFuture<InitiateAuthResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the devices that Amazon Cognito has registered to the currently signed-in user. For more information about
     * device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param listDevicesRequest
     *        Represents the request to list the devices.
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDevicesResponse> listDevices(ListDevicesRequest listDevicesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDevicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDevices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDevicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListDevicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDevicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDevicesRequest, ListDevicesResponse>()
                            .withOperationName("ListDevices").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDevicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDevicesRequest));
            CompletableFuture<ListDevicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID, returns user pool groups and their details.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>().withOperationName("ListGroups")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGroupsRequest));
            CompletableFuture<ListGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID, returns information about configured identity providers (IdPs). For more information about
     * IdPs, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html"
     * >Third-party IdP sign-in</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listIdentityProvidersRequest
     * @return A Java Future containing the result of the ListIdentityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIdentityProvidersResponse> listIdentityProviders(
            ListIdentityProvidersRequest listIdentityProvidersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIdentityProvidersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIdentityProvidersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIdentityProviders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIdentityProvidersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIdentityProvidersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIdentityProvidersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIdentityProvidersRequest, ListIdentityProvidersResponse>()
                            .withOperationName("ListIdentityProviders").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListIdentityProvidersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listIdentityProvidersRequest));
            CompletableFuture<ListIdentityProvidersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID, returns all resource servers and their details. For more information about resource
     * servers, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-define-resource-servers.html"
     * >Access control with resource servers</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listResourceServersRequest
     * @return A Java Future containing the result of the ListResourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListResourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceServersResponse> listResourceServers(
            ListResourceServersRequest listResourceServersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourceServersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceServersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceServers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceServersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceServersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourceServersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceServersRequest, ListResourceServersResponse>()
                            .withOperationName("ListResourceServers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResourceServersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResourceServersRequest));
            CompletableFuture<ListResourceServersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags that are assigned to an Amazon Cognito user pool. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/tagging.html">Tagging resources</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID, returns user import jobs and their details. Import jobs are retained in user pool
     * configuration so that you can stage, stop, start, review, and delete them. For more information about user
     * import, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-using-import-tool.html"
     * >Importing users from a CSV file</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUserImportJobsRequest
     *        Represents the request to list the user import jobs.
     * @return A Java Future containing the result of the ListUserImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUserImportJobsResponse> listUserImportJobs(ListUserImportJobsRequest listUserImportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUserImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUserImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListUserImportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUserImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUserImportJobsRequest, ListUserImportJobsResponse>()
                            .withOperationName("ListUserImportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUserImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUserImportJobsRequest));
            CompletableFuture<ListUserImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID, lists app clients. App clients are sets of rules for the access that you want a user pool
     * to grant to one application. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html">App
     * clients</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUserPoolClientsRequest
     *        Represents the request to list the user pool clients.
     * @return A Java Future containing the result of the ListUserPoolClients operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPoolClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUserPoolClientsResponse> listUserPoolClients(
            ListUserPoolClientsRequest listUserPoolClientsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUserPoolClientsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserPoolClientsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserPoolClients");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUserPoolClientsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListUserPoolClientsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUserPoolClientsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUserPoolClientsRequest, ListUserPoolClientsResponse>()
                            .withOperationName("ListUserPoolClients").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUserPoolClientsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUserPoolClientsRequest));
            CompletableFuture<ListUserPoolClientsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists user pools and their details in the current Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUserPoolsRequest
     *        Represents the request to list user pools.
     * @return A Java Future containing the result of the ListUserPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUserPoolsResponse> listUserPools(ListUserPoolsRequest listUserPoolsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUserPoolsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserPoolsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserPools");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUserPoolsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListUserPoolsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUserPoolsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUserPoolsRequest, ListUserPoolsResponse>()
                            .withOperationName("ListUserPools").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUserPoolsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUserPoolsRequest));
            CompletableFuture<ListUserPoolsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID, returns a list of users and their basic details in a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUsersRequest
     *        Represents the request to list users.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListUsersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUsersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUsersRequest, ListUsersResponse>().withOperationName("ListUsers")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUsersRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listUsersRequest));
            CompletableFuture<ListUsersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool ID and a group name, returns a list of users in the group. For more information about user pool
     * groups, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-user-groups.html">Adding
     * groups to a user pool</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUsersInGroupRequest
     * @return A Java Future containing the result of the ListUsersInGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsersInGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUsersInGroupResponse> listUsersInGroup(ListUsersInGroupRequest listUsersInGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUsersInGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsersInGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsersInGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUsersInGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListUsersInGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUsersInGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUsersInGroupRequest, ListUsersInGroupResponse>()
                            .withOperationName("ListUsersInGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUsersInGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUsersInGroupRequest));
            CompletableFuture<ListUsersInGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates a list of the currently signed-in user's registered passkey, or WebAuthn, credentials.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param listWebAuthnCredentialsRequest
     * @return A Java Future containing the result of the ListWebAuthnCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListWebAuthnCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListWebAuthnCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWebAuthnCredentialsResponse> listWebAuthnCredentials(
            ListWebAuthnCredentialsRequest listWebAuthnCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWebAuthnCredentialsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWebAuthnCredentialsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWebAuthnCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWebAuthnCredentialsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWebAuthnCredentialsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWebAuthnCredentialsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWebAuthnCredentialsRequest, ListWebAuthnCredentialsResponse>()
                            .withOperationName("ListWebAuthnCredentials").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWebAuthnCredentialsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWebAuthnCredentialsRequest));
            CompletableFuture<ListWebAuthnCredentialsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resends the code that confirms a new account for a user who has signed up in your user pool. Amazon Cognito sends
     * confirmation codes to the user attribute in the <code>AutoVerifiedAttributes</code> property of your user pool.
     * When you prompt new users for the confirmation code, include a "Resend code" option that generates a call to this
     * API operation.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param resendConfirmationCodeRequest
     *        Represents the request to resend the confirmation code.
     * @return A Java Future containing the result of the ResendConfirmationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ResendConfirmationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ResendConfirmationCode"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResendConfirmationCodeResponse> resendConfirmationCode(
            ResendConfirmationCodeRequest resendConfirmationCodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resendConfirmationCodeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resendConfirmationCodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResendConfirmationCode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResendConfirmationCodeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ResendConfirmationCodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResendConfirmationCodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResendConfirmationCodeRequest, ResendConfirmationCodeResponse>()
                            .withOperationName("ResendConfirmationCode").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ResendConfirmationCodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(resendConfirmationCodeRequest));
            CompletableFuture<ResendConfirmationCodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for device authentication
     * that bypasses MFA, or for a custom authentication challenge. A <code>RespondToAuthChallenge</code> API request
     * provides the answer to that challenge, like a code or a secure remote password (SRP). The parameters of a
     * response to an authentication challenge vary with the type of challenge.
     * </p>
     * <p>
     * For more information about custom authentication challenges, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">Custom
     * authentication challenge Lambda triggers</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param respondToAuthChallengeRequest
     *        The request to respond to an authentication challenge.
     * @return A Java Future containing the result of the RespondToAuthChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>PasswordHistoryPolicyViolationException The message returned when a user's new password matches a
     *         previous password and doesn't comply with the password-history policy.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito can't find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.RespondToAuthChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RespondToAuthChallengeResponse> respondToAuthChallenge(
            RespondToAuthChallengeRequest respondToAuthChallengeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(respondToAuthChallengeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, respondToAuthChallengeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RespondToAuthChallenge");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RespondToAuthChallengeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RespondToAuthChallengeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RespondToAuthChallengeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RespondToAuthChallengeRequest, RespondToAuthChallengeResponse>()
                            .withOperationName("RespondToAuthChallenge").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RespondToAuthChallengeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(respondToAuthChallengeRequest));
            CompletableFuture<RespondToAuthChallengeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Revokes all of the access tokens generated by, and at the same time as, the specified refresh token. After a
     * token is revoked, you can't use the revoked token to access Amazon Cognito user APIs, or to authorize access to
     * your resource server.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param revokeTokenRequest
     * @return A Java Future containing the result of the RevokeToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>UnauthorizedException Exception that is thrown when the request isn't authorized. This can happen due
     *         to an invalid access token in the request.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedOperationException Exception that is thrown when you attempt to perform an operation that
     *         isn't enabled for the user pool client.</li>
     *         <li>UnsupportedTokenTypeException Exception that is thrown when an unsupported token is passed to an
     *         operation.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.RevokeToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RevokeToken" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RevokeTokenResponse> revokeToken(RevokeTokenRequest revokeTokenRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(revokeTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, revokeTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RevokeTokenResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    RevokeTokenResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RevokeTokenResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RevokeTokenRequest, RevokeTokenResponse>()
                            .withOperationName("RevokeToken").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RevokeTokenRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(revokeTokenRequest));
            CompletableFuture<RevokeTokenResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets up or modifies the logging configuration of a user pool. User pools can export user notification logs and,
     * when threat protection is active, user-activity logs. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/exporting-quotas-and-usage.html">Exporting user
     * pool logs</a>.
     * </p>
     *
     * @param setLogDeliveryConfigurationRequest
     * @return A Java Future containing the result of the SetLogDeliveryConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>FeatureUnavailableInTierException This exception is thrown when a feature you attempted to configure
     *         isn't available in your current feature plan.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetLogDeliveryConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetLogDeliveryConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetLogDeliveryConfigurationResponse> setLogDeliveryConfiguration(
            SetLogDeliveryConfigurationRequest setLogDeliveryConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setLogDeliveryConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setLogDeliveryConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetLogDeliveryConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetLogDeliveryConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetLogDeliveryConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetLogDeliveryConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetLogDeliveryConfigurationRequest, SetLogDeliveryConfigurationResponse>()
                            .withOperationName("SetLogDeliveryConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetLogDeliveryConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setLogDeliveryConfigurationRequest));
            CompletableFuture<SetLogDeliveryConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Configures threat protection for a user pool or app client. Sets configuration for the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Responses to risks with adaptive authentication
     * </p>
     * </li>
     * <li>
     * <p>
     * Responses to vulnerable passwords with compromised-credentials detection
     * </p>
     * </li>
     * <li>
     * <p>
     * Notifications to users who have had risky activity detected
     * </p>
     * </li>
     * <li>
     * <p>
     * IP-address denylist and allowlist
     * </p>
     * </li>
     * </ul>
     * <p>
     * To set the risk configuration for the user pool to defaults, send this request with only the
     * <code>UserPoolId</code> parameter. To reset the threat protection settings of an app client to be inherited from
     * the user pool, send <code>UserPoolId</code> and <code>ClientId</code> parameters only. To change threat
     * protection to audit-only or off, update the value of <code>UserPoolAddOns</code> in an
     * <code>UpdateUserPool</code> request. To activate this setting, your user pool must be on the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-plus.html"> Plus tier</a>.
     * </p>
     *
     * @param setRiskConfigurationRequest
     * @return A Java Future containing the result of the SetRiskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetRiskConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetRiskConfigurationResponse> setRiskConfiguration(
            SetRiskConfigurationRequest setRiskConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setRiskConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setRiskConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetRiskConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetRiskConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetRiskConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetRiskConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetRiskConfigurationRequest, SetRiskConfigurationResponse>()
                            .withOperationName("SetRiskConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetRiskConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setRiskConfigurationRequest));
            CompletableFuture<SetRiskConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Configures UI branding settings for domains with the hosted UI (classic) branding version. Your user pool must
     * have a domain. Configure a domain with .
     * </p>
     * <p>
     * Set the default configuration for all clients with a <code>ClientId</code> of <code>ALL</code>. When the
     * <code>ClientId</code> value is an app client ID, the settings you pass in this request apply to that app client
     * and override the default <code>ALL</code> configuration.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param setUiCustomizationRequest
     * @return A Java Future containing the result of the SetUICustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUICustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUICustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetUiCustomizationResponse> setUICustomization(SetUiCustomizationRequest setUiCustomizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setUiCustomizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setUiCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetUICustomization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetUiCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetUiCustomizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetUiCustomizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetUiCustomizationRequest, SetUiCustomizationResponse>()
                            .withOperationName("SetUICustomization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetUiCustomizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setUiCustomizationRequest));
            CompletableFuture<SetUiCustomizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are activated and
     * if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to
     * authenticate a user if multiple factors are activated. If multiple options are activated and no preference is
     * set, a challenge to choose an MFA option will be returned during sign-in. If an MFA type is activated for a user,
     * the user will be prompted for MFA during all sign-in attempts unless device tracking is turned on and the device
     * has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts,
     * deactivate MFA for users and turn on Adaptive Authentication for the user pool.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param setUserMfaPreferenceRequest
     * @return A Java Future containing the result of the SetUserMFAPreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserMFAPreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetUserMfaPreferenceResponse> setUserMFAPreference(
            SetUserMfaPreferenceRequest setUserMfaPreferenceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setUserMfaPreferenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setUserMfaPreferenceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetUserMFAPreference");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetUserMfaPreferenceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetUserMfaPreferenceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetUserMfaPreferenceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetUserMfaPreferenceRequest, SetUserMfaPreferenceResponse>()
                            .withOperationName("SetUserMFAPreference").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetUserMfaPreferenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setUserMfaPreferenceRequest));
            CompletableFuture<SetUserMfaPreferenceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets user pool multi-factor authentication (MFA) and passkey configuration. For more information about user pool
     * MFA, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa.html">Adding
     * MFA</a>. For more information about WebAuthn passkeys see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html#amazon-cognito-user-pools-authentication-flow-methods-passkey"
     * >Authentication flows</a>.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param setUserPoolMfaConfigRequest
     * @return A Java Future containing the result of the SetUserPoolMfaConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>FeatureUnavailableInTierException This exception is thrown when a feature you attempted to configure
     *         isn't available in your current feature plan.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserPoolMfaConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetUserPoolMfaConfigResponse> setUserPoolMfaConfig(
            SetUserPoolMfaConfigRequest setUserPoolMfaConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setUserPoolMfaConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setUserPoolMfaConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetUserPoolMfaConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetUserPoolMfaConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetUserPoolMfaConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetUserPoolMfaConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetUserPoolMfaConfigRequest, SetUserPoolMfaConfigResponse>()
                            .withOperationName("SetUserPoolMfaConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetUserPoolMfaConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setUserPoolMfaConfigRequest));
            CompletableFuture<SetUserPoolMfaConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to
     * configure time-based one-time password (TOTP) software token or email MFA.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param setUserSettingsRequest
     *        Represents the request to set user settings.
     * @return A Java Future containing the result of the SetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SetUserSettingsResponse> setUserSettings(SetUserSettingsRequest setUserSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setUserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetUserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetUserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetUserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetUserSettingsRequest, SetUserSettingsResponse>()
                            .withOperationName("SetUserSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetUserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setUserSettingsRequest));
            CompletableFuture<SetUserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers a user with an app client and requests a user name, password, and user attributes in the user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * You might receive a <code>LimitExceeded</code> exception in response to this request if you have exceeded a rate
     * quota for email or SMS messages, and if your user pool automatically verifies email addresses or phone numbers.
     * When you get this exception in the response, the user is successfully created and is in an
     * <code>UNCONFIRMED</code> state.
     * </p>
     *
     * @param signUpRequest
     *        Represents the request to register a user.
     * @return A Java Future containing the result of the SignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SignUp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SignUpResponse> signUp(SignUpRequest signUpRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(signUpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, signUpRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SignUp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SignUpResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SignUpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SignUpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SignUpRequest, SignUpResponse>().withOperationName("SignUp")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new SignUpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(signUpRequest));
            CompletableFuture<SignUpResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Instructs your user pool to start importing users from a CSV file that contains their usernames and attributes.
     * For more information about importing users from a CSV file, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-using-import-tool.html"
     * >Importing users from a CSV file</a>.
     * </p>
     *
     * @param startUserImportJobRequest
     *        Represents the request to start the user import job.
     * @return A Java Future containing the result of the StartUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StartUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StartUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartUserImportJobResponse> startUserImportJob(StartUserImportJobRequest startUserImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startUserImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startUserImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartUserImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartUserImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartUserImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartUserImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartUserImportJobRequest, StartUserImportJobResponse>()
                            .withOperationName("StartUserImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartUserImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startUserImportJobRequest));
            CompletableFuture<StartUserImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests credential creation options from your user pool for the currently signed-in user. Returns information
     * about the user pool, the user profile, and authentication requirements. Users must provide this information in
     * their request to enroll your application with their passkey provider.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     *
     * @param startWebAuthnRegistrationRequest
     * @return A Java Future containing the result of the StartWebAuthnRegistration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>WebAuthnNotEnabledException This exception is thrown when the passkey feature isn't enabled for the
     *         user pool.</li>
     *         <li>WebAuthnConfigurationMissingException This exception is thrown when a user pool doesn't have a
     *         configured relying party id or a user pool domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StartWebAuthnRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StartWebAuthnRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartWebAuthnRegistrationResponse> startWebAuthnRegistration(
            StartWebAuthnRegistrationRequest startWebAuthnRegistrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startWebAuthnRegistrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startWebAuthnRegistrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartWebAuthnRegistration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartWebAuthnRegistrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartWebAuthnRegistrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartWebAuthnRegistrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartWebAuthnRegistrationRequest, StartWebAuthnRegistrationResponse>()
                            .withOperationName("StartWebAuthnRegistration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartWebAuthnRegistrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startWebAuthnRegistrationRequest));
            CompletableFuture<StartWebAuthnRegistrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Instructs your user pool to stop a running job that's importing users from a CSV file that contains their
     * usernames and attributes. For more information about importing users from a CSV file, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-using-import-tool.html"
     * >Importing users from a CSV file</a>.
     * </p>
     *
     * @param stopUserImportJobRequest
     *        Represents the request to stop the user import job.
     * @return A Java Future containing the result of the StopUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StopUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StopUserImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StopUserImportJobResponse> stopUserImportJob(StopUserImportJobRequest stopUserImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopUserImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopUserImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopUserImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopUserImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopUserImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopUserImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopUserImportJobRequest, StopUserImportJobResponse>()
                            .withOperationName("StopUserImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopUserImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopUserImportJobRequest));
            CompletableFuture<StopUserImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage
     * user pools in different ways, such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific
     * values. For example, if you have two versions of a user pool, one for testing and another for production, you
     * might assign an <code>Environment</code> tag key to both user pools. The value of this key might be
     * <code>Test</code> for one user pool, and <code>Production</code> for the other.
     * </p>
     * <p>
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the
     * Billing and Cost Management console, where you can track the costs associated with your user pools. In an
     * Identity and Access Management policy, you can constrain permissions for user pools based on specific tags or tag
     * values.
     * </p>
     * <p>
     * You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given tag IDs that you previously assigned to a user pool, removes them.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the feedback for an authentication event generated by threat protection features. The user's response
     * indicates that you think that the event either was from a valid user or was an unwanted authentication attempt.
     * This feedback improves the risk evaluation decision for the user pool as part of Amazon Cognito threat
     * protection. To activate this setting, your user pool must be on the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-plus.html"> Plus tier</a>.
     * </p>
     * <p>
     * This operation requires a <code>FeedbackToken</code> that Amazon Cognito generates and adds to notification
     * emails when users have potentially suspicious authentication events. Users invoke this operation when they select
     * the link that corresponds to <code>{one-click-link-valid}</code> or <code>{one-click-link-invalid}</code> in your
     * notification template. Because <code>FeedbackToken</code> is a required parameter, you can' make requests to
     * <code>UpdateAuthEventFeedback</code> without the contents of the notification email message.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param updateAuthEventFeedbackRequest
     * @return A Java Future containing the result of the UpdateAuthEventFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateAuthEventFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAuthEventFeedbackResponse> updateAuthEventFeedback(
            UpdateAuthEventFeedbackRequest updateAuthEventFeedbackRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAuthEventFeedbackRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAuthEventFeedbackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAuthEventFeedback");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAuthEventFeedbackResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAuthEventFeedbackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAuthEventFeedbackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAuthEventFeedbackRequest, UpdateAuthEventFeedbackResponse>()
                            .withOperationName("UpdateAuthEventFeedback").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAuthEventFeedbackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAuthEventFeedbackRequest));
            CompletableFuture<UpdateAuthEventFeedbackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the status of a the currently signed-in user's device so that it is marked as remembered or not
     * remembered for the purpose of device authentication. Device authentication is a "remember me" mechanism that
     * silently completes sign-in from trusted devices with a device key instead of a user-provided MFA code. This
     * operation changes the status of a device without deleting it, so you can enable it again later. For more
     * information about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with devices</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param updateDeviceStatusRequest
     *        Represents the request to update the device status.
     * @return A Java Future containing the result of the UpdateDeviceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateDeviceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDeviceStatusResponse> updateDeviceStatus(UpdateDeviceStatusRequest updateDeviceStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDeviceStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDeviceStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDeviceStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDeviceStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDeviceStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDeviceStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDeviceStatusRequest, UpdateDeviceStatusResponse>()
                            .withOperationName("UpdateDeviceStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDeviceStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDeviceStatusRequest));
            CompletableFuture<UpdateDeviceStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given the name of a user pool group, updates any of the properties for precedence, IAM role, or description. For
     * more information about user pool groups, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-user-groups.html">Adding
     * groups to a user pool</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGroupRequest, UpdateGroupResponse>()
                            .withOperationName("UpdateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateGroupRequest));
            CompletableFuture<UpdateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the configuration and trust relationship between a third-party identity provider (IdP) and a user pool.
     * Amazon Cognito accepts sign-in with third-party identity providers through managed login and OIDC relying-party
     * libraries. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html"
     * >Third-party IdP sign-in</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateIdentityProviderRequest
     * @return A Java Future containing the result of the UpdateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedIdentityProviderException This exception is thrown when the specified identifier isn't
     *         supported.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateIdentityProviderResponse> updateIdentityProvider(
            UpdateIdentityProviderRequest updateIdentityProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIdentityProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateIdentityProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIdentityProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse>()
                            .withOperationName("UpdateIdentityProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateIdentityProviderRequest));
            CompletableFuture<UpdateIdentityProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Configures the branding settings for a user pool style. This operation is the programmatic option for the
     * configuration of a style in the branding designer.
     * </p>
     * <p>
     * Provides values for UI customization in a <code>Settings</code> JSON object and image files in an
     * <code>Assets</code> array.
     * </p>
     * <p>
     * This operation has a 2-megabyte request-size limit and include the CSS settings and image assets for your app
     * client. Your branding settings might exceed 2MB in size. Amazon Cognito doesn't require that you pass all
     * parameters in one request and preserves existing style settings that you don't specify. If your request is larger
     * than 2MB, separate it into multiple requests, each with a size smaller than the limit.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateManagedLoginBrandingRequest
     * @return A Java Future containing the result of the UpdateManagedLoginBranding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateManagedLoginBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateManagedLoginBranding"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateManagedLoginBrandingResponse> updateManagedLoginBranding(
            UpdateManagedLoginBrandingRequest updateManagedLoginBrandingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateManagedLoginBrandingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateManagedLoginBrandingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateManagedLoginBranding");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateManagedLoginBrandingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateManagedLoginBrandingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateManagedLoginBrandingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateManagedLoginBrandingRequest, UpdateManagedLoginBrandingResponse>()
                            .withOperationName("UpdateManagedLoginBranding").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateManagedLoginBrandingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateManagedLoginBrandingRequest));
            CompletableFuture<UpdateManagedLoginBrandingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the name and scopes of a resource server. All other fields are read-only. For more information about
     * resource servers, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-define-resource-servers.html"
     * >Access control with resource servers</a>.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, it is set to the default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateResourceServerRequest
     * @return A Java Future containing the result of the UpdateResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResourceServerResponse> updateResourceServer(
            UpdateResourceServerRequest updateResourceServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResourceServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResourceServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResourceServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResourceServerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResourceServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResourceServerRequest, UpdateResourceServerResponse>()
                            .withOperationName("UpdateResourceServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateResourceServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateResourceServerRequest));
            CompletableFuture<UpdateResourceServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the currently signed-in user's attributes. To delete an attribute from the user, submit the attribute in
     * your API request with a blank value.
     * </p>
     * <p>
     * For custom attributes, you must add a <code>custom:</code> prefix to the attribute name, for example
     * <code>custom:department</code>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param updateUserAttributesRequest
     *        Represents the request to update user attributes.
     * @return A Java Future containing the result of the UpdateUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserAttributesResponse> updateUserAttributes(
            UpdateUserAttributesRequest updateUserAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUserAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUserAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateUserAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUserAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUserAttributesRequest, UpdateUserAttributesResponse>()
                            .withOperationName("UpdateUserAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateUserAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateUserAttributesRequest));
            CompletableFuture<UpdateUserAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of a user pool. To avoid setting parameters to Amazon Cognito defaults, construct this
     * API request to pass the existing configuration of your user pool, modified to include the changes that you want
     * to make.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateUserPoolRequest
     *        Represents the request to update the user pool.
     * @return A Java Future containing the result of the UpdateUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you're trying to modify a user pool while
     *         a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag can't be set or updated.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>TierChangeNotAllowedException This exception is thrown when you've attempted to change your feature
     *         plan but the operation isn't permitted.</li>
     *         <li>FeatureUnavailableInTierException This exception is thrown when a feature you attempted to configure
     *         isn't available in your current feature plan.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserPoolResponse> updateUserPool(UpdateUserPoolRequest updateUserPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUserPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUserPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateUserPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUserPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUserPoolRequest, UpdateUserPoolResponse>()
                            .withOperationName("UpdateUserPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateUserPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateUserPoolRequest));
            CompletableFuture<UpdateUserPoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Given a user pool app client ID, updates the configuration. To avoid setting parameters to Amazon Cognito
     * defaults, construct this API request to pass the existing configuration of your app client, modified to include
     * the changes that you want to make.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important>
     * <p>
     * Unlike app clients created in the console, Amazon Cognito doesn't automatically assign a branding style to app
     * clients that you configure with this API operation. Managed login and classic hosted UI pages aren't available
     * for your client until after you apply a branding style.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateUserPoolClientRequest
     *        Represents the request to update the user pool client.
     * @return A Java Future containing the result of the UpdateUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ScopeDoesNotExistException This exception is thrown when the specified scope doesn't exist.</li>
     *         <li>InvalidOAuthFlowException This exception is thrown when the specified OAuth flow is not valid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>FeatureUnavailableInTierException This exception is thrown when a feature you attempted to configure
     *         isn't available in your current feature plan.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserPoolClientResponse> updateUserPoolClient(
            UpdateUserPoolClientRequest updateUserPoolClientRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserPoolClientRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserPoolClientRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUserPoolClient");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUserPoolClientResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateUserPoolClientResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUserPoolClientResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUserPoolClientRequest, UpdateUserPoolClientResponse>()
                            .withOperationName("UpdateUserPoolClient").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateUserPoolClientRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateUserPoolClientRequest));
            CompletableFuture<UpdateUserPoolClientResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A user pool domain hosts managed login, an authorization server and web server for authentication in your
     * application. This operation updates the branding version for user pool domains between <code>1</code> for hosted
     * UI (classic) and <code>2</code> for managed login. It also updates the SSL certificate for user pool custom
     * domains.
     * </p>
     * <p>
     * Changes to the domain branding version take up to one minute to take effect for a prefix domain and up to five
     * minutes for a custom domain.
     * </p>
     * <p>
     * This operation doesn't change the name of your user pool domain. To change your domain, delete it with
     * <code>DeleteUserPoolDomain</code> and create a new domain with <code>CreateUserPoolDomain</code>.
     * </p>
     * <p>
     * You can pass the ARN of a new Certificate Manager certificate in this request. Typically, ACM certificates
     * automatically renew and you user pool can continue to use the same ARN. But if you generate a new certificate for
     * your custom domain name, replace the original configuration with the new ARN in this request.
     * </p>
     * <p>
     * ACM certificates for custom domains must be in the US East (N. Virginia) Amazon Web Services Region. After you
     * submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your custom
     * domain.
     * </p>
     * <p>
     * For more information about adding a custom domain to your user pool, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html"
     * >Configuring a user pool domain</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateUserPoolDomainRequest
     *        The UpdateUserPoolDomain request input.
     * @return A Java Future containing the result of the UpdateUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>FeatureUnavailableInTierException This exception is thrown when a feature you attempted to configure
     *         isn't available in your current feature plan.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserPoolDomainResponse> updateUserPoolDomain(
            UpdateUserPoolDomainRequest updateUserPoolDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserPoolDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserPoolDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUserPoolDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUserPoolDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateUserPoolDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUserPoolDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUserPoolDomainRequest, UpdateUserPoolDomainResponse>()
                            .withOperationName("UpdateUserPoolDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateUserPoolDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateUserPoolDomainRequest));
            CompletableFuture<UpdateUserPoolDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers the current user's time-based one-time password (TOTP) authenticator with a code generated in their
     * authenticator app from a private key that's supplied by your user pool. Marks the user's software token MFA
     * status as "verified" if successful. The request takes an access token or a session string, but not both.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param verifySoftwareTokenRequest
     * @return A Java Future containing the result of the VerifySoftwareToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>EnableSoftwareTokenMfaException This exception is thrown when there is a code mismatch and the
     *         service fails to configure the software token TOTP multi-factor authentication (MFA).</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.VerifySoftwareToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifySoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<VerifySoftwareTokenResponse> verifySoftwareToken(
            VerifySoftwareTokenRequest verifySoftwareTokenRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(verifySoftwareTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, verifySoftwareTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "VerifySoftwareToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<VerifySoftwareTokenResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, VerifySoftwareTokenResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<VerifySoftwareTokenResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<VerifySoftwareTokenRequest, VerifySoftwareTokenResponse>()
                            .withOperationName("VerifySoftwareToken").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new VerifySoftwareTokenRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(verifySoftwareTokenRequest));
            CompletableFuture<VerifySoftwareTokenResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Submits a verification code for a signed-in user who has added or changed a value of an auto-verified attribute.
     * When successful, the user's attribute becomes verified and the attribute <code>email_verified</code> or
     * <code>phone_number_verified</code> becomes <code>true</code>.
     * </p>
     * <p>
     * If your user pool requires verification before Amazon Cognito updates the attribute value, this operation updates
     * the affected attribute to its pending value.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param verifyUserAttributeRequest
     *        Represents the request to verify user attributes.
     * @return A Java Future containing the result of the VerifyUserAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.VerifyUserAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifyUserAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<VerifyUserAttributeResponse> verifyUserAttribute(
            VerifyUserAttributeRequest verifyUserAttributeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(verifyUserAttributeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, verifyUserAttributeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "VerifyUserAttribute");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<VerifyUserAttributeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, VerifyUserAttributeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<VerifyUserAttributeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<VerifyUserAttributeRequest, VerifyUserAttributeResponse>()
                            .withOperationName("VerifyUserAttribute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new VerifyUserAttributeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(verifyUserAttributeRequest));
            CompletableFuture<VerifyUserAttributeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final CognitoIdentityProviderServiceClientConfiguration serviceClientConfiguration() {
        return new CognitoIdentityProviderServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(CognitoIdentityProviderException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException")
                                .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                                .exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException")
                                .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserImportInProgressException")
                                .exceptionBuilderSupplier(UserImportInProgressException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException")
                                .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ExpiredCodeException")
                                .exceptionBuilderSupplier(ExpiredCodeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserNotFoundException")
                                .exceptionBuilderSupplier(UserNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPasswordException")
                                .exceptionBuilderSupplier(InvalidPasswordException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOperationException")
                                .exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotAuthorizedException")
                                .exceptionBuilderSupplier(NotAuthorizedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                                .exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PasswordResetRequiredException")
                                .exceptionBuilderSupplier(PasswordResetRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateProviderException")
                                .exceptionBuilderSupplier(DuplicateProviderException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                                .exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException")
                                .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                                .exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException")
                                .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalErrorException")
                                .exceptionBuilderSupplier(InternalErrorException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException")
                                .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException")
                                .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                                .exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                                .exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CodeMismatchException")
                                .exceptionBuilderSupplier(CodeMismatchException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException")
                                .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RefreshTokenReuseException")
                                .exceptionBuilderSupplier(RefreshTokenReuseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                                .exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UsernameExistsException")
                                .exceptionBuilderSupplier(UsernameExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException")
                                .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException")
                                .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException")
                                .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AliasExistsException")
                                .exceptionBuilderSupplier(AliasExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedUserStateException")
                                .exceptionBuilderSupplier(UnsupportedUserStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserNotConfirmedException")
                                .exceptionBuilderSupplier(UserNotConfirmedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeviceKeyExistsException")
                                .exceptionBuilderSupplier(DeviceKeyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnexpectedLambdaException")
                                .exceptionBuilderSupplier(UnexpectedLambdaException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserLambdaValidationException")
                                .exceptionBuilderSupplier(UserLambdaValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                                .exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException")
                                .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException")
                                .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException")
                                .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                                .exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionNotMetException")
                                .exceptionBuilderSupplier(PreconditionNotMetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                                .exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GroupExistsException")
                                .exceptionBuilderSupplier(GroupExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserPoolTaggingException")
                                .exceptionBuilderSupplier(UserPoolTaggingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                                .exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException")
                                .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CognitoIdentityProviderServiceClientConfigurationBuilder serviceConfigBuilder = new CognitoIdentityProviderServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
